/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.mobs.anticheese;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.enhancedai.modules.mobs.anticheese.BreakVehicleGoal;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:mobs", name="Anti-Cheese", description="Prevent players from abusing some game mechanics to stop mobs. Only mobs in the entity type tag enhancedai:can_use_anti_cheese will be affected by this feature. Only veichles in `enhancedai:anti_cheese_veichles` will be affected by this feature.")
public class AntiCheese
extends Feature {
    public static final TagKey<EntityType<?>> CAN_USE_ANTI_CHEESE = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("can_use_anti_cheese"));
    public static final TagKey<EntityType<?>> ANTI_CHEESE_VEICHLES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("anti_cheese_vehicles"));
    @Config(description="If true, 'Enemies' will no longer be able to be put in vehicles.")
    public static Boolean preventRidingVehicles = false;
    @Config(description="If true, 'Enemies' will break vehicles.")
    public static Boolean breakVehicles = true;

    public AntiCheese(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onMount(EntityMountEvent event) {
        if (!(this.isEnabled() && event.getEntityMounting() instanceof Enemy && event.getEntityBeingMounted().m_6095_().m_204039_(ANTI_CHEESE_VEICHLES) && event.getEntityMounting().m_6095_().m_204039_(CAN_USE_ANTI_CHEESE) && preventRidingVehicles.booleanValue())) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onJoinLevel(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity;
        if (!(this.isEnabled() && (entity = event.getEntity()) instanceof Mob && (mob = (Mob)entity).m_6095_().m_204039_(CAN_USE_ANTI_CHEESE) && breakVehicles.booleanValue())) {
            return;
        }
        mob.f_21345_.m_25352_(1, (Goal)new BreakVehicleGoal(mob));
    }
}

