/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.drowned;

import insane96mcp.enhancedai.EnhancedAI;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.util.MCUtils;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.SwimNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="enhancedai:drowned", description="Makes drowned swim speed based off swim speed attribute instead of movement speed. Only drowned in the enhancedai:change_drowned_swimming entity type tag are affected by this feature.")
public class Drowned
extends Feature {
    public static final TagKey<EntityType<?>> CHANGE_DROWNED_SWIMMING = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)EnhancedAI.location("change_drowned_swimming"));
    final UUID UUID_SWIM_SPEED_MULTIPLIER = UUID.fromString("ba2adf05-2438-4d1f-8165-89173f0a1eae");
    @Config(min=0.0, max=4.0, description="Multiplier for the swim speed of Drowned. Note that the swim speed is also affected by the Movement Feature. Set to 0 to disable the multiplier.")
    public static Double swimSpeedMultiplier = 0.3;
    @Config(description="Fixes a vanilla bug that makes drowned just stand still during daytime if can't reach water.")
    public static Boolean allowAttackDuringDay = true;

    public Drowned(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    public static boolean allowAttackDuringDay() {
        return Feature.isEnabled(Drowned.class) && allowAttackDuringDay != false;
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinLevelEvent event) {
        net.minecraft.world.entity.monster.Drowned drowned;
        Entity entity;
        if (!(this.isEnabled() && (entity = event.getEntity()) instanceof net.minecraft.world.entity.monster.Drowned && (drowned = (net.minecraft.world.entity.monster.Drowned)entity).m_6095_().m_204039_(CHANGE_DROWNED_SWIMMING))) {
            return;
        }
        drowned.f_21342_ = new EADrownedMoveControl(drowned);
        ((SwimNodeEvaluator)drowned.f_32340_.m_26575_()).f_77455_ = true;
        drowned.f_21345_.m_262460_(goal -> goal instanceof Drowned.DrownedSwimUpGoal);
        drowned.f_21345_.m_25352_(6, (Goal)new DrownedSwimUpGoal(drowned, 1.0, drowned.m_9236_().m_5736_()));
        if (swimSpeedMultiplier > 0.0) {
            MCUtils.applyModifier((LivingEntity)drowned, (Attribute)((Attribute)ForgeMod.SWIM_SPEED.get()), (UUID)this.UUID_SWIM_SPEED_MULTIPLIER, (String)"Enhanced AI Drowned Swim Speed Multiplier", (double)(swimSpeedMultiplier - 1.0), (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
        }
    }

    static class EADrownedMoveControl
    extends MoveControl {
        private final net.minecraft.world.entity.monster.Drowned drowned;

        public EADrownedMoveControl(net.minecraft.world.entity.monster.Drowned p_32433_) {
            super((Mob)p_32433_);
            this.drowned = p_32433_;
        }

        public void m_8126_() {
            LivingEntity livingentity = this.drowned.m_5448_();
            if (this.drowned.m_32392_() && this.drowned.m_20069_()) {
                if (livingentity != null && livingentity.m_20186_() > this.drowned.m_20186_() || this.drowned.f_32342_) {
                    this.drowned.m_20256_(this.drowned.m_20184_().m_82520_(0.0, 0.002, 0.0));
                }
                if (this.f_24981_ != MoveControl.Operation.MOVE_TO || this.drowned.m_21573_().m_26571_()) {
                    this.drowned.m_7910_(0.0f);
                    return;
                }
                double d0 = this.f_24975_ - this.drowned.m_20185_();
                double d1 = this.f_24976_ - this.drowned.m_20186_();
                double d2 = this.f_24977_ - this.drowned.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.drowned.m_146922_(this.m_24991_(this.drowned.m_146908_(), f, 90.0f));
                this.drowned.f_20883_ = this.drowned.m_146908_();
                float f1 = (float)(this.f_24978_ * this.drowned.m_21133_((Attribute)ForgeMod.SWIM_SPEED.get()));
                float f2 = Mth.m_14179_((float)1.0f, (float)this.drowned.m_6113_(), (float)f1);
                this.drowned.m_7910_(f2);
                this.drowned.m_20256_(this.drowned.m_20184_().m_82520_((double)f2 * d0 * 0.005, (double)f2 * d1 * 0.05, (double)f2 * d2 * 0.005));
                this.drowned.m_20124_(Pose.SWIMMING);
            } else {
                if (!this.drowned.m_20096_()) {
                    this.drowned.m_20256_(this.drowned.m_20184_().m_82520_(0.0, -0.008, 0.0));
                }
                this.drowned.m_20124_(Pose.STANDING);
                super.m_8126_();
            }
        }
    }

    static class DrownedSwimUpGoal
    extends Goal {
        private final net.minecraft.world.entity.monster.Drowned drowned;
        private final double speedModifier;
        private final int seaLevel;
        private boolean stuck;
        private int leapTick = 0;

        public DrownedSwimUpGoal(net.minecraft.world.entity.monster.Drowned pDrowned, double pSpeedModifier, int pSeaLevel) {
            this.drowned = pDrowned;
            this.speedModifier = pSpeedModifier;
            this.seaLevel = pSeaLevel;
        }

        public boolean m_8036_() {
            return this.drowned.m_20069_() && this.drowned.m_20186_() < (double)this.seaLevel;
        }

        public boolean m_8045_() {
            return this.m_8036_() && !this.stuck;
        }

        public void m_8037_() {
            if (this.drowned.m_20186_() < (double)(this.seaLevel - 1) && (this.drowned.m_21573_().m_26571_() || this.closeToNextPos())) {
                Vec3 vec3 = DefaultRandomPos.m_148412_((PathfinderMob)this.drowned, (int)4, (int)8, (Vec3)new Vec3(this.drowned.m_20185_(), (double)(this.seaLevel + 1), this.drowned.m_20189_()), (double)1.5707963705062866);
                if (vec3 == null) {
                    this.stuck = true;
                    return;
                }
                this.drowned.m_21573_().m_26519_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, this.speedModifier);
            }
            if (--this.leapTick <= 0 && this.drowned.m_20186_() >= (double)(this.seaLevel - 1)) {
                LivingEntity target = this.drowned.m_5448_();
                if (target != null && !target.m_20069_() && target.m_20096_()) {
                    Vec3 dir = new Vec3(target.m_20185_() - this.drowned.m_20185_(), target.m_20186_() - this.drowned.m_20186_(), target.m_20189_() - this.drowned.m_20189_()).m_82541_();
                    this.drowned.m_20256_(new Vec3(dir.f_82479_ * 0.5, 0.5, dir.f_82481_ * 0.5));
                    this.drowned.m_21573_().m_26573_();
                    this.m_8041_();
                }
                this.leapTick = 10;
            }
        }

        public void m_8056_() {
            this.drowned.m_32398_(true);
            this.stuck = false;
        }

        public void m_8041_() {
            this.drowned.m_32398_(false);
        }

        protected boolean closeToNextPos() {
            Path path = this.drowned.m_21573_().m_26570_();
            if (path == null) {
                return false;
            }
            BlockPos blockpos = path.m_77406_();
            double d0 = this.drowned.m_20275_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_());
            return d0 < 4.0;
        }
    }
}

