/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.item.curio.movement;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import org.confluence.mod.capability.ability.AbilityProvider;

public interface IFallResistance {
    public static final Component TOOLTIP = Component.m_237115_((String)"curios.tooltip.fall_resistance");

    public int getFallResistance();

    public static float apply(LivingEntity living, DamageSource damageSource, float amount) {
        if (!damageSource.m_276093_(DamageTypes.f_268671_)) {
            return amount;
        }
        AtomicInteger atomic = new AtomicInteger();
        living.getCapability(AbilityProvider.CAPABILITY).ifPresent(playerAbility -> atomic.set(playerAbility.getFallResistance()));
        int reduce = atomic.get();
        if (reduce < 0) {
            return 0.0f;
        }
        return Math.max(amount - (float)reduce, 0.0f);
    }

    public static boolean isInvul(LivingEntity living, DamageSource damageSource) {
        if (!damageSource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        AtomicBoolean atomic = new AtomicBoolean();
        living.getCapability(AbilityProvider.CAPABILITY).ifPresent(playerAbility -> atomic.set(playerAbility.getFallResistance() < 0));
        return atomic.get();
    }
}

