/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.item.curio.expert;

import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.phys.AABB;
import org.confluence.mod.effect.ModEffects;
import org.confluence.mod.item.curio.BaseCurioItem;
import org.confluence.mod.item.curio.CurioItems;
import org.confluence.mod.misc.ModRarity;
import org.confluence.mod.util.CuriosUtils;

public class BrainOfConfusion
extends BaseCurioItem
implements ModRarity.Expert {
    public BrainOfConfusion() {
        super(ModRarity.EXPERT);
    }

    public static float apply(LivingEntity living, RandomSource randomSource, float amount) {
        if (CuriosUtils.noSameCurio(living, (BaseCurioItem)((Object)CurioItems.BRAIN_OF_CONFUSION.get()))) {
            return amount;
        }
        if (randomSource.m_188501_() < 0.6f + amount * 0.02f) {
            float rangeMin = amount <= 120.0f ? amount * 0.5f + 200.0f : (amount <= 266.6f ? amount * 0.375f + 275.0f : (amount <= 440.0f ? amount * 0.1875f + 487.5f : amount * 0.046875f + 796.875f));
            float rangeMax = amount <= 20.0f ? amount * 2.0f + 300.0f : (amount <= 46.6f ? amount * 1.5f + 350.0f : (amount <= 100.0f ? amount * 0.75f + 525.0f : amount * 0.1875f + 806.25f));
            float range = rangeMin == rangeMax ? rangeMin : Mth.m_216267_((RandomSource)randomSource, (float)Math.min(rangeMin, rangeMax), (float)Math.max(rangeMin, rangeMax)) / 24.0f;
            int min = (int)(90.0f + amount / 3.0f);
            int max = (int)(300.0f + amount / 2.0f);
            int duration = min == max ? min : randomSource.m_216339_(Math.min(min, max), Math.max(min, max));
            living.m_9236_().m_6249_((Entity)living, new AABB(living.m_20097_()).m_82400_((double)range), entity -> entity instanceof Enemy).forEach(enemy -> {
                if (enemy instanceof LivingEntity) {
                    LivingEntity living1 = (LivingEntity)enemy;
                    living1.m_7292_(new MobEffectInstance((MobEffect)ModEffects.CONFUSED.get(), duration));
                }
            });
        }
        if (randomSource.m_188501_() < 0.1667f && !living.m_21023_((MobEffect)ModEffects.CEREBRAL_MINDTRICK.get())) {
            living.m_7292_(new MobEffectInstance((MobEffect)ModEffects.CEREBRAL_MINDTRICK.get(), 80));
            return 0.0f;
        }
        return amount;
    }

    @Override
    public Component[] getInformation() {
        return new Component[]{Component.m_237115_((String)"item.confluence.brain_of_confusion.info")};
    }
}

