/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.item.curio.combat;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import org.confluence.mod.item.curio.BaseCurioItem;
import org.confluence.mod.item.curio.CurioItems;
import org.confluence.mod.misc.ModConfigs;
import org.confluence.mod.util.CuriosUtils;
import top.theillusivec4.curios.api.SlotContext;

public class PanicNecklace
extends BaseCurioItem {
    public static final UUID SPEED_UUID = UUID.fromString("E939EBB6-41D9-4B5D-9778-A019B820D7A8");
    private static ImmutableMultimap<Attribute, AttributeModifier> SPEED;

    public PanicNecklace() {
    }

    public PanicNecklace(Rarity rarity) {
        super(rarity);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Level level = slotContext.entity().m_9236_();
        if (level.f_46443_) {
            return;
        }
        CompoundTag nbt = stack.m_41784_();
        long lastHurt = nbt.m_128454_("lastHurt");
        if (lastHurt == 0L) {
            return;
        }
        if (level.m_46467_() - lastHurt > 100L) {
            nbt.m_128356_("lastHurt", 0L);
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        if (SPEED == null) {
            SPEED = ImmutableMultimap.of((Object)Attributes.f_22279_, (Object)new AttributeModifier(SPEED_UUID, "Panic Necklace", ((Double)ModConfigs.PANIC_NECKLACE_MOVEMENT.get()).doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        return stack.m_41784_().m_128454_("lastHurt") == 0L ? EMPTY_ATTRIBUTE : SPEED;
    }

    public static void apply(LivingEntity living) {
        CuriosUtils.findCurio(living, (BaseCurioItem)((Object)CurioItems.PANIC_NECKLACE.get())).ifPresent(itemStack -> itemStack.m_41784_().m_128356_("lastHurt", living.m_9236_().m_46467_()));
    }

    @Override
    public Component[] getInformation() {
        return new Component[]{Component.m_237115_((String)"item.confluence.panic_necklace.info")};
    }
}

