/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.handler;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.confluence.mod.client.KeyBindings;
import org.confluence.mod.item.curio.informational.HalfHourWatch;
import org.confluence.mod.item.curio.informational.HourWatch;
import org.confluence.mod.item.curio.informational.ICompass;
import org.confluence.mod.item.curio.informational.IDepthMeter;
import org.confluence.mod.item.curio.informational.IFishermansPocketGuide;
import org.confluence.mod.item.curio.informational.ILifeFormAnalyzer;
import org.confluence.mod.item.curio.informational.IMetalDetector;
import org.confluence.mod.item.curio.informational.IRadar;
import org.confluence.mod.item.curio.informational.ISextant;
import org.confluence.mod.item.curio.informational.IStopwatch;
import org.confluence.mod.item.curio.informational.ITallyCounter;
import org.confluence.mod.item.curio.informational.IWeatherRadio;
import org.confluence.mod.item.curio.informational.MinuteWatch;
import org.confluence.mod.network.s2c.AttackDamagePacketS2C;
import org.confluence.mod.network.s2c.EntityKilledPacketS2C;
import org.confluence.mod.network.s2c.InfoCurioCheckPacketS2C;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public final class InformationHandler {
    private static final ArrayList<Component> information = new ArrayList();
    private static final byte[] infoData = new byte[12];
    private static final Int2ObjectOpenHashMap<byte[]> REMOTE_DATA = new Int2ObjectOpenHashMap();
    @Nullable
    private static Function<Long, Component> timeInfo = null;
    private static Component weatherRadioInfo = Component.m_237115_((String)"info.confluence.weather_radio.clear");
    private static boolean detectorPressed = false;
    private static Component metalDetectorInfo = Component.m_237115_((String)"info.confluence.metal_detector.none");
    private static Component lifeFormAnalyzerInfo = Component.m_237115_((String)"info.confluence.life_form_analyzer.none");
    private static Component radarInfo = Component.m_237110_((String)"info.confluence.radar", (Object[])new Object[]{0});
    private static Component tallyCounterInfo = Component.m_237115_((String)"info.confluence.tally_counter.unknown");
    private static long lastAttackTime = 0L;
    private static float cachedDamage = 0.0f;
    private static Component dpsMeterInfo = Component.m_237110_((String)"info.confluence.dps_meter", (Object[])new Object[]{Float.valueOf(0.0f)});

    public static void handle(LocalPlayer localPlayer) {
        information.clear();
        long gameTime = localPlayer.m_9236_().m_46467_();
        byte b = infoData[0];
        if (b != 0 && timeInfo != null) {
            information.add(timeInfo.apply(localPlayer.m_9236_().m_8044_()));
        }
        if (infoData[1] != 0) {
            if (gameTime % 200L == 1L) {
                weatherRadioInfo = IWeatherRadio.getInfo((Player)localPlayer);
            }
            information.add(weatherRadioInfo);
        }
        if (infoData[2] != 0) {
            information.add(ISextant.getInfo((Player)localPlayer));
        }
        if (infoData[3] != 0) {
            information.add(IFishermansPocketGuide.getInfo((Player)localPlayer));
        }
        b = infoData[4];
        if (((KeyMapping)KeyBindings.METAL_DETECTOR.get()).m_90857_()) {
            if (!detectorPressed && b != 0) {
                detectorPressed = true;
                metalDetectorInfo = IMetalDetector.getInfo((Player)localPlayer);
            }
        } else {
            detectorPressed = false;
        }
        if (b != 0) {
            information.add(metalDetectorInfo);
        }
        if (infoData[5] != 0) {
            if (gameTime % 200L == 5L) {
                lifeFormAnalyzerInfo = ILifeFormAnalyzer.getInfo((Player)localPlayer);
            }
            information.add(lifeFormAnalyzerInfo);
        }
        if (infoData[6] != 0) {
            if (gameTime % 200L == 6L) {
                radarInfo = IRadar.getInfo((Player)localPlayer);
            }
            information.add(radarInfo);
        }
        if (infoData[7] != 0) {
            information.add(tallyCounterInfo);
        }
        if (infoData[8] != 0) {
            information.add(dpsMeterInfo);
        }
        if (infoData[9] != 0) {
            information.add(IStopwatch.getInfo((Player)localPlayer));
        }
        if (infoData[10] != 0) {
            information.add(ICompass.getInfo((Player)localPlayer));
        }
        if (infoData[11] != 0) {
            information.add(IDepthMeter.getInfo((Player)localPlayer));
        }
        if (gameTime % 200L == 0L) {
            for (int i = 0; i < infoData.length; ++i) {
                if (infoData[i] >= 0) continue;
                boolean match = false;
                for (Player player : localPlayer.m_9236_().m_6907_()) {
                    byte[] data;
                    if (player == localPlayer || player.m_20280_((Entity)localPlayer) > 1024.0 || (data = (byte[])REMOTE_DATA.get(player.m_19879_())) == null || data[i] <= -125) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                InformationHandler.infoData[i] = 0;
            }
        }
    }

    public static ArrayList<Component> getInformation() {
        return information;
    }

    public static void handlePacket(InfoCurioCheckPacketS2C packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            byte[] enabled = packet.enabled();
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null && packet.playerId() != player.m_19879_()) {
                REMOTE_DATA.put(packet.playerId(), (Object)packet.enabled());
            }
            byte b = enabled[0];
            byte c = infoData[0];
            if (b >= 0 && c >= 0 || b != -125 && c <= 0) {
                InformationHandler.infoData[0] = b;
            }
            timeInfo = switch (infoData[0]) {
                case -126, 1 -> HourWatch::wrapTime;
                case -127, 2 -> HalfHourWatch::wrapTime;
                case -128, 3 -> MinuteWatch::wrapTime;
                default -> null;
            };
            InformationHandler.setInfoData(enabled, (byte)1);
            InformationHandler.setInfoData(enabled, (byte)2);
            InformationHandler.setInfoData(enabled, (byte)3);
            InformationHandler.setInfoData(enabled, (byte)4);
            InformationHandler.setInfoData(enabled, (byte)5);
            InformationHandler.setInfoData(enabled, (byte)6);
            InformationHandler.setInfoData(enabled, (byte)7);
            InformationHandler.setInfoData(enabled, (byte)8);
            InformationHandler.setInfoData(enabled, (byte)9);
            InformationHandler.setInfoData(enabled, (byte)10);
            InformationHandler.setInfoData(enabled, (byte)11);
        });
        context.setPacketHandled(true);
    }

    private static void setInfoData(byte[] enabled, byte index) {
        byte b = enabled[index];
        byte c = infoData[index];
        if (b >= 0 && c >= 0 || b != -128 && c <= 0) {
            InformationHandler.infoData[index] = b;
        }
    }

    public static void handleEntityKilled(EntityKilledPacketS2C packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(packet.type());
            if (entityType != null) {
                tallyCounterInfo = ITallyCounter.getInfo(packet.amount() + 1, entityType.m_20676_());
            }
        });
        context.setPacketHandled(true);
    }

    public static void handleAttackDamage(AttackDamagePacketS2C packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return;
            }
            long gameTime = level.m_46467_();
            long delta = gameTime - lastAttackTime;
            if (delta == gameTime) {
                delta = 20L;
            }
            if (delta > 100L) {
                cachedDamage = 0.0f;
                delta = 20L;
            }
            lastAttackTime = gameTime;
            dpsMeterInfo = Component.m_237110_((String)"info.confluence.dps_meter", (Object[])new Object[]{"%.2f".formatted(Float.valueOf((cachedDamage += packet.amount()) / (float)delta))});
        });
        context.setPacketHandled(true);
    }
}

