/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.handler;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import org.confluence.mod.client.handler.StepStoolHandler;
import org.confluence.mod.mixin.client.LocalPlayerAccessor;
import org.confluence.mod.network.NetworkHandler;
import org.confluence.mod.network.c2s.GravitationPacketC2S;
import org.confluence.mod.network.s2c.BroadcastGravitationRotPacketS2C;
import org.confluence.mod.network.s2c.GravityGlobePacketS2C;
import org.confluence.mod.util.IEntity;

@OnlyIn(value=Dist.CLIENT)
public final class GravitationHandler {
    private static boolean keyDown = false;
    private static boolean shouldRot = false;
    private static boolean hasGlobe = false;

    public static void handle(LocalPlayer localPlayer, boolean jumping) {
        if (StepStoolHandler.onStool() || localPlayer.m_150110_().f_35935_) {
            return;
        }
        if (jumping) {
            if (!keyDown) {
                shouldRot = !shouldRot;
                localPlayer.m_183634_();
                NetworkHandler.CHANNEL.sendToServer((Object)new GravitationPacketC2S(shouldRot));
            }
            keyDown = true;
        } else {
            keyDown = false;
        }
    }

    public static void expire() {
        if (shouldRot) {
            shouldRot = false;
            NetworkHandler.CHANNEL.sendToServer((Object)new GravitationPacketC2S(false));
        }
    }

    public static boolean isShouldRot() {
        return shouldRot;
    }

    public static void tick(LocalPlayer localPlayer) {
        if (localPlayer == null) {
            shouldRot = false;
            hasGlobe = false;
        } else if (localPlayer.m_20186_() > (double)localPlayer.m_9236_().m_151558_()) {
            GravitationHandler.expire();
        }
    }

    public static void unCrouching(Player localPlayer) {
        if (shouldRot && localPlayer.m_20096_() && localPlayer.m_6047_() && !localPlayer.m_6144_()) {
            localPlayer.m_6478_(MoverType.SELF, new Vec3(0.0, -0.3000001, 0.0));
            localPlayer.m_20124_(Pose.STANDING);
            ((LocalPlayerAccessor)localPlayer).setCrouching(false);
        }
    }

    public static void handleGlobe(GravityGlobePacketS2C packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            hasGlobe = packet.has();
        });
        context.setPacketHandled(true);
    }

    public static boolean isHasGlobe() {
        return hasGlobe;
    }

    public static void handleRemoteRot(BroadcastGravitationRotPacketS2C packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
            if (localPlayer == null) {
                return;
            }
            Entity entity = localPlayer.m_9236_().m_6815_(packet.entityId());
            if (entity != null) {
                ((IEntity)entity).c$setShouldRot(packet.enabled());
            }
        });
        context.setPacketHandled(true);
    }
}

