/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.effects;

import com.telepathicgrunt.the_bumblezone.blocks.HoneycombBrood;
import com.telepathicgrunt.the_bumblezone.configs.BzBeeAggressionConfigs;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.entities.BeeAggression;
import com.telepathicgrunt.the_bumblezone.events.entity.EntityDeathEvent;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzPOI;
import com.telepathicgrunt.the_bumblezone.platform.EffectExtension;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class WrathOfTheHiveEffect
extends MobEffect
implements EffectExtension {
    public static final int NEARBY_WRATH_EFFECT_RADIUS = 8;
    private static final TargetingConditions SEE_THROUGH_WALLS = TargetingConditions.m_148352_().m_148355_().m_26893_();
    private static final TargetingConditions LINE_OF_SIGHT = TargetingConditions.m_148352_();
    public static boolean ACTIVE_WRATH = false;

    public WrathOfTheHiveEffect(MobEffectCategory type, int potionColor) {
        super(type, potionColor);
    }

    public boolean m_8093_() {
        return true;
    }

    public boolean m_6584_(int duration, int amplifier) {
        return duration >= 1;
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        Mob mob;
        Level world = entity.m_9236_();
        if (entity instanceof Mob && (mob = (Mob)entity).m_21525_()) {
            return;
        }
        if (entity.m_21224_()) {
            WrathOfTheHiveEffect.calmTheBees(world, entity);
            return;
        }
        if (entity instanceof Player && world.m_46791_() == Difficulty.PEACEFUL) {
            entity.m_21195_((MobEffect)this);
            return;
        }
        if ((entity.m_9236_().m_46467_() + entity.m_20148_().getLeastSignificantBits()) % 20L != 0L) {
            return;
        }
        if (amplifier >= 2) {
            ServerLevel serverLevel;
            WrathOfTheHiveEffect.unBEElievablyHighAggression(world, entity);
            if (world instanceof ServerLevel && (float)GeneralUtils.getNearbyActiveEntitiesInDimension(serverLevel = (ServerLevel)world, entity.m_20183_()) < (float)BzGeneralConfigs.broodBlocksBeeSpawnCapacity * 3.0f && entity.m_217043_().m_188501_() <= 0.09f) {
                BlockPos spawnBlockPos = GeneralUtils.getRandomBlockposWithinRange(entity, 30, 10);
                if (!world.m_8055_(spawnBlockPos).m_60795_()) {
                    return;
                }
                Bee bee = (Bee)EntityType.f_20550_.m_20615_(world);
                if (bee == null) {
                    return;
                }
                bee.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(spawnBlockPos), MobSpawnType.TRIGGERED, null, null);
                bee.m_19890_((double)spawnBlockPos.m_123341_() + 0.5, (double)spawnBlockPos.m_123342_() + 0.5, (double)spawnBlockPos.m_123343_() + 0.5, entity.m_217043_().m_188501_() * 360.0f, 0.0f);
                PlatformHooks.finalizeSpawn((Mob)bee, (ServerLevelAccessor)world, null, MobSpawnType.TRIGGERED, null);
                world.m_7967_((Entity)bee);
            }
        } else {
            WrathOfTheHiveEffect.mediumAggression(world, entity);
        }
        if (!world.m_5776_() && entity instanceof Player) {
            PoiManager poiManager = ((ServerLevel)world).m_8904_();
            List poiInRange = poiManager.m_27166_(pointOfInterestType -> pointOfInterestType.m_203334_() == BzPOI.BROOD_BLOCK_POI.get(), entity.m_20183_(), 8, PoiManager.Occupancy.ANY).collect(Collectors.toList());
            float chanceOfGrowth = 0.15f;
            if (poiInRange.size() != 0) {
                for (int index = poiInRange.size() - 1; index >= 0; --index) {
                    BlockState state;
                    if (!(entity.m_217043_().m_188501_() < chanceOfGrowth)) continue;
                    PoiRecord poi = (PoiRecord)poiInRange.remove(index);
                    int yDiff = Math.abs(entity.m_20183_().m_123342_() - poi.m_27257_().m_123342_());
                    if (yDiff > 8 || !((state = world.m_8055_(poi.m_27257_())).m_60734_() instanceof HoneycombBrood)) continue;
                    state.m_222963_((ServerLevel)world, poi.m_27257_(), entity.m_217043_());
                }
            }
        }
    }

    public static void mediumAggression(Level world, LivingEntity livingEntity) {
        WrathOfTheHiveEffect.setAggression(world, livingEntity, Bee.class, LINE_OF_SIGHT, Math.max(BzBeeAggressionConfigs.speedBoostLevel - 1, 1), Math.max((BzBeeAggressionConfigs.absorptionBoostLevel - 1) / 2, 1), Math.max((BzBeeAggressionConfigs.strengthBoostLevel - 1) / 3, 1));
    }

    public static void unBEElievablyHighAggression(Level world, LivingEntity livingEntity) {
        WrathOfTheHiveEffect.setAggression(world, livingEntity, Bee.class, SEE_THROUGH_WALLS, BzBeeAggressionConfigs.speedBoostLevel - 1, BzBeeAggressionConfigs.absorptionBoostLevel - 1, BzBeeAggressionConfigs.strengthBoostLevel - 1);
    }

    private static void setAggression(Level world, LivingEntity livingEntity, Class<? extends Mob> entityToFind, TargetingConditions sightMode, int speed, int absorption, int strength) {
        if (BeeAggression.isBeelikeEntity((Entity)livingEntity)) {
            return;
        }
        boolean isHiding = false;
        MobEffectInstance hiddenEffect = livingEntity.m_21124_(BzEffects.HIDDEN.get());
        if (hiddenEffect != null && hiddenEffect.m_19564_() >= 1) {
            isHiding = true;
        }
        sightMode.m_26883_((double)BzBeeAggressionConfigs.aggressionTriggerRadius);
        List beeList = world.m_45971_(entityToFind, sightMode, livingEntity, livingEntity.m_20191_().m_82400_((double)BzBeeAggressionConfigs.aggressionTriggerRadius));
        for (Mob bee : beeList) {
            MobEffectInstance effect;
            if (bee.m_21525_()) continue;
            if (isHiding) {
                bee.m_6710_(null);
                continue;
            }
            if (bee instanceof NeutralMob) {
                ((NeutralMob)bee).m_7870_(40);
                if (bee.m_5448_() == null || bee.m_5448_().m_21224_()) {
                    ((NeutralMob)bee).m_6925_(livingEntity.m_20148_());
                }
            }
            if (bee.m_5448_() == null || bee.m_5448_().m_21224_()) {
                bee.m_6710_(livingEntity);
            }
            if ((effect = livingEntity.m_21124_(BzEffects.WRATH_OF_THE_HIVE.get())) == null) continue;
            int leftoverDuration = effect.m_19557_();
            MobEffectInstance currentEffect = bee.m_21124_(MobEffects.f_19596_);
            if (currentEffect == null || currentEffect.m_19557_() < leftoverDuration) {
                bee.m_7292_(new MobEffectInstance(MobEffects.f_19596_, leftoverDuration, speed, false, false));
            }
            if ((currentEffect = bee.m_21124_(MobEffects.f_19617_)) == null || currentEffect.m_19557_() < leftoverDuration) {
                bee.m_7292_(new MobEffectInstance(MobEffects.f_19617_, leftoverDuration, absorption, false, false));
            }
            if ((currentEffect = bee.m_21124_(MobEffects.f_19600_)) != null && currentEffect.m_19557_() >= leftoverDuration) continue;
            bee.m_7292_(new MobEffectInstance(MobEffects.f_19600_, leftoverDuration, strength, false, true));
        }
    }

    public static void calmTheBees(Level world, LivingEntity livingEntity) {
        SEE_THROUGH_WALLS.m_26883_((double)BzBeeAggressionConfigs.aggressionTriggerRadius * 1.2);
        List beeList = world.m_45971_(Bee.class, SEE_THROUGH_WALLS, livingEntity, livingEntity.m_20191_().m_82400_((double)BzBeeAggressionConfigs.aggressionTriggerRadius * 1.2));
        for (Bee bee : beeList) {
            if (bee.m_21525_() || bee.m_5448_() != livingEntity) continue;
            bee.m_6710_(null);
            bee.m_21561_(false);
            bee.m_7870_(0);
            bee.m_21195_(MobEffects.f_19600_);
            bee.m_21195_(MobEffects.f_19596_);
            bee.m_21195_(MobEffects.f_19617_);
        }
    }

    public void m_6386_(LivingEntity entity, AttributeMap attributes, int amplifier) {
        Mob mob;
        if (entity instanceof Mob && (mob = (Mob)entity).m_21525_()) {
            super.m_6386_(entity, attributes, amplifier);
            return;
        }
        if (BeeAggression.doesBeesHateEntity((Entity)entity)) {
            entity.m_7292_(new MobEffectInstance(BzEffects.WRATH_OF_THE_HIVE.get(), BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts, 1, false, true));
        } else {
            super.m_6386_(entity, attributes, amplifier);
        }
    }

    public static void onLivingEntityDeath(EntityDeathEvent event) {
        LivingEntity livingEntity = event.entity();
        if (livingEntity != null) {
            WrathOfTheHiveEffect.calmTheBees(livingEntity.m_9236_(), livingEntity);
        }
    }

    @Override
    public List<ItemStack> bz$getCurativeItems() {
        return new ArrayList<ItemStack>();
    }
}

