/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.essence;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.telepathicgrunt.the_bumblezone.configs.BzClientConfigs;
import com.telepathicgrunt.the_bumblezone.items.essence.AbilityEssenceItem;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class EssenceOverlay {
    private static final ResourceLocation TEXTURE_OVERLAY_1 = new ResourceLocation("the_bumblezone", "textures/misc/active_essence_overlay.png");

    public static void essenceItemOverlay(Player player, GuiGraphics guiGraphics) {
        AbilityEssenceItem abilityEssenceItem;
        ItemStack offhandItem;
        block7: {
            block6: {
                if (BzClientConfigs.essenceItemHUDVisualEffectLayers == 0) {
                    return;
                }
                offhandItem = player.m_21206_();
                Item item = offhandItem.m_41720_();
                if (!(item instanceof AbilityEssenceItem)) break block6;
                abilityEssenceItem = (AbilityEssenceItem)item;
                if (!player.m_36335_().m_41519_((Item)abilityEssenceItem)) break block7;
            }
            return;
        }
        if (!AbilityEssenceItem.getIsActive(offhandItem)) {
            return;
        }
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        float red = (float)GeneralUtils.getRed(abilityEssenceItem.getColor()) / 256.0f;
        float green = (float)GeneralUtils.getGreen(abilityEssenceItem.getColor()) / 256.0f;
        float blue = (float)GeneralUtils.getBlue(abilityEssenceItem.getColor()) / 256.0f;
        int remainingUse = abilityEssenceItem.getAbilityUseRemaining(offhandItem);
        float percentageLeft = (float)remainingUse / (float)abilityEssenceItem.getMaxAbilityUseAmount();
        float opacity = 0.1f + percentageLeft * 0.2f;
        guiGraphics.m_280246_(red, green, blue, opacity);
        PoseStack poseStack = guiGraphics.m_280168_();
        float rotationX = (float)guiGraphics.m_280182_() / 2.0f;
        float rotationY = guiGraphics.m_280206_();
        for (int layer = 0; layer < BzClientConfigs.essenceItemHUDVisualEffectLayers; ++layer) {
            poseStack.m_85836_();
            int rotationDirection = layer % 2 == 1 ? -1 : 1;
            float squash = 0.12f - (float)layer * 0.04f;
            double spinSlowdown = 400 + layer * 150;
            double currentMillisecond = (double)System.currentTimeMillis() % (360.0 * spinSlowdown);
            double degrees = currentMillisecond / spinSlowdown * (double)BzClientConfigs.essenceItemHUDVisualEffectSpeed * (double)rotationDirection;
            float angle = (float)((degrees + 45.0) * 0.01745329238474369);
            Matrix4f rotationMatrix = new Matrix4f(Mth.m_14089_((float)angle), -Mth.m_14031_((float)angle), 0.0f, 0.0f, Mth.m_14031_((float)angle), Mth.m_14089_((float)angle), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
            Matrix4f scalingMatrix = new Matrix4f(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, squash, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
            Matrix4f translationMatrix = new Matrix4f(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, rotationX, rotationY, 0.0f, 1.0f);
            poseStack.m_252931_(translationMatrix.mul((Matrix4fc)scalingMatrix).mul((Matrix4fc)rotationMatrix));
            guiGraphics.m_280398_(TEXTURE_OVERLAY_1, (int)(-rotationX), (int)(-rotationX), -90, 0.0f, 0.0f, guiGraphics.m_280182_(), guiGraphics.m_280182_(), guiGraphics.m_280182_(), guiGraphics.m_280182_());
            poseStack.m_85849_();
        }
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

