/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.samsthenerd.inline.utils.SpriteUVRegion;
import com.samsthenerd.inline.utils.Spritelike;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class SpritelikeRenderers {
    private static final Map<Spritelike.SpritelikeType, SpritelikeRenderer> RENDERER_MAP = new HashMap<Spritelike.SpritelikeType, SpritelikeRenderer>();
    private static final SpritelikeRenderer DEFAULT_RENDERER = new SpritelikeRenderer();

    public static void registerRenderer(Spritelike.SpritelikeType type, SpritelikeRenderer renderer) {
        RENDERER_MAP.put(type, renderer);
    }

    public static SpritelikeRenderer getRenderer(Spritelike.SpritelikeType type) {
        if (RENDERER_MAP.containsKey(type)) {
            return RENDERER_MAP.get(type);
        }
        return DEFAULT_RENDERER;
    }

    public static SpritelikeRenderer getRenderer(Spritelike sprite) {
        return SpritelikeRenderers.getRenderer(sprite.getType());
    }

    public static class SpritelikeRenderer {
        public void drawSpriteWithLight(Spritelike sprite, GuiGraphics ctx, float x, float y, float z, float width, float height, int light, int argb) {
            ResourceLocation texture = sprite.getTextureId();
            if (texture == null) {
                return;
            }
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
            RenderSystem.setShader(GameRenderer::m_172679_);
            Matrix4f matrix4f = ctx.m_280168_().m_85850_().m_252922_();
            RenderType renderLayer = RenderType.m_110473_((ResourceLocation)texture);
            VertexConsumer vc = ctx.m_280091_().m_6299_(renderLayer);
            SpriteUVRegion uvs = sprite.getUVs();
            vc.m_252986_(matrix4f, x, y, z).m_193479_(argb).m_7421_((float)uvs.minU(), (float)uvs.minV()).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(ctx.m_280168_().m_85850_().m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
            vc.m_252986_(matrix4f, x, y + height, z).m_193479_(argb).m_7421_((float)uvs.minU(), (float)uvs.maxV()).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(ctx.m_280168_().m_85850_().m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
            vc.m_252986_(matrix4f, x + width, y + height, z).m_193479_(argb).m_7421_((float)uvs.maxU(), (float)uvs.maxV()).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(ctx.m_280168_().m_85850_().m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
            vc.m_252986_(matrix4f, x + width, y, z).m_193479_(argb).m_7421_((float)uvs.maxU(), (float)uvs.minV()).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(ctx.m_280168_().m_85850_().m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
            ctx.m_280091_().m_109912_(renderLayer);
        }

        public void drawSprite(Spritelike sprite, GuiGraphics ctx, float x, float y, float z, float width, float height) {
            ResourceLocation texture = sprite.getTextureId();
            if (texture == null) {
                return;
            }
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
            RenderSystem.setShader(GameRenderer::m_172817_);
            Matrix4f matrix4f = ctx.m_280168_().m_85850_().m_252922_();
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            SpriteUVRegion uvs = sprite.getUVs();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferBuilder.m_252986_(matrix4f, x, y, z).m_7421_((float)uvs.minU(), (float)uvs.minV()).m_5752_();
            bufferBuilder.m_252986_(matrix4f, x, y + height, z).m_7421_((float)uvs.minU(), (float)uvs.maxV()).m_5752_();
            bufferBuilder.m_252986_(matrix4f, x + width, y + height, z).m_7421_((float)uvs.maxU(), (float)uvs.maxV()).m_5752_();
            bufferBuilder.m_252986_(matrix4f, x + width, y, z).m_7421_((float)uvs.maxU(), (float)uvs.minV()).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        }
    }
}

