/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.api.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Codec;
import com.samsthenerd.inline.api.InlineData;
import com.samsthenerd.inline.tooltips.CustomTooltipManager;
import com.samsthenerd.inline.tooltips.providers.EntityTTProvider;
import com.samsthenerd.inline.utils.cradles.PlayerCradle;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class PlayerHeadData
implements InlineData<PlayerHeadData> {
    public final GameProfile profile;

    public PlayerHeadDataType getType() {
        return PlayerHeadDataType.INSTANCE;
    }

    @Override
    public ResourceLocation getRendererId() {
        return new ResourceLocation("inline", "playerhead");
    }

    public PlayerHeadData(GameProfile profile) {
        this.profile = profile;
    }

    public HoverEvent getEntityDisplayHoverEvent() {
        return new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(CustomTooltipManager.getForTooltip(EntityTTProvider.INSTANCE, new PlayerCradle(this.profile))));
    }

    public Style getDataStyle(boolean withAdditional) {
        Style superStyle = InlineData.super.asStyle(withAdditional);
        if (!withAdditional) {
            return superStyle;
        }
        return superStyle.m_131146_(Style.f_131099_.m_131144_(this.getEntityDisplayHoverEvent()));
    }

    public static class PlayerHeadDataType
    implements InlineData.InlineDataType<PlayerHeadData> {
        public static PlayerHeadDataType INSTANCE = new PlayerHeadDataType();
        private static Gson GSON = new GsonBuilder().create();

        @Override
        public ResourceLocation getId() {
            return new ResourceLocation("inline", "playerhead");
        }

        @Override
        public Codec<PlayerHeadData> getCodec() {
            return PlayerCradle.GAME_PROFILE_CODEC.xmap(PlayerHeadData::new, data -> data.profile);
        }

        public PlayerHeadData deserialize(JsonElement json) {
            return new PlayerHeadData((GameProfile)GSON.fromJson(json, GameProfile.class));
        }

        public JsonElement serializeData(PlayerHeadData data) {
            GameProfile profile = data.profile;
            return GSON.toJsonTree((Object)profile);
        }
    }
}

