/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmorestages.common.utils;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import net.sixik.sdmorestages.OreStageContainer;
import net.sixik.sdmorestages.common.BlockStageInfo;

public class OreBlockHelper {
    private static Player currentPlayer;
    private static final List<ItemStack> EMPTY_DROPS;

    public static void setPlayer(@Nullable Player player) {
        currentPlayer = player;
    }

    @Nullable
    public static Player getCurrentPlayer() {
        return currentPlayer;
    }

    public static BlockState getBlockState(BlockPos blockPos, Level level) {
        return level.m_8055_(blockPos);
    }

    public static Block getBlock(BlockState blockState) {
        return blockState.m_60734_();
    }

    public static boolean isBlock(Block block) {
        return block != null;
    }

    public static boolean isBlock(BlockState blockState) {
        return blockState != null;
    }

    public static boolean isReplacedBlock(BlockState a, Block b) {
        return OreBlockHelper.isBlock(a) && OreBlockHelper.isBlock(b) && !a.m_60713_(b);
    }

    public static boolean isReplacedBlock(BlockState a, BlockState b) {
        return OreBlockHelper.isBlock(a) && OreBlockHelper.isBlock(b) && !b.m_60713_(a.m_60734_());
    }

    public static ResourceLocation getBlockName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    public static ResourceLocation getBlockName(BlockState blockState) {
        return OreBlockHelper.getBlockName(OreBlockHelper.getBlock(blockState));
    }

    public static BlockState getReplacement(Player player, BlockState original, BlockPos pos) {
        BlockState replace = null;
        for (BlockStageInfo info : OreStageContainer.GLOBAL_BLOCK_INFO) {
            if (info.getBlock() != null) {
                if (!info.getBlock().equals(original) && !original.m_60734_().m_49966_().equals(info.getBlock()) || GameStageHelper.hasStage((Player)player, (String)info.getStage())) continue;
                replace = info.getBlockReplace();
                return replace;
            }
            if (!info.getTag().elements().contains(original.m_60734_()) || GameStageHelper.hasStage((Player)player, (String)info.getStage())) continue;
            replace = info.getBlockReplace();
            return replace;
        }
        return original;
    }

    public static int getReplacementId(BlockState original, @Nullable BlockPos pos) {
        BlockPos actualPos;
        BlockState maybeReplacement;
        BlockState replacement = original;
        if (currentPlayer != null && OreBlockHelper.isReplacedBlock(original, maybeReplacement = OreBlockHelper.getReplacement(currentPlayer, original, actualPos = pos == null ? currentPlayer.m_20183_() : pos))) {
            replacement = maybeReplacement;
        }
        return Block.f_49791_.m_7447_((Object)replacement);
    }

    public static List<ItemStack> getDrops(Player player, BlockState original, ServerLevel serverLevel, BlockPos blockPos, @Nullable BlockEntity blockEntity, ItemStack tool) {
        BlockState replacement = OreBlockHelper.getReplacement(player, original, blockPos);
        if (OreBlockHelper.isReplacedBlock(original, replacement)) {
            List drops = Block.m_49874_((BlockState)replacement, (ServerLevel)serverLevel, (BlockPos)blockPos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)tool);
            return drops;
        }
        return EMPTY_DROPS;
    }

    static {
        EMPTY_DROPS = new ArrayList<ItemStack>();
    }
}

