/*
 * Decompiled with CFR 0.152.
 */
package me.Thelnfamous1.mobplayeranimator.compat;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.Thelnfamous1.mobplayeranimator.Constants;
import me.Thelnfamous1.mobplayeranimator.MobPlayerAnimatorClient;
import me.Thelnfamous1.mobplayeranimator.api.IllagerModelAccess;
import me.Thelnfamous1.mobplayeranimator.api.PlayerAnimatorHelper;
import me.Thelnfamous1.mobplayeranimator.api.part.MPABodyPart;
import me.Thelnfamous1.mobplayeranimator.api.part.MPAModelModifier;
import me.Thelnfamous1.mobplayeranimator.api.part.MPAModelPose;
import me.Thelnfamous1.mobplayeranimator.mixin.client.ModelPartAccessor;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import traben.entity_model_features.EMFAnimationApi;
import traben.entity_model_features.models.IEMFModel;
import traben.entity_model_features.models.animation.EMFAnimationEntityContext;
import traben.entity_model_features.models.parts.EMFModelPartRoot;
import traben.entity_model_features.utils.EMFEntity;

public class EMFCompat {
    private static final Set<UUID> EMF_ANIMATIONS_HALTED = new HashSet<UUID>();
    private static final Set<UUID> EMF_VANILLA_MODELS_FORCED = new HashSet<UUID>();
    private static final Map<UUID, MPAModelPose> EMF_MODEL_POSES = new HashMap<UUID, MPAModelPose>();

    public static void registerVariables() {
        EMFAnimationApi.registerSingletonAnimationVariable((String)"mobplayeranimator", (String)"is_playeranimator_animation_active", (String)EMFCompat.emfTranslationKey("is_playeranimator_animation_active"), EMFCompat::isPlayerAnimatorAnimationActive);
    }

    public static boolean isPlayerAnimatorAnimationActive() {
        EMFEntity eMFEntity = EMFAnimationEntityContext.getEMFEntity();
        if (eMFEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)eMFEntity;
            return PlayerAnimatorHelper.isAnimating(livingEntity) && MobPlayerAnimatorClient.getClientConfigHelper().isAnimatingAnyNonBlacklistedAnimation(livingEntity);
        }
        return false;
    }

    private static String emfTranslationKey(String key) {
        return "entity_model_features.config.variable_explanation.mobplayeranimator." + key;
    }

    public static void lockToVanillaModelFor(LivingEntity mob, EntityModel<?> model) {
        if (EMFCompat.hasEMFAnimations(model) && EMFCompat.shouldHaltEMFAnimations(mob) && MobPlayerAnimatorClient.getClientConfigHelper().isVanillaModelForcedForEMF((Entity)mob)) {
            EMFAnimationApi.lockEntityToVanillaModel((EMFEntity)EMFAnimationApi.emfEntityOf((Entity)mob));
            EMF_VANILLA_MODELS_FORCED.add(mob.m_20148_());
        }
    }

    private static boolean shouldHaltEMFAnimations(LivingEntity mob) {
        return PlayerAnimatorHelper.isAnimating(mob) && MobPlayerAnimatorClient.getClientConfig().is_emf_animation_halt_enabled && MobPlayerAnimatorClient.getClientConfigHelper().isAnimationHaltedForEMF((Entity)mob) && MobPlayerAnimatorClient.getClientConfigHelper().isAnimatingAnyNonBlacklistedAnimation(mob);
    }

    public static void pauseEMFAnimationsFor(LivingEntity mob, EntityModel<?> model) {
        if (EMFCompat.hasEMFAnimations(model) && EMFCompat.shouldHaltEMFAnimations(mob) && !MobPlayerAnimatorClient.getClientConfigHelper().isVanillaModelForcedForEMF((Entity)mob)) {
            MPAModelModifier modelModifier;
            EMF_ANIMATIONS_HALTED.add(mob.m_20148_());
            HashSet<ModelPart> partsToPause = new HashSet<ModelPart>();
            Set<MPABodyPart> animatedParts = PlayerAnimatorHelper.getCurrentlyAnimatedParts(mob);
            boolean activeHead = animatedParts.contains((Object)MPABodyPart.HEAD);
            boolean activeTorso = animatedParts.contains((Object)MPABodyPart.TORSO);
            boolean activeLeftArm = animatedParts.contains((Object)MPABodyPart.LEFT_ARM);
            boolean activeRightArm = animatedParts.contains((Object)MPABodyPart.RIGHT_ARM);
            boolean activeLeftLeg = animatedParts.contains((Object)MPABodyPart.LEFT_LEG);
            boolean activeRightLeg = animatedParts.contains((Object)MPABodyPart.RIGHT_LEG);
            if (model instanceof PlayerModel) {
                PlayerModel playerModel = (PlayerModel)model;
                if (activeHead) {
                    partsToPause.add(playerModel.f_102808_);
                    partsToPause.add(playerModel.f_102809_);
                }
                if (activeTorso) {
                    partsToPause.add(playerModel.f_102810_);
                }
                if (activeLeftArm) {
                    partsToPause.add(playerModel.f_102812_);
                    partsToPause.add(playerModel.f_103374_);
                }
                if (activeRightArm) {
                    partsToPause.add(playerModel.f_102811_);
                    partsToPause.add(playerModel.f_103375_);
                }
                if (activeLeftLeg) {
                    partsToPause.add(playerModel.f_102814_);
                    partsToPause.add(playerModel.f_103376_);
                }
                if (activeRightLeg) {
                    partsToPause.add(playerModel.f_102813_);
                    partsToPause.add(playerModel.f_103377_);
                }
            } else if (model instanceof HumanoidModel) {
                HumanoidModel humanoidModel = (HumanoidModel)model;
                if (activeHead) {
                    partsToPause.add(humanoidModel.f_102808_);
                    partsToPause.add(humanoidModel.f_102809_);
                }
                if (activeTorso) {
                    partsToPause.add(humanoidModel.f_102810_);
                }
                if (activeLeftArm) {
                    partsToPause.add(humanoidModel.f_102812_);
                }
                if (activeRightArm) {
                    partsToPause.add(humanoidModel.f_102811_);
                }
                if (activeLeftLeg) {
                    partsToPause.add(humanoidModel.f_102814_);
                }
                if (activeRightLeg) {
                    partsToPause.add(humanoidModel.f_102813_);
                }
            } else if (model instanceof IllagerModel) {
                IllagerModel illagerModel = (IllagerModel)model;
                IllagerModelAccess modelAccess = (IllagerModelAccess)illagerModel;
                if (activeHead) {
                    partsToPause.add(modelAccess.mobplayeranimator$getHead());
                    partsToPause.add(modelAccess.mobplayeranimator$getHead());
                }
                if (activeTorso) {
                    partsToPause.add(modelAccess.mobplayeranimator$getBody());
                }
                if (activeLeftArm || activeRightArm) {
                    partsToPause.add(modelAccess.mobplayeranimator$getArms());
                    if (activeLeftArm) {
                        partsToPause.add(modelAccess.mobplayeranimator$getLeftArm());
                    }
                    if (activeRightArm) {
                        partsToPause.add(modelAccess.mobplayeranimator$getRightArm());
                    }
                }
                if (activeLeftLeg) {
                    partsToPause.add(modelAccess.mobplayeranimator$getLeftLeg());
                }
                if (activeRightLeg) {
                    partsToPause.add(modelAccess.mobplayeranimator$getRightLeg());
                }
            }
            if ((modelModifier = MobPlayerAnimatorClient.getClientConfigHelper().getModelModifier(mob.m_6095_())) != null) {
                EMFModelPartRoot root = ((IEMFModel)model).emf$getEMFRootModel();
                EMF_MODEL_POSES.put(mob.m_20148_(), new MPAModelPose((ModelPart)root, modelModifier, animatedParts));
                Collection<ModelPart> modifiedParts = modelModifier.modify((ModelPart)root, animatedParts).values();
                partsToPause.addAll(modifiedParts);
            }
            if (!partsToPause.isEmpty()) {
                EMFAnimationApi.pauseCustomAnimationsForThesePartsOfEntity((EMFEntity)EMFAnimationApi.emfEntityOf((Entity)mob), (ModelPart[])((ModelPart[])partsToPause.toArray(ModelPart[]::new)));
            }
        }
    }

    public static boolean hasEMFAnimations(EntityModel<?> model) {
        return EMFAnimationApi.isModelAnimatedByEMF(model);
    }

    private static void debugChildren(String name, ModelPart modelPart, LivingEntity mob) {
        Constants.LOG.info("Children for {} of {}: {}", new Object[]{name, mob, ((ModelPartAccessor)modelPart).mobplayeranimator$getChildren().keySet()});
    }

    public static void resumeEMFAnimationsFor(LivingEntity mob, EntityModel<?> model) {
        MPAModelPose modelPose;
        if (EMF_ANIMATIONS_HALTED.remove(mob.m_20148_())) {
            EMFAnimationApi.resumeAllCustomAnimationsForEntity((EMFEntity)EMFAnimationApi.emfEntityOf((Entity)mob));
        }
        if (EMF_VANILLA_MODELS_FORCED.remove(mob.m_20148_())) {
            EMFAnimationApi.unlockEntityToVanillaModel((EMFEntity)EMFAnimationApi.emfEntityOf((Entity)mob));
        }
        if ((modelPose = EMF_MODEL_POSES.remove(mob.m_20148_())) != null) {
            modelPose.pose((ModelPart)((IEMFModel)model).emf$getEMFRootModel());
        }
    }
}

