/*
 * Decompiled with CFR 0.152.
 */
package me.Thelnfamous1.mobplayeranimator.api;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.api.layered.AnimationContainer;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.core.impl.AnimationProcessor;
import dev.kosmx.playerAnim.core.util.Pair;
import dev.kosmx.playerAnim.core.util.SetableSupplier;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.Helper;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import dev.kosmx.playerAnim.impl.IMutableModel;
import dev.kosmx.playerAnim.impl.IUpperPartHelper;
import dev.kosmx.playerAnim.impl.animation.AnimationApplier;
import dev.kosmx.playerAnim.impl.animation.IBendHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import me.Thelnfamous1.mobplayeranimator.api.FirstPersonTracker;
import me.Thelnfamous1.mobplayeranimator.api.HumanoidModelAccess;
import me.Thelnfamous1.mobplayeranimator.api.part.MPABodyPart;
import me.Thelnfamous1.mobplayeranimator.mixin.AnimationStackAccessor;
import me.Thelnfamous1.mobplayeranimator.platform.Services;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Unique;

public class PlayerAnimatorHelper {
    @Nullable
    public static AnimationApplier getAnimation(LivingEntity entity) {
        if (entity instanceof IAnimatedPlayer) {
            IAnimatedPlayer animatedPlayer = (IAnimatedPlayer)entity;
            return animatedPlayer.playerAnimator_getAnimation();
        }
        return null;
    }

    public static boolean isAnimating(LivingEntity entity) {
        AnimationApplier animation = PlayerAnimatorHelper.getAnimation(entity);
        return animation != null && animation.isActive();
    }

    public static void applyBodyRotations(@Nullable AnimationApplier animation, PoseStack matrixStack, float tickDelta) {
        if (animation == null) {
            return;
        }
        animation.setTickDelta(tickDelta);
        if (animation.isActive()) {
            Vec3f position = animation.get3DTransform("body", TransformType.POSITION, Vec3f.ZERO);
            matrixStack.m_85837_((double)((Float)position.getX()).floatValue(), (double)((Float)position.getY()).floatValue() + 0.7, (double)((Float)position.getZ()).floatValue());
            Vec3f rotation = animation.get3DTransform("body", TransformType.ROTATION, Vec3f.ZERO);
            matrixStack.m_252781_(Axis.f_252403_.m_252961_(((Float)rotation.getZ()).floatValue()));
            matrixStack.m_252781_(Axis.f_252436_.m_252961_(((Float)rotation.getY()).floatValue()));
            matrixStack.m_252781_(Axis.f_252529_.m_252961_(((Float)rotation.getX()).floatValue()));
            matrixStack.m_85837_(0.0, -0.7, 0.0);
        }
    }

    public static void initBend(ModelPart root, HumanoidModelAccess model) {
        IBendHelper.INSTANCE.initBend(root.m_171324_("body"), Direction.DOWN);
        IBendHelper.INSTANCE.initBend(root.m_171324_("right_arm"), Direction.UP);
        IBendHelper.INSTANCE.initBend(root.m_171324_("left_arm"), Direction.UP);
        IBendHelper.INSTANCE.initBend(root.m_171324_("right_leg"), Direction.UP);
        IBendHelper.INSTANCE.initBend(root.m_171324_("left_leg"), Direction.UP);
        ((IUpperPartHelper)model.mobplayeranimator$getRightArm()).setUpperPart(true);
        ((IUpperPartHelper)model.mobplayeranimator$getLeftArm()).setUpperPart(true);
        ((IUpperPartHelper)model.mobplayeranimator$getHead()).setUpperPart(true);
        ((IUpperPartHelper)model.mobplayeranimator$getHat()).setUpperPart(true);
    }

    public static void setAnimation(IMutableModel model, SetableSupplier<AnimationProcessor> animation) {
        if (animation != null) {
            model.setEmoteSupplier(animation);
        }
    }

    public static boolean bendRenderToBuffer(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha, SetableSupplier<AnimationProcessor> animation, Iterable<ModelPart> headParts, Iterable<ModelPart> bodyParts) {
        if (Helper.isBendEnabled() && animation.get() != null && ((AnimationProcessor)animation.get()).isActive()) {
            headParts.forEach(part -> {
                if (!((IUpperPartHelper)part).isUpperPart()) {
                    part.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
                }
            });
            bodyParts.forEach(part -> {
                if (!((IUpperPartHelper)part).isUpperPart()) {
                    part.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
                }
            });
            SetableSupplier<AnimationProcessor> emoteSupplier = animation;
            matrices.m_85836_();
            IBendHelper.rotateMatrixStack((PoseStack)matrices, (Pair)((AnimationProcessor)emoteSupplier.get()).getBend("body"));
            headParts.forEach(part -> {
                if (((IUpperPartHelper)part).isUpperPart()) {
                    part.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
                }
            });
            bodyParts.forEach(part -> {
                if (((IUpperPartHelper)part).isUpperPart()) {
                    part.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
                }
            });
            matrices.m_85849_();
            return true;
        }
        return false;
    }

    public static void initEmoteSupplier(IMutableModel model, SetableSupplier<AnimationProcessor> emoteSupplier) {
        emoteSupplier.set(null);
        model.setEmoteSupplier(emoteSupplier);
    }

    public static void setDefaultPivot(HumanoidModelAccess model) {
        model.mobplayeranimator$getInitialBodyPose().pose(model);
    }

    public static <T extends HumanoidModelAccess & IMutableModel> void setEmote(T model, @Nullable AnimationApplier emote) {
        if (emote == null) {
            return;
        }
        if (!((FirstPersonTracker)model).mobplayeranimator$isFirstPersonNext() && emote.isActive()) {
            ((IMutableModel)model).getEmoteSupplier().set((Object)emote);
            emote.updatePart("head", model.mobplayeranimator$getHead());
            model.mobplayeranimator$getHat().m_104315_(model.mobplayeranimator$getHead());
            emote.updatePart("torso", model.mobplayeranimator$getBody());
            emote.updatePart("leftArm", model.mobplayeranimator$getLeftArm());
            emote.updatePart("rightArm", model.mobplayeranimator$getRightArm());
            emote.updatePart("leftLeg", model.mobplayeranimator$getLeftLeg());
            emote.updatePart("rightLeg", model.mobplayeranimator$getRightLeg());
        } else {
            ((FirstPersonTracker)model).mobplayeranimator$setFirstPersonNext(false);
            ((IMutableModel)model).getEmoteSupplier().set(null);
            PlayerAnimatorHelper.resetBend(model.mobplayeranimator$getBody());
            PlayerAnimatorHelper.resetBend(model.mobplayeranimator$getLeftArm());
            PlayerAnimatorHelper.resetBend(model.mobplayeranimator$getRightArm());
            PlayerAnimatorHelper.resetBend(model.mobplayeranimator$getLeftLeg());
            PlayerAnimatorHelper.resetBend(model.mobplayeranimator$getRightLeg());
        }
    }

    private static void resetBend(ModelPart part) {
        IBendHelper.INSTANCE.bend(part, null);
    }

    public static boolean recursiveAnimationTest(IAnimation animation, Predicate<KeyframeAnimationPlayer> animationTest) {
        if (animation instanceof KeyframeAnimationPlayer) {
            KeyframeAnimationPlayer keyframeAnimationPlayer = (KeyframeAnimationPlayer)animation;
            return animationTest.test(keyframeAnimationPlayer);
        }
        if (animation instanceof ModifierLayer) {
            ModifierLayer modifierLayer = (ModifierLayer)animation;
            IAnimation layerAnimation = modifierLayer.getAnimation();
            return layerAnimation != null && PlayerAnimatorHelper.recursiveAnimationTest(layerAnimation, animationTest);
        }
        if (animation instanceof AnimationContainer) {
            AnimationContainer animationContainer = (AnimationContainer)animation;
            IAnimation containerAnim = animationContainer.getAnim();
            return containerAnim != null && PlayerAnimatorHelper.recursiveAnimationTest(containerAnim, animationTest);
        }
        if (animation instanceof AnimationStack) {
            AnimationStack animationStack = (AnimationStack)animation;
            ArrayList<Pair<Integer, IAnimation>> prioritizedLayers = ((AnimationStackAccessor)animationStack).mobplayeranimator$getLayers();
            for (Pair<Integer, IAnimation> prioritizedLayer : prioritizedLayers) {
                IAnimation layer = (IAnimation)prioritizedLayer.getRight();
                if (!PlayerAnimatorHelper.recursiveAnimationTest(layer, animationTest)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static void recursiveAnimationConsume(IAnimation animation, Consumer<KeyframeAnimationPlayer> animationConsumer) {
        if (animation instanceof KeyframeAnimationPlayer) {
            KeyframeAnimationPlayer keyframeAnimationPlayer = (KeyframeAnimationPlayer)animation;
            animationConsumer.accept(keyframeAnimationPlayer);
        } else if (animation instanceof ModifierLayer) {
            ModifierLayer modifierLayer = (ModifierLayer)animation;
            IAnimation layerAnimation = modifierLayer.getAnimation();
            if (layerAnimation != null) {
                PlayerAnimatorHelper.recursiveAnimationConsume(layerAnimation, animationConsumer);
            }
        } else if (animation instanceof AnimationContainer) {
            AnimationContainer animationContainer = (AnimationContainer)animation;
            IAnimation containerAnim = animationContainer.getAnim();
            if (containerAnim != null) {
                PlayerAnimatorHelper.recursiveAnimationConsume(containerAnim, animationConsumer);
            }
        } else if (animation instanceof AnimationStack) {
            AnimationStack animationStack = (AnimationStack)animation;
            ArrayList<Pair<Integer, IAnimation>> prioritizedLayers = ((AnimationStackAccessor)animationStack).mobplayeranimator$getLayers();
            for (Pair<Integer, IAnimation> prioritizedLayer : prioritizedLayers) {
                IAnimation layer = (IAnimation)prioritizedLayer.getRight();
                PlayerAnimatorHelper.recursiveAnimationConsume(layer, animationConsumer);
            }
        }
    }

    public static Set<MPABodyPart> getCurrentlyAnimatedParts(LivingEntity entity) {
        if (entity instanceof IAnimatedPlayer) {
            IAnimatedPlayer animatedPlayer = (IAnimatedPlayer)entity;
            AnimationStack animationStack = animatedPlayer.getAnimationStack();
            return PlayerAnimatorHelper.getCurrentlyAnimatedParts((IAnimation)animationStack);
        }
        return Set.of();
    }

    public static Set<MPABodyPart> getCurrentlyAnimatedParts(IAnimation animation) {
        HashSet<MPABodyPart> activeParts = new HashSet<MPABodyPart>();
        PlayerAnimatorHelper.recursiveAnimationConsume(animation, keyframeAnimationPlayer -> PlayerAnimatorHelper.addCurrentlyTransformedParts(keyframeAnimationPlayer, activeParts));
        return activeParts;
    }

    private static void addCurrentlyTransformedParts(KeyframeAnimationPlayer keyframeAnimationPlayer, Set<MPABodyPart> activeParts) {
        if (!keyframeAnimationPlayer.isActive()) {
            return;
        }
        for (Map.Entry part : keyframeAnimationPlayer.bodyParts.entrySet()) {
            if (!PlayerAnimatorHelper.isActive((KeyframeAnimationPlayer.BodyPart)part.getValue())) continue;
            String partName = (String)part.getKey();
            MPABodyPart mpaBodyPart = MPABodyPart.byName(partName);
            if (mpaBodyPart != null) {
                activeParts.add(mpaBodyPart);
                continue;
            }
            if (!Services.PLATFORM.isDevelopmentEnvironment()) continue;
            throw new IllegalArgumentException("Invalid part name for MPABodyPart: " + partName);
        }
    }

    public static boolean isActive(KeyframeAnimationPlayer.BodyPart bodyPart) {
        return bodyPart.part != null && bodyPart.part.isEnabled();
    }

    @Unique
    public static <T extends HumanoidModelAccess & IMutableModel> T asMPAModel(HumanoidModelAccess model) {
        return (T)model;
    }
}

