/*
 * Decompiled with CFR 0.152.
 */
package me.Thelnfamous1.mobplayeranimator.api;

import dev.kosmx.playerAnim.api.IPlayer;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.core.impl.event.Event;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MobAnimationAccess {
    public static final Event<AnimationRegister> REGISTER_ANIMATION_EVENT = new Event(AnimationRegister.class, listeners -> (mob, animationStack) -> {
        for (AnimationRegister listener : listeners) {
            listener.registerAnimation(mob, animationStack);
        }
    });

    public static AnimationStack getMobAnimLayer(Mob mob) throws IllegalArgumentException {
        if (mob instanceof IPlayer) {
            return ((IPlayer)mob).getAnimationStack();
        }
        throw new IllegalArgumentException(mob + " is not a mob or library mixins failed");
    }

    public static MobAssociatedAnimationData getMobAssociatedData(@NotNull Mob mob) {
        if (mob instanceof IAnimatedPlayer) {
            IAnimatedPlayer animatedPlayer = (IAnimatedPlayer)mob;
            return new MobAssociatedAnimationData(animatedPlayer);
        }
        throw new IllegalArgumentException(mob + " is not a mob or library mixins failed");
    }

    public static class MobAssociatedAnimationData {
        @NotNull
        private final IAnimatedPlayer mob;

        public MobAssociatedAnimationData(@NotNull IAnimatedPlayer mob) {
            this.mob = mob;
        }

        @Nullable
        public IAnimation get(@NotNull ResourceLocation id) {
            return this.mob.playerAnimator_getAnimation(id);
        }

        @Nullable
        public IAnimation set(@NotNull ResourceLocation id, @Nullable IAnimation animation) {
            return this.mob.playerAnimator_setAnimation(id, animation);
        }
    }

    @FunctionalInterface
    public static interface AnimationRegister {
        public void registerAnimation(@NotNull Mob var1, @NotNull AnimationStack var2);
    }
}

