/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.nixieTube;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.simibubi.create.compat.Mods;
import com.simibubi.create.content.equipment.clipboard.ClipboardEntry;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.redstone.nixieTube.DoubleFaceAttachedBlock;
import com.simibubi.create.content.redstone.nixieTube.NixieTubeBlockEntity;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.block.IBE;
import java.util.List;
import java.util.function.BiConsumer;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NixieTubeBlock
extends DoubleFaceAttachedBlock
implements IBE<NixieTubeBlockEntity>,
IWrenchable,
SimpleWaterloggedBlock,
SpecialBlockItemRequirement {
    protected final DyeColor color;

    public NixieTubeBlock(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties);
        this.color = color;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACE, (Comparable)((Object)DoubleFaceAttachedBlock.DoubleAttachFace.FLOOR))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        List<ClipboardEntry> entries;
        int i;
        String tagElement;
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        NixieTubeBlockEntity nixie = (NixieTubeBlockEntity)this.getBlockEntity((BlockGetter)world, pos);
        if (nixie == null) {
            return InteractionResult.PASS;
        }
        if (NixieTubeBlock.isInComputerControlledRow((LevelAccessor)world, pos)) {
            return InteractionResult.PASS;
        }
        if (heldItem.m_41619_()) {
            if (nixie.reactsToRedstone()) {
                return InteractionResult.PASS;
            }
            nixie.clearCustomText();
            this.updateDisplayedRedstoneValue(state, world, pos);
            return InteractionResult.SUCCESS;
        }
        boolean display = heldItem.m_41720_() == Items.f_42656_ && heldItem.m_41788_() || AllBlocks.CLIPBOARD.isIn(heldItem);
        DyeColor dye = DyeColor.getColor((ItemStack)heldItem);
        if (!display && dye == null) {
            return InteractionResult.PASS;
        }
        CompoundTag tag = heldItem.m_41737_("display");
        String string = tagElement = tag != null && tag.m_128425_("Name", 8) ? tag.m_128461_("Name") : null;
        if (AllBlocks.CLIPBOARD.isIn(heldItem) && (i = 0) < (entries = ClipboardEntry.getLastViewedEntries(heldItem)).size()) {
            tagElement = Component.Serializer.m_130703_((Component)entries.get((int)i).text);
        }
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        String tagUsed = tagElement;
        NixieTubeBlock.walkNixies((LevelAccessor)world, pos, true, (currentPos, rowPosition) -> {
            if (display) {
                this.withBlockEntityDo((BlockGetter)world, (BlockPos)currentPos, be -> be.displayCustomText(tagUsed, (int)rowPosition));
            }
            if (dye != null) {
                world.m_46597_(currentPos, NixieTubeBlock.withColor(state, dye));
            }
        });
        return InteractionResult.SUCCESS;
    }

    public static Direction getLeftNixieDirection(@NotNull BlockState state) {
        Direction left = ((Direction)state.m_61143_((Property)f_54117_)).m_122424_();
        if (state.m_61143_((Property)FACE) == DoubleFaceAttachedBlock.DoubleAttachFace.WALL) {
            left = Direction.UP;
        }
        if (state.m_61143_((Property)FACE) == DoubleFaceAttachedBlock.DoubleAttachFace.WALL_REVERSED) {
            left = Direction.DOWN;
        }
        return left;
    }

    public static Direction getRightNixieDirection(@NotNull BlockState state) {
        return NixieTubeBlock.getLeftNixieDirection(state).m_122424_();
    }

    public static boolean isInComputerControlledRow(@NotNull LevelAccessor world, @NotNull BlockPos pos) {
        return Mods.COMPUTERCRAFT.isLoaded() && !NixieTubeBlock.walkNixies(world, pos, false, null);
    }

    public static boolean walkNixies(@NotNull LevelAccessor world, @NotNull BlockPos start, boolean allowComputerControlled, @Nullable BiConsumer<BlockPos, Integer> callback) {
        BlockEntity ntbe;
        BlockPos nextPos;
        BlockState state = world.m_8055_(start);
        if (!(state.m_60734_() instanceof NixieTubeBlock)) {
            return false;
        }
        if (!Mods.COMPUTERCRAFT.isLoaded()) {
            allowComputerControlled = true;
        }
        BlockPos currentPos = start;
        Direction left = NixieTubeBlock.getLeftNixieDirection(state);
        Direction right = left.m_122424_();
        while (NixieTubeBlock.areNixieBlocksEqual(world.m_8055_(nextPos = currentPos.m_121945_(left)), state)) {
            BlockEntity blockEntity;
            if (!allowComputerControlled && (blockEntity = world.m_7702_(nextPos)) instanceof NixieTubeBlockEntity) {
                ntbe = (NixieTubeBlockEntity)blockEntity;
                if (ntbe.computerBehaviour.hasAttachedComputer()) {
                    return false;
                }
            }
            currentPos = nextPos;
        }
        if (!allowComputerControlled) {
            BlockPos nextPos2;
            ntbe = world.m_7702_(start);
            if (ntbe instanceof NixieTubeBlockEntity) {
                NixieTubeBlockEntity ntbe2 = (NixieTubeBlockEntity)ntbe;
                if (ntbe2.computerBehaviour.hasAttachedComputer()) {
                    return false;
                }
            }
            BlockPos leftmostPos = currentPos;
            currentPos = start;
            while (NixieTubeBlock.areNixieBlocksEqual(world.m_8055_(nextPos2 = currentPos.m_121945_(right)), state)) {
                BlockEntity blockEntity = world.m_7702_(nextPos2);
                if (blockEntity instanceof NixieTubeBlockEntity) {
                    NixieTubeBlockEntity ntbe3 = (NixieTubeBlockEntity)blockEntity;
                    if (ntbe3.computerBehaviour.hasAttachedComputer()) {
                        return false;
                    }
                }
                currentPos = nextPos2;
            }
            currentPos = leftmostPos;
        }
        int index = 0;
        while (true) {
            BlockPos nextPos3;
            int rowPosition = ++index;
            if (callback != null) {
                callback.accept(currentPos, rowPosition);
            }
            if (!NixieTubeBlock.areNixieBlocksEqual(world.m_8055_(nextPos3 = currentPos.m_121945_(right)), state)) break;
            currentPos = nextPos3;
        }
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{FACE, f_54117_, BlockStateProperties.f_61362_}));
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.m_60734_() instanceof NixieTubeBlock) {
            return;
        }
        world.m_46747_(pos);
        if (Mods.COMPUTERCRAFT.isLoaded()) {
            Direction right;
            BlockPos rightPos;
            Direction left = NixieTubeBlock.getLeftNixieDirection(state);
            BlockPos leftPos = pos.m_121945_(left);
            if (NixieTubeBlock.areNixieBlocksEqual(world.m_8055_(leftPos), state)) {
                boolean leftRowComputerControlled = NixieTubeBlock.isInComputerControlledRow((LevelAccessor)world, leftPos);
                NixieTubeBlock.walkNixies((LevelAccessor)world, leftPos, true, leftRowComputerControlled ? (currentPos, rowPosition) -> {
                    BlockEntity patt8993$temp = world.m_7702_(currentPos);
                    if (patt8993$temp instanceof NixieTubeBlockEntity) {
                        NixieTubeBlockEntity ntbe = (NixieTubeBlockEntity)patt8993$temp;
                        ntbe.displayEmptyText((int)rowPosition);
                    }
                } : (currentPos, rowPosition) -> {
                    BlockEntity patt9166$temp = world.m_7702_(currentPos);
                    if (patt9166$temp instanceof NixieTubeBlockEntity) {
                        NixieTubeBlockEntity ntbe = (NixieTubeBlockEntity)patt9166$temp;
                        NixieTubeBlock.updateDisplayedRedstoneValue(ntbe, true);
                    }
                });
            }
            if (NixieTubeBlock.areNixieBlocksEqual(world.m_8055_(rightPos = pos.m_121945_(right = left.m_122424_())), state)) {
                boolean rightRowComputerControlled = NixieTubeBlock.isInComputerControlledRow((LevelAccessor)world, rightPos);
                NixieTubeBlock.walkNixies((LevelAccessor)world, rightPos, true, rightRowComputerControlled ? (currentPos, rowPosition) -> {
                    BlockEntity patt9670$temp = world.m_7702_(currentPos);
                    if (patt9670$temp instanceof NixieTubeBlockEntity) {
                        NixieTubeBlockEntity ntbe = (NixieTubeBlockEntity)patt9670$temp;
                        ntbe.displayEmptyText((int)rowPosition);
                    }
                } : (currentPos, rowPosition) -> {
                    BlockEntity patt9843$temp = world.m_7702_(currentPos);
                    if (patt9843$temp instanceof NixieTubeBlockEntity) {
                        NixieTubeBlockEntity ntbe = (NixieTubeBlockEntity)patt9843$temp;
                        NixieTubeBlock.updateDisplayedRedstoneValue(ntbe, true);
                    }
                });
            }
        }
    }

    public ItemStack m_7397_(BlockGetter p_185473_1_, BlockPos p_185473_2_, BlockState p_185473_3_) {
        return AllBlocks.ORANGE_NIXIE_TUBE.asStack();
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state, BlockEntity be) {
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, ((NixieTubeBlock)AllBlocks.ORANGE_NIXIE_TUBE.get()).m_5456_());
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)pState.m_61143_((Property)f_54117_);
        switch ((DoubleFaceAttachedBlock.DoubleAttachFace)((Object)pState.m_61143_((Property)FACE))) {
            case CEILING: {
                return AllShapes.NIXIE_TUBE_CEILING.get(facing.m_122427_().m_122434_());
            }
            case FLOOR: {
                return AllShapes.NIXIE_TUBE.get(facing.m_122427_().m_122434_());
            }
        }
        return AllShapes.NIXIE_TUBE_WALL.get(facing);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        if (this.color != DyeColor.ORANGE) {
            return ((NixieTubeBlock)AllBlocks.ORANGE_NIXIE_TUBE.get()).getCloneItemStack(state, target, world, pos, player);
        }
        return super.getCloneItemStack(state, target, world, pos, player);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighbourState, LevelAccessor world, BlockPos pos, BlockPos neighbourPos) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return state;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state == null) {
            return null;
        }
        if (state.m_61143_((Property)FACE) != DoubleFaceAttachedBlock.DoubleAttachFace.WALL && state.m_61143_((Property)FACE) != DoubleFaceAttachedBlock.DoubleAttachFace.WALL_REVERSED) {
            state = (BlockState)state.m_61124_((Property)f_54117_, (Comparable)((Direction)state.m_61143_((Property)f_54117_)).m_122427_());
        }
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (level.f_46443_) {
            return;
        }
        if (!level.m_183326_().m_183588_(pos, (Object)this)) {
            level.m_186460_(pos, (Block)this, 1);
        }
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource r) {
        this.updateDisplayedRedstoneValue(state, (Level)worldIn, pos);
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.m_60734_() == oldState.m_60734_() || isMoving || oldState.m_60734_() instanceof NixieTubeBlock) {
            return;
        }
        if (Mods.COMPUTERCRAFT.isLoaded() && NixieTubeBlock.isInComputerControlledRow((LevelAccessor)worldIn, pos)) {
            NixieTubeBlock.walkNixies((LevelAccessor)worldIn, pos, true, (currentPos, rowPosition) -> {
                BlockEntity patt13054$temp = worldIn.m_7702_(currentPos);
                if (patt13054$temp instanceof NixieTubeBlockEntity) {
                    NixieTubeBlockEntity ntbe = (NixieTubeBlockEntity)patt13054$temp;
                    ntbe.displayEmptyText((int)rowPosition);
                }
            });
            return;
        }
        this.updateDisplayedRedstoneValue(state, worldIn, pos);
    }

    public static void updateDisplayedRedstoneValue(NixieTubeBlockEntity be, boolean force) {
        if (be.m_58904_() == null || be.m_58904_().f_46443_) {
            return;
        }
        if (be.reactsToRedstone() || force) {
            be.updateRedstoneStrength(NixieTubeBlock.getPower(be.m_58904_(), be.m_58899_()));
        }
    }

    private void updateDisplayedRedstoneValue(BlockState state, Level worldIn, BlockPos pos) {
        if (worldIn.f_46443_) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> NixieTubeBlock.updateDisplayedRedstoneValue(be, false));
    }

    static boolean isValidBlock(BlockGetter world, BlockPos pos, boolean above) {
        BlockState state = world.m_8055_(pos.m_6630_(above ? 1 : -1));
        return !state.m_60808_(world, pos).m_83281_();
    }

    private static int getPower(Level worldIn, BlockPos pos) {
        int power = 0;
        for (Direction direction : Iterate.directions) {
            power = Math.max(worldIn.m_277185_(pos.m_121945_(direction), direction), power);
        }
        for (Direction direction : Iterate.directions) {
            power = Math.max(worldIn.m_277185_(pos.m_121945_(direction), Direction.UP), power);
        }
        return power;
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return side != null;
    }

    @Override
    public Class<NixieTubeBlockEntity> getBlockEntityClass() {
        return NixieTubeBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends NixieTubeBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.NIXIE_TUBE.get();
    }

    public DyeColor getColor() {
        return this.color;
    }

    public static boolean areNixieBlocksEqual(BlockState blockState, BlockState otherState) {
        if (!(blockState.m_60734_() instanceof NixieTubeBlock)) {
            return false;
        }
        if (!(otherState.m_60734_() instanceof NixieTubeBlock)) {
            return false;
        }
        return NixieTubeBlock.withColor(blockState, DyeColor.WHITE) == NixieTubeBlock.withColor(otherState, DyeColor.WHITE);
    }

    public static BlockState withColor(BlockState state, DyeColor color) {
        return (BlockState)((BlockState)((BlockState)(color == DyeColor.ORANGE ? AllBlocks.ORANGE_NIXIE_TUBE : AllBlocks.NIXIE_TUBES.get(color)).getDefaultState().m_61124_((Property)f_54117_, (Comparable)((Direction)state.m_61143_((Property)f_54117_)))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)))).m_61124_((Property)FACE, (Comparable)((Object)((DoubleFaceAttachedBlock.DoubleAttachFace)((Object)state.m_61143_((Property)FACE)))));
    }

    public static DyeColor colorOf(BlockState blockState) {
        return blockState.m_60734_() instanceof NixieTubeBlock ? ((NixieTubeBlock)blockState.m_60734_()).color : DyeColor.ORANGE;
    }

    public static Direction getFacing(BlockState sideState) {
        return NixieTubeBlock.getConnectedDirection(sideState);
    }
}

