/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.server;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.yanny.ali.api.IKeyTooltipNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.common.tooltip.BranchTooltipNode;
import com.yanny.ali.plugin.common.tooltip.ComponentTooltipNode;
import com.yanny.ali.plugin.common.tooltip.EmptyTooltipNode;
import com.yanny.ali.plugin.common.tooltip.ValueTooltipNode;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.FishingHookPredicate;
import net.minecraft.advancements.critereon.FluidPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LightPredicate;
import net.minecraft.advancements.critereon.LighthingBoltPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.advancements.critereon.SlimePredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.SetAttributesFunction;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValueTooltipUtils {
    @NotNull
    public static IKeyTooltipNode getFormulaTooltip(IServerUtils utils, ApplyBonusCount.Formula formula) {
        IKeyTooltipNode tooltip = utils.getValueTooltip(utils, formula.m_5713_());
        if (formula instanceof ApplyBonusCount.BinomialWithBonusCount) {
            ApplyBonusCount.BinomialWithBonusCount binomialWithBonusCount = (ApplyBonusCount.BinomialWithBonusCount)formula;
            tooltip.add(utils.getValueTooltip(utils, binomialWithBonusCount.f_79948_).build("ali.property.value.extra_rounds"));
            tooltip.add(utils.getValueTooltip(utils, Float.valueOf(binomialWithBonusCount.f_79949_)).build("ali.property.value.probability"));
        } else if (formula instanceof ApplyBonusCount.UniformBonusCount) {
            ApplyBonusCount.UniformBonusCount uniformBonusCount = (ApplyBonusCount.UniformBonusCount)formula;
            tooltip.add(utils.getValueTooltip(utils, uniformBonusCount.f_80013_).build("ali.property.value.bonus_multiplier"));
        }
        return tooltip;
    }

    @NotNull
    public static IKeyTooltipNode getPropertyTooltip(IServerUtils utils, Property<?> property) {
        return utils.getValueTooltip(utils, property.m_61708_());
    }

    @NotNull
    public static IKeyTooltipNode getModifierTooltip(IServerUtils utils, SetAttributesFunction.Modifier modifier) {
        return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, modifier.f_80847_).build("ali.property.value.name")).add(utils.getValueTooltip(utils, modifier.f_80848_).build("ali.property.value.attribute")).add(utils.getValueTooltip(utils, modifier.f_80849_).build("ali.property.value.operation")).add(utils.getValueTooltip(utils, modifier.f_80850_).build("ali.property.value.amount")).add(utils.getValueTooltip(utils, modifier.f_80851_).build("ali.property.value.uuid")).add(utils.getValueTooltip(utils, Arrays.asList(modifier.f_80852_)).build("ali.property.branch.equipment_slots"));
    }

    @NotNull
    public static IKeyTooltipNode getUUIDTooltip(IServerUtils ignoredUtils, UUID uuid) {
        return ValueTooltipNode.value(uuid);
    }

    @NotNull
    public static IKeyTooltipNode getPairTooltip(IServerUtils utils, Pair<?, ?> pair) {
        IKeyTooltipNode tooltip = utils.getValueTooltip(utils, pair.getFirst());
        tooltip.add(utils.getValueTooltip(utils, pair.getSecond()).build("ali.property.value.color"));
        return tooltip;
    }

    @NotNull
    public static IKeyTooltipNode getStatePropertiesPredicateTooltip(IServerUtils utils, StatePropertiesPredicate propertiesPredicate) {
        return GenericTooltipUtils.getCollectionTooltip(utils, propertiesPredicate.f_67659_, GenericTooltipUtils::getPropertyMatcherTooltip);
    }

    @NotNull
    public static IKeyTooltipNode getDamageSourcePredicateTooltip(IServerUtils utils, DamageSourcePredicate damagePredicate) {
        if (damagePredicate != DamageSourcePredicate.f_25420_) {
            return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, damagePredicate.f_268608_).build("ali.property.branch.tags")).add(utils.getValueTooltip(utils, damagePredicate.f_25429_).build("ali.property.branch.direct_entity")).add(utils.getValueTooltip(utils, damagePredicate.f_25430_).build("ali.property.branch.source_entity"));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static <T> IKeyTooltipNode getTagPredicateTooltip(IServerUtils ignoredUtils, TagPredicate<T> tagPredicate) {
        return ValueTooltipNode.keyValue(tagPredicate.f_268479_.f_203868_().toString(), Boolean.toString(tagPredicate.f_268414_));
    }

    @NotNull
    public static IKeyTooltipNode getEntityPredicateTooltip(IServerUtils utils, EntityPredicate entityPredicate) {
        if (entityPredicate != EntityPredicate.f_36550_) {
            return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, entityPredicate.f_36551_).build("ali.property.value.entity_type")).add(utils.getValueTooltip(utils, entityPredicate.f_36552_).build("ali.property.branch.distance_to_player")).add(utils.getValueTooltip(utils, entityPredicate.f_36553_).build("ali.property.branch.location")).add(utils.getValueTooltip(utils, entityPredicate.f_150285_).build("ali.property.branch.stepping_on_location")).add(utils.getValueTooltip(utils, entityPredicate.f_36554_).build("ali.property.branch.mob_effects")).add(utils.getValueTooltip(utils, entityPredicate.f_36555_).build("ali.property.value.nbt")).add(utils.getValueTooltip(utils, entityPredicate.f_36556_).build("ali.property.branch.entity_flags")).add(utils.getValueTooltip(utils, entityPredicate.f_36557_).build("ali.property.branch.entity_equipment")).add(utils.getValueTooltip(utils, entityPredicate.f_218773_).build("ali.property.branch.entity_sub_predicate")).add(utils.getValueTooltip(utils, entityPredicate.f_36560_).build("ali.property.branch.vehicle")).add(utils.getValueTooltip(utils, entityPredicate.f_150287_).build("ali.property.branch.passenger")).add(utils.getValueTooltip(utils, entityPredicate.f_36561_).build("ali.property.branch.targeted_entity")).add(utils.getValueTooltip(utils, entityPredicate.f_36562_).build("ali.property.value.team"));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getEntityTypePredicateTooltip(IServerUtils utils, EntityTypePredicate entityTypePredicate) {
        if (entityTypePredicate != EntityTypePredicate.f_37636_) {
            if (entityTypePredicate instanceof EntityTypePredicate.TypePredicate) {
                EntityTypePredicate.TypePredicate typePredicate = (EntityTypePredicate.TypePredicate)entityTypePredicate;
                return utils.getValueTooltip(utils, typePredicate.f_37659_);
            }
            if (entityTypePredicate instanceof EntityTypePredicate.TagPredicate) {
                EntityTypePredicate.TagPredicate tagPredicate = (EntityTypePredicate.TagPredicate)entityTypePredicate;
                return utils.getValueTooltip(utils, tagPredicate.f_37653_);
            }
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getDistancePredicateTooltip(IServerUtils utils, DistancePredicate distancePredicate) {
        if (distancePredicate != DistancePredicate.f_26241_) {
            return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, distancePredicate.f_26242_).build("ali.property.value.x")).add(utils.getValueTooltip(utils, distancePredicate.f_26243_).build("ali.property.value.y")).add(utils.getValueTooltip(utils, distancePredicate.f_26244_).build("ali.property.value.z")).add(utils.getValueTooltip(utils, distancePredicate.f_26245_).build("ali.property.value.horizontal")).add(utils.getValueTooltip(utils, distancePredicate.f_26246_).build("ali.property.value.absolute"));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getLocationPredicateTooltip(IServerUtils utils, LocationPredicate locationPredicate) {
        if (locationPredicate != LocationPredicate.f_52592_) {
            return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, locationPredicate.f_52594_).build("ali.property.value.x")).add(utils.getValueTooltip(utils, locationPredicate.f_52595_).build("ali.property.value.y")).add(utils.getValueTooltip(utils, locationPredicate.f_52596_).build("ali.property.value.z")).add(utils.getValueTooltip(utils, locationPredicate.f_52597_).build("ali.property.value.biome")).add(utils.getValueTooltip(utils, locationPredicate.f_220588_).build("ali.property.value.structure")).add(utils.getValueTooltip(utils, locationPredicate.f_52599_).build("ali.property.value.dimension")).add(utils.getValueTooltip(utils, locationPredicate.f_52600_).build("ali.property.value.smokey")).add(utils.getValueTooltip(utils, locationPredicate.f_52601_).build("ali.property.value.light")).add(utils.getValueTooltip(utils, locationPredicate.f_52602_).build("ali.property.branch.block_predicate")).add(utils.getValueTooltip(utils, locationPredicate.f_52603_).build("ali.property.branch.fluid_predicate"));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getLightPredicateTooltip(IServerUtils utils, LightPredicate lightPredicate) {
        if (lightPredicate != LightPredicate.f_51335_) {
            return utils.getValueTooltip(utils, lightPredicate.f_51336_);
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getBlockPredicateTooltip(IServerUtils utils, BlockPredicate blockPredicate) {
        if (blockPredicate != BlockPredicate.f_17902_) {
            return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, blockPredicate.f_17903_).build("ali.property.value.tag")).add(utils.getValueTooltip(utils, blockPredicate.f_146710_).build("ali.property.branch.blocks")).add(utils.getValueTooltip(utils, blockPredicate.f_17905_).build("ali.property.branch.properties")).add(utils.getValueTooltip(utils, blockPredicate.f_17906_).build("ali.property.value.nbt"));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getNbtPredicateTooltip(IServerUtils utils, NbtPredicate nbtPredicate) {
        if (nbtPredicate != NbtPredicate.f_57471_) {
            return utils.getValueTooltip(utils, nbtPredicate.f_57472_);
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getFluidPredicateTooltip(IServerUtils utils, FluidPredicate fluidPredicate) {
        if (fluidPredicate != FluidPredicate.f_41094_) {
            return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, fluidPredicate.f_41095_).build("ali.property.value.tag")).add(utils.getValueTooltip(utils, fluidPredicate.f_41096_).build("ali.property.value.fluid")).add(utils.getValueTooltip(utils, fluidPredicate.f_41097_).build("ali.property.branch.properties"));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getMobEffectPredicateTooltip(IServerUtils utils, MobEffectsPredicate mobEffectsPredicate) {
        if (mobEffectsPredicate != MobEffectsPredicate.f_56547_) {
            return GenericTooltipUtils.getMapTooltip(utils, mobEffectsPredicate.f_56548_, GenericTooltipUtils::getMobEffectPredicateEntryTooltip);
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getEntityFlagsPredicateTooltip(IServerUtils utils, EntityFlagsPredicate predicate) {
        if (predicate != EntityFlagsPredicate.f_33682_) {
            return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, predicate.f_33683_).build("ali.property.value.is_on_fire")).add(utils.getValueTooltip(utils, predicate.f_33687_).build("ali.property.value.is_baby")).add(utils.getValueTooltip(utils, predicate.f_33684_).build("ali.property.value.is_crouching")).add(utils.getValueTooltip(utils, predicate.f_33685_).build("ali.property.value.is_sprinting")).add(utils.getValueTooltip(utils, predicate.f_33686_).build("ali.property.value.is_swimming"));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getEntityEquipmentPredicateTooltip(IServerUtils utils, EntityEquipmentPredicate predicate) {
        if (predicate != EntityEquipmentPredicate.f_32176_) {
            return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, predicate.f_32178_).build("ali.property.branch.head")).add(utils.getValueTooltip(utils, predicate.f_32179_).build("ali.property.branch.chest")).add(utils.getValueTooltip(utils, predicate.f_32180_).build("ali.property.branch.legs")).add(utils.getValueTooltip(utils, predicate.f_32181_).build("ali.property.branch.feet")).add(utils.getValueTooltip(utils, predicate.f_32182_).build("ali.property.branch.mainhand")).add(utils.getValueTooltip(utils, predicate.f_32183_).build("ali.property.branch.offhand"));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getItemPredicateTooltip(IServerUtils utils, ItemPredicate itemPredicate) {
        if (itemPredicate != ItemPredicate.f_45028_) {
            return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, itemPredicate.f_45029_).build("ali.property.value.tag")).add(utils.getValueTooltip(utils, itemPredicate.f_151427_).build("ali.property.branch.items")).add(utils.getValueTooltip(utils, itemPredicate.f_45031_).build("ali.property.value.count")).add(utils.getValueTooltip(utils, itemPredicate.f_45032_).build("ali.property.value.durability")).add(utils.getValueTooltip(utils, Arrays.asList(itemPredicate.f_45033_)).build("ali.property.branch.enchantments")).add(utils.getValueTooltip(utils, Arrays.asList(itemPredicate.f_45034_)).build("ali.property.branch.stored_enchantments")).add(utils.getValueTooltip(utils, itemPredicate.f_45035_).build("ali.property.value.potion")).add(utils.getValueTooltip(utils, itemPredicate.f_45036_).build("ali.property.value.nbt"));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getEnchantmentPredicateTooltip(IServerUtils utils, EnchantmentPredicate enchantmentPredicate) {
        if (enchantmentPredicate != EnchantmentPredicate.f_30464_) {
            return utils.getValueTooltip(utils, Objects.requireNonNullElse(enchantmentPredicate.f_30466_, Component.m_237115_((String)"ali.util.advanced_loot_info.any"))).add(utils.getValueTooltip(utils, enchantmentPredicate.f_30467_).build("ali.property.value.level"));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getEntitySubPredicateTooltip(IServerUtils utils, EntitySubPredicate entitySubPredicate) {
        if (entitySubPredicate != EntitySubPredicate.f_218826_) {
            Optional<Map.Entry> optional = EntitySubPredicate.Types.f_218854_.entrySet().stream().filter(p -> p.getValue() == entitySubPredicate.m_213836_()).findFirst();
            return optional.map(entry -> {
                BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
                if (entitySubPredicate instanceof LighthingBoltPredicate) {
                    LighthingBoltPredicate boltPredicate = (LighthingBoltPredicate)entitySubPredicate;
                    tooltip.add(utils.getValueTooltip(utils, boltPredicate.f_153235_).build("ali.property.value.blocks_on_fire"));
                    tooltip.add(utils.getValueTooltip(utils, boltPredicate.f_153236_).build("ali.property.branch.stuck_entity"));
                } else if (entitySubPredicate instanceof FishingHookPredicate) {
                    FishingHookPredicate fishingHookPredicate = (FishingHookPredicate)entitySubPredicate;
                    tooltip.add(utils.getValueTooltip(utils, fishingHookPredicate.f_39757_).build("ali.property.value.in_open_water"));
                } else if (entitySubPredicate instanceof PlayerPredicate) {
                    PlayerPredicate playerPredicate = (PlayerPredicate)entitySubPredicate;
                    tooltip.add(utils.getValueTooltip(utils, playerPredicate.f_62245_).build("ali.property.value.level"));
                    tooltip.add(utils.getValueTooltip(utils, playerPredicate.f_62246_).build("ali.property.value.game_type"));
                    tooltip.add(GenericTooltipUtils.getStatsTooltip(utils, playerPredicate.f_62247_).build("ali.property.branch.stats"));
                    tooltip.add(GenericTooltipUtils.getMapTooltip(utils, playerPredicate.f_62248_, GenericTooltipUtils::getRecipeEntryTooltip).build("ali.property.branch.recipes"));
                    tooltip.add(GenericTooltipUtils.getMapTooltip(utils, playerPredicate.f_62249_, GenericTooltipUtils::getAdvancementEntryTooltip).build("ali.property.branch.advancements"));
                    tooltip.add(utils.getValueTooltip(utils, playerPredicate.f_156744_).build("ali.property.branch.looking_at"));
                } else if (entitySubPredicate instanceof SlimePredicate) {
                    SlimePredicate slimePredicate = (SlimePredicate)entitySubPredicate;
                    tooltip.add(utils.getValueTooltip(utils, slimePredicate.f_223418_).build("ali.property.value.size"));
                } else {
                    JsonObject jsonObject = entitySubPredicate.m_213616_();
                    if (jsonObject.has("variant")) {
                        tooltip.add(utils.getValueTooltip(utils, jsonObject.getAsJsonPrimitive("variant").getAsString()).build("ali.property.value.variant"));
                    } else {
                        tooltip.add(utils.getValueTooltip(utils, jsonObject.getAsString()).build("ali.property.value.variant"));
                    }
                }
                return tooltip;
            }).orElse(EmptyTooltipNode.empty());
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getBlockPosTooltip(IServerUtils ignoredUtils, BlockPos pos) {
        return ValueTooltipNode.value(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    @NotNull
    public static IKeyTooltipNode getCopyOperationTooltip(IServerUtils utils, CopyNbtFunction.CopyOperation copyOperation) {
        return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, copyOperation.f_80288_).build("ali.property.value.source")).add(utils.getValueTooltip(utils, copyOperation.f_80290_).build("ali.property.value.target")).add(utils.getValueTooltip(utils, copyOperation.f_80292_).build("ali.property.value.merge_strategy"));
    }

    @NotNull
    public static IKeyTooltipNode getCompoundTagTooltip(IServerUtils utils, CompoundTag tag) {
        return utils.getValueTooltip(utils, tag.toString());
    }

    @NotNull
    public static IKeyTooltipNode getAdvancementPredicateTooltip(IServerUtils utils, PlayerPredicate.AdvancementPredicate predicate) {
        if (predicate instanceof PlayerPredicate.AdvancementDonePredicate) {
            PlayerPredicate.AdvancementDonePredicate donePredicate = (PlayerPredicate.AdvancementDonePredicate)predicate;
            return utils.getValueTooltip(utils, donePredicate.f_62299_);
        }
        if (predicate instanceof PlayerPredicate.AdvancementCriterionsPredicate) {
            PlayerPredicate.AdvancementCriterionsPredicate criterionsPredicate = (PlayerPredicate.AdvancementCriterionsPredicate)predicate;
            return GenericTooltipUtils.getMapTooltip(utils, criterionsPredicate.f_62291_, GenericTooltipUtils::getCriterionEntryTooltip);
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getItemStackTooltip(IServerUtils utils, ItemStack item) {
        return BranchTooltipNode.branch().add(utils.getValueTooltip(utils, item.m_41720_()).build("ali.property.value.item")).add(utils.getValueTooltip(utils, item.m_41613_()).build("ali.property.value.count")).add(utils.getValueTooltip(utils, item.m_41783_()).build("ali.property.value.tag"));
    }

    @NotNull
    public static IKeyTooltipNode getNumberProviderTooltip(IServerUtils utils, NumberProvider value) {
        return ValueTooltipNode.value(utils.convertNumber(utils, value));
    }

    @NotNull
    public static IKeyTooltipNode getIntRangeTooltip(IServerUtils utils, IntRange range) {
        return ValueTooltipNode.value(RangeValue.rangeToString(utils.convertNumber(utils, range.f_165001_), utils.convertNumber(utils, range.f_165002_)));
    }

    @NotNull
    public static IKeyTooltipNode getBooleanTooltip(IServerUtils ignoredUtils, Boolean value) {
        return ValueTooltipNode.value(value);
    }

    @NotNull
    public static IKeyTooltipNode getIntegerTooltip(IServerUtils ignoredUtils, int value) {
        return ValueTooltipNode.value(value);
    }

    @NotNull
    public static IKeyTooltipNode getLongTooltip(IServerUtils ignoredUtils, Long value) {
        return ValueTooltipNode.value(value);
    }

    @NotNull
    public static IKeyTooltipNode getByteTooltip(IServerUtils ignoredUtils, Byte value) {
        return ValueTooltipNode.value(value);
    }

    @NotNull
    public static IKeyTooltipNode getStringTooltip(IServerUtils ignoredUtils, String value) {
        return ValueTooltipNode.value(value);
    }

    @NotNull
    public static IKeyTooltipNode getFloatTooltip(IServerUtils ignoredUtils, Float value) {
        return ValueTooltipNode.value(value);
    }

    @NotNull
    public static IKeyTooltipNode getDoubleTooltip(IServerUtils ignoredUtils, Double value) {
        return ValueTooltipNode.value(value);
    }

    @NotNull
    public static IKeyTooltipNode getEnumTooltip(IServerUtils ignoredUtils, Enum<?> value) {
        return ValueTooltipNode.value(value.name());
    }

    @NotNull
    public static IKeyTooltipNode getResourceLocationTooltip(IServerUtils ignoredUtils, ResourceLocation value) {
        return ValueTooltipNode.value(value);
    }

    @NotNull
    public static <T> IKeyTooltipNode getBuiltInRegistryTooltip(IServerUtils utils, Registry<T> registry, T value) {
        return utils.getValueTooltip(utils, registry.m_7981_(value));
    }

    @NotNull
    public static <T> IKeyTooltipNode getResourceKeyTooltip(IServerUtils utils, ResourceKey<T> value) {
        return utils.getValueTooltip(utils, value.m_135782_());
    }

    @NotNull
    public static IKeyTooltipNode getTagKeyTooltip(IServerUtils utils, TagKey<?> value) {
        return utils.getValueTooltip(utils, value.f_203868_());
    }

    @NotNull
    public static IKeyTooltipNode getComponentTooltip(IServerUtils ignoredUtils, Component component) {
        return ComponentTooltipNode.values(new Component[]{component.m_6881_()});
    }

    @NotNull
    public static IKeyTooltipNode getMinMaxBoundsTooltip(IServerUtils ignoredUtils, MinMaxBounds.Ints ints) {
        if (ints != MinMaxBounds.Ints.f_55364_) {
            return ValueTooltipNode.value(GenericTooltipUtils.toString(ints));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static IKeyTooltipNode getMinMaxBoundsTooltip(IServerUtils ignoredUtils, MinMaxBounds.Doubles doubles) {
        if (doubles != MinMaxBounds.Doubles.f_154779_) {
            return ValueTooltipNode.value(GenericTooltipUtils.toString(doubles));
        }
        return EmptyTooltipNode.empty();
    }

    @NotNull
    public static <T> IKeyTooltipNode getHolderTooltip(IServerUtils utils, Holder<T> holder) {
        return utils.getValueTooltip(utils, holder.m_203334_());
    }

    @NotNull
    public static <T> IKeyTooltipNode getOptionalTooltip(IServerUtils utils, Optional<T> optional) {
        return optional.map(v -> utils.getValueTooltip(utils, v)).orElse(EmptyTooltipNode.empty());
    }

    @NotNull
    public static IKeyTooltipNode getCollectionTooltip(IServerUtils utils, @Nullable Collection<?> collection) {
        if (collection == null || collection.isEmpty()) {
            return EmptyTooltipNode.empty();
        }
        BranchTooltipNode.Builder tooltip = BranchTooltipNode.branch();
        for (Object o : collection) {
            tooltip.add(utils.getValueTooltip(utils, o).build("ali.property.value.null"));
        }
        return tooltip;
    }
}

