/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.manager;

import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IClientRegistry;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.ICommonUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.RelativeRect;
import com.yanny.ali.api.WidgetDirection;
import com.yanny.ali.plugin.common.nodes.MissingNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public class AliClientRegistry
implements IClientRegistry,
IClientUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int PADDING = 2;
    private final Map<ResourceLocation, IClientRegistry.IWidgetFactory> widgetMap = new HashMap<ResourceLocation, IClientRegistry.IWidgetFactory>();
    private final Map<ResourceLocation, IClientRegistry.DataFactory<?>> dataNodeFactoryMap = new HashMap();
    private final Map<ResourceLocation, IClientRegistry.TooltipFactory<?>> tooltipNodeFactoryMap = new HashMap();
    private final ICommonUtils utils;
    private final AtomicInteger receivedChunks = new AtomicInteger(0);
    private final AtomicInteger receivedChunksPerSecond = new AtomicInteger(0);
    private ScheduledExecutorService loggerScheduler;
    private volatile DataReceiver currentDataReceiver = null;

    public AliClientRegistry(ICommonUtils utils) {
        this.utils = utils;
    }

    public CompletableFuture<byte[]> getCurrentDataFuture() {
        DataReceiver receiver = this.currentDataReceiver;
        if (receiver == null) {
            return CompletableFuture.completedFuture(new byte[0]);
        }
        return receiver.getFuture();
    }

    public void addChunkData(int index, byte[] data) {
        DataReceiver receiver = this.currentDataReceiver;
        if (receiver == null) {
            return;
        }
        this.receivedChunks.incrementAndGet();
        this.receivedChunksPerSecond.incrementAndGet();
        receiver.messageReceived(index, data);
    }

    public synchronized void startLootData(int totalMessages) {
        if (this.currentDataReceiver != null && !this.currentDataReceiver.getFuture().isDone()) {
            LOGGER.warn("Tried to start data reception while another operation is in progress.");
            return;
        }
        this.currentDataReceiver = new DataReceiver(totalMessages);
        this.startLogging();
        LOGGER.info("Started receiving loot data");
    }

    public synchronized void clearLootData() {
        if (this.currentDataReceiver != null) {
            this.currentDataReceiver.cancelOperation();
            this.currentDataReceiver = null;
            this.stopLogging();
        }
        LOGGER.info("Cleared Loot data");
    }

    public synchronized void doneLootData() {
        DataReceiver receiver = this.currentDataReceiver;
        if (receiver == null) {
            return;
        }
        receiver.forceDone();
        this.stopLogging();
        LOGGER.info("Finished receiving loot data");
    }

    @Override
    public void registerWidget(ResourceLocation id, IClientRegistry.IWidgetFactory factory) {
        this.widgetMap.put(id, factory);
    }

    @Override
    public <T extends IDataNode> void registerDataNode(ResourceLocation id, IClientRegistry.DataFactory<T> dataFactory) {
        this.dataNodeFactoryMap.put(id, dataFactory);
    }

    @Override
    public <T extends ITooltipNode> void registerTooltipNode(ResourceLocation id, IClientRegistry.TooltipFactory<T> tooltipFactory) {
        this.tooltipNodeFactoryMap.put(id, tooltipFactory);
    }

    @Override
    public List<IWidget> createWidgets(IWidgetUtils utils, List<IDataNode> entries, RelativeRect parent, int maxWidth) {
        int posX = 0;
        int posY = 0;
        ArrayList<IWidget> widgets = new ArrayList<IWidget>(entries.size());
        WidgetDirection lastDirection = null;
        for (IDataNode entry : entries) {
            IClientRegistry.IWidgetFactory widgetFactory = this.widgetMap.getOrDefault(entry.getId(), this.widgetMap.get(MissingNode.ID));
            IWidget widget = widgetFactory.create(utils, entry, new RelativeRect(posX, posY, parent.width - posX, 0, parent), maxWidth);
            RelativeRect bounds = widget.getRect();
            WidgetDirection direction = widget.getDirection();
            if (lastDirection == null) {
                if (direction == WidgetDirection.HORIZONTAL) {
                    posX += bounds.width;
                } else {
                    posY += bounds.height + 2;
                }
            } else if (lastDirection == WidgetDirection.HORIZONTAL && direction == WidgetDirection.HORIZONTAL) {
                if (bounds.getRight() <= maxWidth) {
                    posX += bounds.width;
                } else {
                    posX = bounds.width;
                    bounds.setOffset(0, posY += ((IWidget)widgets.get((int)(widgets.size() - 1))).getRect().height);
                }
            } else {
                posX = 0;
                if (direction != lastDirection) {
                    if (lastDirection == WidgetDirection.HORIZONTAL) {
                        posY += ((IWidget)widgets.get((int)(widgets.size() - 1))).getRect().height + 2;
                    }
                    bounds.setOffset(posX, posY);
                }
                posY += bounds.height + 2;
            }
            widgets.add(widget);
            lastDirection = direction;
        }
        int w = 0;
        int h = 0;
        for (IWidget widget : widgets) {
            RelativeRect rect = widget.getRect();
            w = Math.max(w, rect.offsetX + rect.width);
            h = Math.max(h, rect.offsetY + rect.height);
        }
        parent.setDimensions(w, h);
        return widgets;
    }

    @Override
    public <T extends IDataNode> IClientRegistry.DataFactory<T> getDataNodeFactory(ResourceLocation id) {
        IClientRegistry.DataFactory<?> dataFactory = this.dataNodeFactoryMap.get(id);
        return Objects.requireNonNullElseGet(dataFactory, () -> {
            throw new IllegalStateException(String.format("Failed to construct data node - node {%s} was not registered!", id));
        });
    }

    @Override
    public <T extends ITooltipNode> IClientRegistry.TooltipFactory<T> getTooltipNodeFactory(ResourceLocation id) {
        IClientRegistry.TooltipFactory<?> tooltipFactory = this.tooltipNodeFactoryMap.get(id);
        return Objects.requireNonNullElseGet(tooltipFactory, () -> {
            throw new IllegalStateException(String.format("Failed to construct tooltip node - node {%s} was not registered!", id));
        });
    }

    @Override
    public List<Entity> createEntities(EntityType<?> type, Level level) {
        return this.utils.createEntities(type, level);
    }

    public void printRegistrationInfo() {
        LOGGER.info("Registered {} widgets", (Object)this.widgetMap.size());
        LOGGER.info("Registered {} data node factories", (Object)this.dataNodeFactoryMap.size());
        LOGGER.info("Registered {} tooltip node factories", (Object)this.tooltipNodeFactoryMap.size());
    }

    private void startLogging() {
        Runnable logTask = () -> {
            long count = this.receivedChunksPerSecond.getAndSet(0);
            LOGGER.info("Received {} chunk(s) per second", (Object)count);
        };
        this.receivedChunks.set(0);
        this.receivedChunksPerSecond.set(0);
        this.loggerScheduler = Executors.newSingleThreadScheduledExecutor();
        this.loggerScheduler.scheduleAtFixedRate(logTask, 1L, 1L, TimeUnit.SECONDS);
    }

    private void stopLogging() {
        if (this.loggerScheduler != null) {
            long count = this.receivedChunksPerSecond.getAndSet(0);
            LOGGER.info("Received last {} chunk(s). Done receiving data.", (Object)count);
            this.loggerScheduler.shutdownNow();
            try {
                if (!this.loggerScheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                    LOGGER.warn("Logging scheduler didn't stop in time!");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static class DataReceiver {
        private static final long INACTIVITY_TIMEOUT_SECONDS = 30L;
        private final CompletableFuture<byte[]> dataFuture = new CompletableFuture();
        private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        private final AtomicReference<ScheduledFuture<?>> timeoutHandleRef = new AtomicReference();
        private final Map<Integer, byte[]> chunkMap = new HashMap<Integer, byte[]>();
        private final CountDownLatch completionLatch;

        public DataReceiver(int expectedMessageCount) {
            this.completionLatch = new CountDownLatch(expectedMessageCount);
            this.resetInactivityTimeout();
            CompletableFuture.runAsync(() -> {
                try {
                    this.completionLatch.await();
                    if (!this.dataFuture.isDone()) {
                        this.completeFuture();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.dataFuture.completeExceptionally(e);
                    this.shutdownScheduler();
                }
            });
        }

        public void messageReceived(int index, byte[] data) {
            if (this.dataFuture.isDone()) {
                return;
            }
            this.chunkMap.put(index, data);
            this.resetInactivityTimeout();
            this.completionLatch.countDown();
        }

        public void forceDone() {
            while (this.completionLatch.getCount() > 0L) {
                this.completionLatch.countDown();
            }
            if (!this.dataFuture.isDone()) {
                this.completeFuture();
            }
        }

        private void completeFuture() {
            int totalCompressedSize = this.chunkMap.values().stream().mapToInt(a -> ((byte[])a).length).sum();
            byte[] fullCompressedData = new byte[totalCompressedSize];
            int offset = 0;
            for (byte[] chunk : this.chunkMap.values()) {
                System.arraycopy(chunk, 0, fullCompressedData, offset, chunk.length);
                offset += chunk.length;
            }
            this.dataFuture.complete(fullCompressedData);
            this.shutdownScheduler();
        }

        private void resetInactivityTimeout() {
            Runnable timeoutTask = () -> {
                if (!this.dataFuture.isDone()) {
                    String msg = String.format("Data reception failed due to inactivity timeout (%ds).", 30L);
                    this.dataFuture.completeExceptionally(new TimeoutException(msg));
                    this.shutdownScheduler();
                }
            };
            ScheduledFuture previousHandle = this.timeoutHandleRef.getAndSet(null);
            if (previousHandle != null) {
                previousHandle.cancel(false);
            }
            ScheduledFuture<?> newHandle = this.scheduler.schedule(timeoutTask, 30L, TimeUnit.SECONDS);
            this.timeoutHandleRef.set(newHandle);
        }

        public void cancelOperation() {
            if (!this.dataFuture.isDone()) {
                this.dataFuture.cancel(true);
            }
            this.shutdownScheduler();
        }

        private void shutdownScheduler() {
            ScheduledFuture currentHandle = this.timeoutHandleRef.getAndSet(null);
            if (currentHandle != null) {
                currentHandle.cancel(false);
            }
            this.scheduler.shutdownNow();
        }

        public CompletableFuture<byte[]> getFuture() {
            return this.dataFuture;
        }
    }
}

