/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.emi;

import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.Rect;
import com.yanny.ali.api.RelativeRect;
import com.yanny.ali.compatibility.common.EntityStorage;
import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.compatibility.emi.EmiBaseLoot;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.plugin.client.widget.LootTableWidget;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EmiEntityLoot
extends EmiBaseLoot {
    private final EntityType<?> entityType;
    private final ResourceLocation variant;

    public EmiEntityLoot(EmiRecipeCategory category, ResourceLocation id, EntityType<?> entityType, IDataNode lootTable, List<ItemStack> outputs) {
        super(category, id, lootTable, 0, 48, Collections.emptyList(), outputs);
        this.entityType = entityType;
        this.variant = id;
        SpawnEggItem spawnEgg = SpawnEggItem.m_43213_(entityType);
        if (spawnEgg != null) {
            this.catalysts = List.of(EmiStack.of((ItemLike)spawnEgg));
        }
    }

    public int getDisplayHeight() {
        return 48 + this.getItemsHeight();
    }

    @Override
    protected List<Widget> getAdditionalWidgets(final WidgetHolder widgetHolder) {
        LinkedList<Widget> widgets = new LinkedList<Widget>();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            int length = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.entityType.m_20676_());
            widgets.add(new Widget(){
                private static final int WIDGET_SIZE = 36;
                final Bounds bounds;
                final Rect rect;
                {
                    this.bounds = new Bounds((widgetHolder.getWidth() - 36) / 2, 10, 36, 36);
                    this.rect = new Rect(this.bounds.x(), this.bounds.y(), this.bounds.width(), this.bounds.height());
                }

                public Bounds getBounds() {
                    return this.bounds;
                }

                public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
                    ClientLevel level = Minecraft.m_91087_().f_91073_;
                    if (level != null) {
                        Entity entity = EntityStorage.getEntity(PluginManager.COMMON_REGISTRY, EmiEntityLoot.this.entityType, (Level)level, EmiEntityLoot.this.variant);
                        GenericUtils.renderEntity(entity, this.rect, widgetHolder.getWidth(), guiGraphics, mouseX, mouseY);
                    }
                }
            });
            widgets.add((Widget)new TextWidget(this.entityType.m_20676_().m_7532_(), (widgetHolder.getWidth() - length) / 2, 0, 0, false));
        }
        this.catalysts.forEach(catalyst -> widgets.add((Widget)new SlotWidget(catalyst, 0, 0)));
        return widgets;
    }

    @Override
    IWidget getRootWidget(IWidgetUtils utils, IDataNode entry, RelativeRect rect, int maxWidth) {
        return new LootTableWidget(utils, entry, rect, maxWidth);
    }
}

