/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.schematic.requirement;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import se.mickelus.mutil.util.JsonOptional;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.ModuleRegistry;
import se.mickelus.tetra.module.schematic.CraftingContext;
import se.mickelus.tetra.module.schematic.requirement.CraftingRequirement;

public class ModuleRequirement
implements CraftingRequirement {
    String moduleKey;
    String moduleVariant;
    String materialPattern;

    public ModuleRequirement(String moduleKey, String moduleVariant, String moduleMaterial) {
        this.moduleKey = moduleKey;
        this.moduleVariant = moduleVariant;
        if (moduleMaterial != null) {
            this.materialPattern = "\\/" + moduleMaterial + "(?:_|$)";
        }
    }

    @Override
    public boolean test(CraftingContext context) {
        if (context.targetModule != null) {
            if (this.moduleKey != null && !this.moduleKey.equals(context.targetModule.getKey())) {
                return false;
            }
            String currentVariant = context.targetModule.getVariantData((ItemStack)context.targetStack).key;
            if (this.moduleVariant != null && !this.moduleVariant.equals(currentVariant)) {
                return false;
            }
            return this.materialPattern == null || currentVariant.matches(this.materialPattern);
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public List<Component> getDescription() {
        String[] values = new String[]{this.moduleKey != null ? I18n.m_118938_((String)"tetra.holo.module_requirement.module_key", (Object[])new Object[]{ModuleRequirement.getModuleName(this.moduleKey)}) : null, this.moduleVariant != null ? I18n.m_118938_((String)"tetra.holo.module_requirement.variant_key", (Object[])new Object[]{ItemModule.getVariantName(this.moduleVariant)}) : null, this.materialPattern != null ? I18n.m_118938_((String)"tetra.holo.module_requirement.material", (Object[])new Object[]{I18n.m_118938_((String)("tetra.material." + this.materialPattern), (Object[])new Object[0])}) : null};
        return List.of(Component.m_237113_((String)("Module " + Arrays.stream(values).filter(Objects::nonNull).collect(Collectors.joining(", ")))));
    }

    static String getModuleName(String moduleKey) {
        if (I18n.m_118936_((String)("tetra.module." + moduleKey + ".name"))) {
            return ItemModule.getModuleName(moduleKey);
        }
        return Optional.ofNullable(ModuleRegistry.instance.getModule(new ResourceLocation("tetra", moduleKey))).map(module -> ItemModule.getModuleName(module.getUnlocalizedName())).orElse(moduleKey);
    }

    public static class Deserializer
    implements JsonDeserializer<CraftingRequirement> {
        public CraftingRequirement deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new ModuleRequirement(JsonOptional.field((JsonObject)json.getAsJsonObject(), (String)"module").map(JsonElement::getAsString).orElse(null), JsonOptional.field((JsonObject)json.getAsJsonObject(), (String)"variant").map(JsonElement::getAsString).orElse(null), JsonOptional.field((JsonObject)json.getAsJsonObject(), (String)"material").map(JsonElement::getAsString).orElse(null));
        }
    }
}

