/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.shield;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Holder;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.items.modular.impl.shield.ModularShieldBannerModel;
import se.mickelus.tetra.items.modular.impl.shield.ModularShieldItem;
import se.mickelus.tetra.items.modular.impl.shield.ModularShieldModel;

@ParametersAreNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class ModularShieldRenderer
extends BlockEntityWithoutLevelRenderer {
    public static ModelLayerLocation layer = new ModelLayerLocation(new ResourceLocation("tetra", "item/shield"), "main");
    public static ModelLayerLocation bannerLayer = new ModelLayerLocation(new ResourceLocation("tetra", "item/shield_banner"), "main");
    private final EntityModelSet modelSet;
    public ModularShieldBannerModel bannerModel;
    private ModularShieldModel model;

    public ModularShieldRenderer(Minecraft minecraft) {
        super(minecraft.m_167982_(), minecraft.m_167973_());
        this.modelSet = minecraft.m_167973_();
        this.model = new ModularShieldModel(this.modelSet.m_171103_(layer));
        this.bannerModel = new ModularShieldBannerModel(this.modelSet.m_171103_(bannerLayer));
        ((ReloadableResourceManager)Minecraft.m_91087_().m_91098_()).m_7217_((PreparableReloadListener)this);
    }

    public void m_6213_(ResourceManager p_172555_) {
        this.model = new ModularShieldModel(this.modelSet.m_171103_(layer));
        this.bannerModel = new ModularShieldBannerModel(this.modelSet.m_171103_(bannerLayer));
    }

    public void m_108829_(ItemStack itemStack, ItemDisplayContext displayContext, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        matrixStack.m_85836_();
        matrixStack.m_85841_(1.0f, -1.0f, -1.0f);
        Collection models = (Collection)CastOptional.cast((Object)itemStack.m_41720_(), ModularShieldItem.class).map(item -> item.getModels(itemStack, null)).orElse(ImmutableList.of());
        models.forEach(modelData -> {
            ModelPart bannerPart = this.bannerModel.getModel(modelData.type);
            if (bannerPart != null) {
                if (itemStack.m_41737_("BlockEntityTag") != null) {
                    this.renderBanner(itemStack, bannerPart, matrixStack, buffer, combinedLight, combinedOverlay);
                }
                return;
            }
            ModelPart modelPart = this.model.getModel(modelData.type);
            if (modelPart != null) {
                Material material = new Material(TextureAtlas.f_118259_, modelData.location);
                VertexConsumer vertexBuilder = material.m_119204_().m_118381_(ItemRenderer.m_115211_((MultiBufferSource)buffer, (RenderType)this.model.m_103119_(material.m_119193_()), (boolean)false, (boolean)itemStack.m_41790_()));
                float r = (float)(modelData.tint >> 16 & 0xFF) / 255.0f;
                float g = (float)(modelData.tint >> 8 & 0xFF) / 255.0f;
                float b = (float)(modelData.tint >> 0 & 0xFF) / 255.0f;
                float a = (float)(modelData.tint >> 24 & 0xFF) / 255.0f;
                a = a == 0.0f ? 1.0f : a;
                modelPart.m_104306_(matrixStack, vertexBuilder, combinedLight, combinedOverlay, r, g, b, a);
            }
        });
        matrixStack.m_85849_();
    }

    private void renderBanner(ItemStack itemStack, ModelPart modelRenderer, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        List list = BannerBlockEntity.m_58484_((DyeColor)ShieldItem.m_43102_((ItemStack)itemStack), (ListTag)BannerBlockEntity.m_58487_((ItemStack)itemStack));
        for (int i = 0; i < 17 && i < list.size(); ++i) {
            Pair pair = (Pair)list.get(i);
            float[] tint = ((DyeColor)pair.getSecond()).m_41068_();
            ((Holder)pair.getFirst()).m_203543_().map(Sheets::m_234349_).ifPresent(material -> {
                VertexConsumer vertexBuilder = material.m_119204_().m_118381_(ItemRenderer.m_115211_((MultiBufferSource)buffer, (RenderType)RenderType.m_110476_((ResourceLocation)material.m_119193_()), (boolean)false, (boolean)itemStack.m_41790_()));
                modelRenderer.m_104306_(matrixStack, vertexBuilder, combinedLight, combinedOverlay, tint[0], tint[1], tint[2], 1.0f);
            });
        }
    }

    private void renderEtching(ItemStack itemStack, ModelPart modelRenderer, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        List list = BannerBlockEntity.m_58484_((DyeColor)ShieldItem.m_43102_((ItemStack)itemStack), (ListTag)BannerBlockEntity.m_58487_((ItemStack)itemStack));
        for (int i = 0; i < 17 && i < list.size(); ++i) {
            Pair pair = (Pair)list.get(i);
            if (BannerPatterns.f_222726_.equals(((Holder)pair.getFirst()).m_203543_().orElse(null))) continue;
            float[] tint = ((DyeColor)pair.getSecond()).m_41068_();
            ((Holder)pair.getFirst()).m_203543_().map(Sheets::m_234349_).ifPresent(material -> {
                VertexConsumer vertexBuilder = material.m_119204_().m_118381_(ItemRenderer.m_115211_((MultiBufferSource)buffer, (RenderType)RenderType.m_110482_((ResourceLocation)material.m_119193_()), (boolean)false, (boolean)itemStack.m_41790_()));
                modelRenderer.m_104306_(matrixStack, vertexBuilder, combinedLight, combinedOverlay, tint[0], tint[1], tint[2], 0.7f);
            });
        }
    }
}

