/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.stats.data;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Map;
import se.mickelus.mutil.util.JsonOptional;
import se.mickelus.tetra.gui.stats.getter.IStatFormat;
import se.mickelus.tetra.gui.stats.getter.StatFormat;

public class StatFormatDeserializers {
    static final Map<String, String> predefinedFormats = ImmutableMap.builder().put((Object)"integer", (Object)"%.0f").put((Object)"single_decimal", (Object)"%.01f").put((Object)"double_decimal", (Object)"%.02f").put((Object)"percentage", (Object)"%.0f%%").put((Object)"percentage_decimal", (Object)"%.01f%%").build();
    static final Map<String, String> predefinedDiffFormats = ImmutableMap.builder().put((Object)"integer", (Object)"%+.0f").put((Object)"single_decimal", (Object)"%+.01f").put((Object)"double_decimal", (Object)"%+.02f").put((Object)"percentage", (Object)"%+.0f%%").put((Object)"percentage_decimal", (Object)"%+.01f%%").build();

    public static IStatFormat basicStatformat(JsonElement json) {
        if (!json.isJsonObject()) {
            throw new JsonParseException("Expected object, got " + json.getClass().getSimpleName());
        }
        JsonObject jsonObject = json.getAsJsonObject();
        String format = JsonOptional.field((JsonObject)jsonObject, (String)"format").map(JsonElement::getAsString).map(val -> predefinedFormats.getOrDefault(val, (String)val)).orElseThrow(() -> new JsonParseException("Missing required field 'format'"));
        return new StatFormat(format);
    }

    public static IStatFormat abbreviateStatformat(JsonElement json) {
        return StatFormat.abbreviate;
    }
}

