/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiTexture;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.data.SynergyData;

@ParametersAreNonnullByDefault
public class GuiSynergyIndicator
extends GuiElement {
    private static final int activeCoord = 176;
    private static final int inactiveCoord = 186;
    private static final int emptyCoord = 196;
    protected List<Component> tooltip;
    protected GuiTexture indicator;
    protected boolean alwaysShowStats;

    public GuiSynergyIndicator(int x, int y) {
        super(x, y, 10, 10);
        this.indicator = new GuiTexture(0, 0, this.width, this.height, 176, 0, GuiTextures.workbench);
        this.addChild((GuiElement)this.indicator);
    }

    public GuiSynergyIndicator(int x, int y, boolean alwaysShowStats) {
        this(x, y);
        this.alwaysShowStats = alwaysShowStats;
    }

    public void update(ItemStack itemStack, ItemModule module) {
        String moduleKey = module.getUnlocalizedName();
        String moduleVariant = module.getVariantData((ItemStack)itemStack).key;
        boolean hasActive = this.alwaysShowStats;
        this.tooltip = new ArrayList<Component>();
        this.tooltip.add((Component)Component.m_237115_((String)"tetra.modular.synergy_indicator.header").m_130940_(ChatFormatting.GRAY));
        Item item = itemStack.m_41720_();
        if (item instanceof IModularItem) {
            IModularItem item2 = (IModularItem)item;
            Set activeSynergies = Arrays.stream(item2.getSynergyData(itemStack)).collect(Collectors.toSet());
            hasActive = hasActive || Arrays.stream(item2.getSynergyData(itemStack)).filter(data -> this.shouldShow((SynergyData)data, activeSynergies, moduleKey, moduleVariant)).anyMatch(this::providesStats);
            Arrays.stream(item2.getAllSynergyData(itemStack)).filter(data -> this.shouldShow((SynergyData)data, activeSynergies, moduleKey, moduleVariant)).filter(this::providesStats).flatMap(data -> this.getLines(activeSynergies.contains(data), (SynergyData)data).stream()).map(Component::m_237113_).collect(Collectors.toCollection(() -> this.tooltip));
        }
        if (this.tooltip.size() <= 1) {
            this.tooltip = Collections.singletonList(Component.m_237115_((String)"tetra.modular.synergy_indicator.empty").m_130940_(ChatFormatting.GRAY));
            this.indicator.setTextureCoordinates(196, 0);
        } else if (!hasActive) {
            this.indicator.setTextureCoordinates(186, 0);
        } else {
            this.indicator.setTextureCoordinates(176, 0);
        }
    }

    public void update(ItemStack itemStack, String slot) {
        CastOptional.cast((Object)itemStack.m_41720_(), IModularItem.class).map(item -> item.getModuleFromSlot(itemStack, slot)).ifPresent(module -> this.update(itemStack, (ItemModule)module));
    }

    private boolean shouldShow(SynergyData data, Set<SynergyData> activeSynergies, String moduleKey, String moduleVariant) {
        if (data.hidden) {
            return false;
        }
        if (data.obscured) {
            return activeSynergies.contains(data);
        }
        if (data.visibilityKey != null && !data.visibilityKey.equals(moduleKey) && !data.visibilityKey.equals(moduleVariant)) {
            return false;
        }
        return this.matchesModule(data, moduleKey) || this.matchesVariant(data, moduleVariant);
    }

    private boolean matchesModule(SynergyData data, String moduleKey) {
        return Arrays.asList(data.modules).contains(moduleKey);
    }

    private boolean matchesVariant(SynergyData data, String moduleVariant) {
        return Arrays.asList(data.moduleVariants).contains(moduleVariant);
    }

    private boolean providesStats(SynergyData data) {
        return data.attributes != null || data.tools != null || data.effects != null || data.durability != 0 || data.durabilityMultiplier != 1.0f || data.integrity != 0 || data.integrityMultiplier != 1.0f || data.magicCapacity != 0;
    }

    private List<String> getLines(boolean isActive, SynergyData data) {
        String header = this.getHeaderLine(isActive, data);
        if (isActive || this.alwaysShowStats) {
            List<String> result = this.getStatLines(data);
            result.add(0, header);
            return result;
        }
        return Collections.singletonList(header);
    }

    private String getHeaderLine(boolean isActive, SynergyData data) {
        return (isActive ? ChatFormatting.GREEN + "\u00bb " + ChatFormatting.WHITE : ChatFormatting.BOLD + "  " + ChatFormatting.DARK_GRAY) + Stream.concat(Arrays.stream(data.moduleVariants).map(key -> I18n.m_118938_((String)("tetra.variant." + key), (Object[])new Object[0])), Arrays.stream(data.modules).map(key -> I18n.m_118938_((String)("tetra.module." + key + ".name"), (Object[])new Object[0]))).collect(Collectors.joining(" + "));
    }

    private List<String> getStatLines(SynergyData data) {
        ArrayList<String> result = new ArrayList<String>();
        if (data.attributes != null) {
            data.attributes.forEach((attribute, modifier) -> {
                double amount = modifier.m_22218_();
                if (modifier.m_22217_() == AttributeModifier.Operation.ADDITION) {
                    result.add(this.getValueDouble(amount, 0.0) + I18n.m_118938_((String)attribute.m_22087_(), (Object[])new Object[0]));
                } else {
                    result.add(this.getValueMultiplier(amount + 1.0) + I18n.m_118938_((String)attribute.m_22087_(), (Object[])new Object[0]));
                }
            });
        }
        if (data.durability != 0) {
            result.add(this.getValueInteger(data.durability, 0) + I18n.m_118938_((String)"tetra.stats.durability", (Object[])new Object[0]));
        }
        if (data.durabilityMultiplier != 1.0f) {
            result.add(this.getValueMultiplier(data.durabilityMultiplier) + I18n.m_118938_((String)"tetra.stats.durability", (Object[])new Object[0]));
        }
        if (data.integrity != 0) {
            result.add(this.getValueInteger(data.integrity, 0) + I18n.m_118938_((String)"tetra.stats.integrity", (Object[])new Object[0]));
        }
        if (data.integrityMultiplier != 1.0f) {
            result.add(this.getValueMultiplier(data.integrityMultiplier) + I18n.m_118938_((String)"tetra.stats.integrity", (Object[])new Object[0]));
        }
        if (data.effects != null) {
            data.effects.getLevelMap().forEach((itemEffect, level) -> result.add(this.getValueInteger((int)level, 0) + I18n.m_118938_((String)("tetra.stats." + itemEffect.getKey()), (Object[])new Object[0]) + " " + I18n.m_118938_((String)"tetra.stats.level_suffix", (Object[])new Object[0])));
            data.effects.efficiencyMap.forEach((itemEffect, efficiency) -> result.add(this.getValueDouble(efficiency.floatValue(), 0.0) + I18n.m_118938_((String)("tetra.stats." + itemEffect.getKey()), (Object[])new Object[0]) + " " + I18n.m_118938_((String)"tetra.stats.strength_suffix", (Object[])new Object[0])));
        }
        if (data.tools != null) {
            data.tools.getLevelMap().forEach((tool, level) -> result.add(this.getValueInteger((int)level, 0) + I18n.m_118938_((String)("tetra.tool." + tool.name()), (Object[])new Object[0]) + " " + I18n.m_118938_((String)"tetra.stats.tier_suffix", (Object[])new Object[0])));
            data.tools.efficiencyMap.forEach((tool, efficiency) -> result.add(this.getValueDouble(efficiency.floatValue(), 0.0) + I18n.m_118938_((String)("tetra.tool." + tool.name()), (Object[])new Object[0]) + " " + I18n.m_118938_((String)"tetra.stats.efficiency_suffix", (Object[])new Object[0])));
        }
        if (data.magicCapacity != 0) {
            result.add(this.getValueDouble(data.integrity, 0.0) + I18n.m_118938_((String)"tetra.stats.magicCapacity", (Object[])new Object[0]));
        }
        for (int i = 0; i < result.size(); ++i) {
            if (i == result.size() - 1) {
                result.set(i, ChatFormatting.GRAY + "  \u2514 " + (String)result.get(i));
                continue;
            }
            result.set(i, ChatFormatting.GRAY + "  \u251c " + (String)result.get(i));
        }
        return result;
    }

    public String getValueInteger(int value, int flippingPoint) {
        if (value > flippingPoint) {
            return ChatFormatting.GREEN + String.format("%+d ", value) + ChatFormatting.RESET;
        }
        return ChatFormatting.RED + String.format("%+d ", value) + ChatFormatting.RESET;
    }

    public String getValueMultiplier(double value) {
        if (value > 1.0) {
            return ChatFormatting.GREEN + String.format("%.02fx ", value) + ChatFormatting.RESET;
        }
        return ChatFormatting.RED + String.format("%.02fx ", value) + ChatFormatting.RESET;
    }

    public String getValueDouble(double value, double flippingPoint) {
        if (value > flippingPoint) {
            return ChatFormatting.GREEN + String.format("%+.02f ", value) + ChatFormatting.RESET;
        }
        return ChatFormatting.RED + String.format("%+.02f ", value) + ChatFormatting.RESET;
    }

    public List<Component> getTooltipLines() {
        if (this.hasFocus()) {
            return this.tooltip;
        }
        return super.getTooltipLines();
    }
}

