/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiTexture;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.Tooltips;
import se.mickelus.tetra.aspect.ItemAspect;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.data.AspectData;

@ParametersAreNonnullByDefault
public class AspectIconGui
extends GuiElement {
    protected List<Component> tooltip;
    protected int detailOffset;
    protected List<Component> detailTooltip;
    protected List<ItemAspect> aspects;

    public AspectIconGui(int x, int y) {
        super(x, y, 10, 10);
        GuiTexture indicator = new GuiTexture(0, 0, this.width, this.height, 208, 32, GuiTextures.workbench);
        this.addChild((GuiElement)indicator);
    }

    public void update(ItemStack itemStack, ItemModule module) {
        AspectData aspects = module.getAspects(itemStack);
        this.tooltip = new ArrayList<Component>();
        this.detailOffset = 0;
        if (aspects != null && !aspects.getValues().isEmpty()) {
            this.tooltip.add((Component)Component.m_237115_((String)"tetra.modular.aspects.header").m_130940_(ChatFormatting.GRAY));
            aspects.getLevelMap().forEach((aspect, level) -> {
                MutableComponent levelString = Component.m_237115_((String)("enchantment.level." + level));
                this.tooltip.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)ItemAspect.getAspectLabel(aspect.getKey())).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)levelString));
            });
            this.tooltip.add((Component)Component.m_237113_((String)" "));
            this.tooltip.add(Tooltips.expand);
            this.aspects = new ArrayList(aspects.getValues());
            this.updateDetailTooltip();
        } else {
            this.tooltip.add((Component)Component.m_237115_((String)"tetra.modular.aspects.empty").m_130940_(ChatFormatting.GRAY));
            this.detailTooltip = null;
            this.aspects = new ArrayList<ItemAspect>();
        }
    }

    public void update(ItemStack itemStack, String slot) {
        CastOptional.cast((Object)itemStack.m_41720_(), IModularItem.class).map(item -> item.getModuleFromSlot(itemStack, slot)).ifPresent(module -> this.update(itemStack, (ItemModule)module));
    }

    public void updateDetailTooltip() {
        ItemAspect aspect = this.aspects.get(this.detailOffset);
        this.detailTooltip = new ArrayList<Component>();
        this.detailTooltip.add((Component)Component.m_237110_((String)"tetra.modular.aspects.detail_header", (Object[])new Object[]{this.detailOffset + 1, this.aspects.size()}).m_130940_(ChatFormatting.GRAY));
        this.detailTooltip.add((Component)Component.m_237113_((String)" "));
        this.detailTooltip.add((Component)ItemAspect.getAspectLabel(aspect.getKey()).m_130940_(ChatFormatting.YELLOW));
        this.detailTooltip.add((Component)ItemAspect.getAspectDescription(aspect.getKey()));
        this.detailTooltip.add((Component)Component.m_237113_((String)" "));
        this.detailTooltip.add(Tooltips.expanded);
        if (this.aspects.size() > 1) {
            this.detailTooltip.add((Component)Component.m_237115_((String)"tetra.modular.aspects.scroll_tooltip"));
        }
    }

    public List<Component> getTooltipLines() {
        if (this.hasFocus()) {
            if (Screen.m_96638_() && !this.aspects.isEmpty()) {
                return this.detailTooltip;
            }
            return this.tooltip;
        }
        return super.getTooltipLines();
    }

    public boolean onMouseScroll(double mouseX, double mouseY, double distance) {
        if (this.hasFocus()) {
            if (this.aspects.size() > 1) {
                this.detailOffset = Mth.m_14045_((int)(this.detailOffset + (int)Math.signum(-distance)), (int)0, (int)(this.aspects.size() - 1));
                this.updateDetailTooltip();
            }
            return true;
        }
        return false;
    }
}

