/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect.vexing;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.potion.UnstablePowerMobEffect;

@ParametersAreNonnullByDefault
public class VexingEffect {
    private static final Cache<UUID, Integer> currentVexCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(40L, TimeUnit.SECONDS).build();

    private static boolean isInTimeout(LivingEntity entity) {
        return Optional.of(entity.m_20148_()).map(arg_0 -> currentVexCache.getIfPresent(arg_0)).map(arg_0 -> ((Level)entity.m_9236_()).m_6815_(arg_0)).map(Entity::m_6084_).orElse(false);
    }

    private static void setCurrentVex(LivingEntity entity, Vex vex) {
        currentVexCache.put((Object)entity.m_20148_(), (Object)vex.m_19879_());
    }

    public static void perform(LivingEntity entity, ItemStack itemStack, double multiplier) {
        if (!entity.m_9236_().f_46443_) {
            Level level = entity.m_9236_();
            double effectProbability = EffectHelper.getEffectEfficiency(itemStack, ItemEffect.vexing);
            if (effectProbability > 0.0 && !VexingEffect.isInTimeout(entity) && entity.m_217043_().m_188500_() < effectProbability / 100.0 * multiplier) {
                int effectLevel = EffectHelper.getEffectLevel(itemStack, ItemEffect.vexing);
                BlockPos origin = entity.m_20183_();
                Vex vex = (Vex)EntityType.f_20491_.m_20615_(level);
                if (vex != null) {
                    vex.m_21008_(InteractionHand.MAIN_HAND, itemStack.m_41777_());
                    vex.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
                    vex.m_33987_(160);
                    vex.m_7678_(entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), entity.m_146908_(), 0.0f);
                    vex.m_34042_(true);
                    vex.m_6518_((ServerLevelAccessor)level, level.m_6436_(origin), MobSpawnType.MOB_SUMMONED, null, null);
                    vex.m_34033_(origin);
                    vex.m_7292_(new MobEffectInstance((MobEffect)UnstablePowerMobEffect.instance, 1199, effectLevel - 1, false, false));
                    ((ServerLevelAccessor)level).m_47205_((Entity)vex);
                    vex.m_8032_();
                    VexingEffect.setCurrentVex(entity, vex);
                }
            }
        }
    }
}

