/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.data.deserializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SoundEventDeserializer
implements JsonDeserializer<SoundEvent> {
    private static final Logger logger = LogManager.getLogger();

    public SoundEvent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        try {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(json.getAsString()));
        }
        catch (JsonParseException e) {
            logger.debug("Failed to parse sound event: {}", (Object)json, (Object)e);
            return null;
        }
    }
}

