/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.data;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.gson.Gson;
import java.util.stream.Stream;
import se.mickelus.mutil.data.DataDistributor;
import se.mickelus.mutil.data.DataStore;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.modifier.ModifierEffect;

public class ModifierEffectStore
extends DataStore<ModifierEffect> {
    public static Multimap<ItemEffect, ModifierEffect> hitDamageModifiers = ArrayListMultimap.create();
    public static Multimap<ItemEffect, ModifierEffect> breakSpeedModifiers = ArrayListMultimap.create();

    public ModifierEffectStore(Gson gson, String namespace, String directory, DataDistributor synchronizer) {
        super(gson, namespace, directory, ModifierEffect.class, synchronizer);
    }

    protected void processData() {
        this.dataMap.forEach((key, value) -> {
            value.key = key.m_135815_();
        });
        hitDamageModifiers = (Multimap)this.dataMap.values().stream().filter(data -> data.type.getKey().equals("tetra:hit_damage")).collect(Multimaps.flatteningToMultimap(modifier -> modifier.effect, Stream::of, ArrayListMultimap::create));
        breakSpeedModifiers = (Multimap)this.dataMap.values().stream().filter(data -> data.type.getKey().equals("tetra:break_speed")).collect(Multimaps.flatteningToMultimap(entry -> entry.effect, Stream::of, ArrayListMultimap::create));
    }
}

