/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;
import org.joml.Vector3f;
import se.mickelus.mutil.network.AbstractPacket;
import se.mickelus.tetra.ServerScheduler;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.TetraSounds;
import se.mickelus.tetra.client.particle.Particles;
import se.mickelus.tetra.client.particle.SpawnParticlesPacket;
import se.mickelus.tetra.effect.potion.UnstablePowerMobEffect;

@ParametersAreNonnullByDefault
public class ArcaneFireBlock
extends BaseFireBlock {
    public static final String identifier = "arcane_fire";
    public static final IntegerProperty ageProperty = BlockStateProperties.f_61410_;
    public static RegistryObject<ArcaneFireBlock> instance;

    public ArcaneFireBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60910_().m_60966_().m_280170_().m_60953_(state -> 8).m_60918_(SoundType.f_56745_).m_60955_().m_222994_().m_278166_(PushReaction.DESTROY), 0.0f);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ageProperty, (Comparable)Integer.valueOf(0)));
    }

    public static void spawnDelayed(ServerLevel level, BlockPos blockPos, Vec3 origin) {
        TetraMod.packetHandler.sendToAllPlayersNear((AbstractPacket)new SpawnParticlesPacket(origin.m_7096_(), origin.m_7098_(), origin.m_7094_(), (float)blockPos.m_123341_() + 0.5f, blockPos.m_123342_(), (float)blockPos.m_123343_() + 0.5f, false, 8, (ParticleOptions)Particles.splinteredPower.get()), blockPos, 64.0, level.m_46472_());
        ServerScheduler.schedule(40, () -> ArcaneFireBlock.spawnDust((Level)level, blockPos, 0.5f));
        ServerScheduler.schedule(38, () -> level.m_5594_(null, blockPos, TetraSounds.arcane_fire_1, SoundSource.PLAYERS, 0.05f, 1.0f));
        ServerScheduler.schedule(55, () -> ArcaneFireBlock.spawnDust((Level)level, blockPos, 0.2f));
        ServerScheduler.schedule(52, () -> level.m_5594_(null, blockPos, TetraSounds.arcane_fire_2, SoundSource.PLAYERS, 0.075f, 1.0f));
        level.m_5594_(null, blockPos, TetraSounds.destabilize, SoundSource.PLAYERS, 0.4f, 1.2f);
        ServerScheduler.schedule(80, () -> level.m_5594_(null, blockPos, SoundEvents.f_11705_, SoundSource.PLAYERS, 0.2f, 1.0f));
        ServerScheduler.schedule(80, () -> level.m_7731_(blockPos, ((ArcaneFireBlock)((Object)((Object)instance.get()))).m_49966_(), 3));
    }

    private static void spawnDust(Level level, BlockPos pos, float spread) {
        RandomSource random = level.m_213780_();
        ((ServerLevel)level).m_8767_((ParticleOptions)new DustColorTransitionOptions(new Vector3f(1.0f, 0.5f, 0.725f), new Vector3f(1.0f, 0.738f, 0.578f), 0.8f + random.m_188501_() * 0.4f), (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), 8, (double)spread, (double)spread, (double)spread, 0.1);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ageProperty});
    }

    protected boolean m_7599_(BlockState state) {
        return true;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos below = pos.m_7495_();
        return level.m_8055_(below).m_60783_((BlockGetter)level, below, Direction.UP);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (!this.m_7898_(state, (LevelReader)level, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        FluidState fluidState = level.m_6425_(currentPos);
        if (!fluidState.m_76178_() && fluidState.m_76152_() == Fluids.f_76193_) {
            level.m_5594_(null, currentPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.0f);
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    private void drainOrExtinguish(BlockState state, LevelAccessor level, BlockPos pos) {
        int age = (Integer)state.m_61143_((Property)ageProperty);
        if (age < 15) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)ageProperty, (Comparable)Integer.valueOf(age + 1)), 3);
        } else {
            level.m_7471_(pos, false);
            level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.2f, 1.8f);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        int factor = 15 - (Integer)state.m_61143_((Property)ageProperty) + 1;
        UnstablePowerMobEffect.addOrUpdate((LivingEntity)player, factor * 20, 0);
        if (!level.m_5776_()) {
            Particles.addSputteringPower((ServerLevel)level, (float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.2f, (float)pos.m_123343_() + 0.5f, (Entity)player, Math.max(4, factor));
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        entity.m_6469_(level.m_269111_().m_269387_(), 0.5f);
        if (!level.m_5776_() && level.m_46467_() % 10L == 0L && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            UnstablePowerMobEffect.addOrUpdate(livingEntity, 30, level.f_46441_.m_188501_() < 0.04f ? 1 : 0);
            this.drainOrExtinguish(state, (LevelAccessor)level, pos);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.m_186460_(pos, (Block)this, ArcaneFireBlock.getFireTickDelay(random));
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            level.m_7471_(pos, false);
            return;
        }
        this.drainOrExtinguish(state, (LevelAccessor)level, pos);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        level.m_186460_(pos, (Block)this, ArcaneFireBlock.getFireTickDelay(level.f_46441_));
    }

    private static int getFireTickDelay(RandomSource random) {
        return 40 + random.m_188503_(40);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        double x = pos.m_123341_();
        double y = pos.m_123342_();
        double z = pos.m_123343_();
        if (random.m_188503_(24) == 0) {
            level.m_7785_(x + 0.5, y + 0.5, z + 0.5, SoundEvents.f_11936_, SoundSource.BLOCKS, 0.6f + random.m_188501_() * 0.4f, random.m_188501_() * 0.7f + 0.5f, false);
        }
        for (int i = 0; i < 4; ++i) {
            level.m_7106_((ParticleOptions)new DustColorTransitionOptions(new Vector3f(1.0f, 0.5f, 0.725f), new Vector3f(1.0f, 0.738f, 0.578f), 0.8f + random.m_188501_() * 0.4f), x + random.m_188500_(), y + random.m_188500_() * 0.5 + 0.5, z + random.m_188500_(), 0.0, 0.0, 0.0);
        }
        level.m_7106_((ParticleOptions)Particles.arcaneFire.get(), x + 0.5 + random.m_188583_() * (double)0.7f, y, z + 0.5 + random.m_188583_() * (double)0.7f, x + 0.5, y + random.m_188500_(), z + 0.5);
    }
}

