/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.item.zipline;

import com.alrex.parcool.api.SoundEvents;
import com.alrex.parcool.common.block.zipline.ZiplineHookBlock;
import com.alrex.parcool.common.block.zipline.ZiplineHookTileEntity;
import com.alrex.parcool.common.block.zipline.ZiplineInfo;
import com.alrex.parcool.common.zipline.ZiplineType;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ZiplineRopeItem
extends Item {
    public static final int DEFAULT_COLOR = 5013478;
    private static final DecimalFormat PERCENT_FORMATTER;

    public ZiplineRopeItem(Item.Properties p_i48487_1_) {
        super(p_i48487_1_);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level world, @Nonnull List<Component> lines, TooltipFlag flag) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("Tile_X") && tag.m_128441_("Tile_Y") && tag.m_128441_("Tile_Z")) {
            lines.add((Component)Component.m_237110_((String)"parcool.gui.text.zipline.bind_pos", (Object[])new Object[]{tag.m_128451_("Tile_X") + ", " + tag.m_128451_("Tile_Y") + ", " + tag.m_128451_("Tile_Z")}).m_130940_(ChatFormatting.YELLOW));
        } else {
            lines.add((Component)Component.m_237115_((String)"parcool.gui.text.zipline.not_bound").m_130940_(ChatFormatting.DARK_GRAY));
        }
        lines.add((Component)Component.m_237119_());
        lines.add((Component)Component.m_237110_((String)"parcool.gui.text.zipline.tension", (Object[])new Object[]{ZiplineRopeItem.getZiplineType(stack).getTranslationName()}).m_130940_(ChatFormatting.GRAY));
        if (ZiplineRopeItem.hasCustomColor(stack)) {
            lines.add((Component)Component.m_237115_((String)"parcool.gui.text.zipline.colored").m_130940_(ChatFormatting.BLUE));
        }
    }

    @Nonnull
    public InteractionResult m_6225_(@Nonnull UseOnContext context) {
        ItemStack stack = context.m_43722_();
        CompoundTag tag = stack.m_41783_();
        if (tag != null && ZiplineRopeItem.hasBlockPosition(stack)) {
            if (context.m_43725_().m_8055_(context.m_8083_()).m_60734_() instanceof ZiplineHookBlock) {
                Player player;
                BlockPos start = ZiplineRopeItem.getBlockPosition(stack);
                if (start == null) {
                    return InteractionResult.FAIL;
                }
                BlockPos end = context.m_8083_();
                if (start.equals((Object)end)) {
                    return InteractionResult.PASS;
                }
                double horizontalDistSqr = Mth.m_144944_((int)(start.m_123341_() - end.m_123341_())) + Mth.m_144944_((int)(start.m_123343_() - end.m_123343_()));
                if (horizontalDistSqr > 13225.0) {
                    Player player2;
                    if (context.m_43725_().m_5776_() && (player2 = context.m_43723_()) != null) {
                        player2.m_5661_((Component)Component.m_237115_((String)"parcool.message.zipline.too_far"), true);
                    }
                    return InteractionResult.FAIL;
                }
                double verticalDist = Math.abs(end.m_123342_() - start.m_123342_());
                if (verticalDist * Mth.m_14193_((double)horizontalDistSqr) > 1.0 || verticalDist > 58.65) {
                    Player player3;
                    if (context.m_43725_().m_5776_() && (player3 = context.m_43723_()) != null) {
                        player3.m_5661_((Component)Component.m_237115_((String)"parcool.message.zipline.too_steep"), true);
                    }
                    return InteractionResult.FAIL;
                }
                BlockEntity startEntity = context.m_43725_().m_7702_(start);
                BlockEntity endEntity = context.m_43725_().m_7702_(end);
                if (startEntity instanceof ZiplineHookTileEntity) {
                    ZiplineHookTileEntity startZipEntity = (ZiplineHookTileEntity)startEntity;
                    if (endEntity instanceof ZiplineHookTileEntity) {
                        Player player4;
                        ZiplineHookTileEntity endZipEntity = (ZiplineHookTileEntity)endEntity;
                        if (ZiplineRopeItem.getZiplineType(stack).getZipline(startZipEntity.getActualZiplinePoint(null), endZipEntity.getActualZiplinePoint(null)).conflictsWithSomething(context.m_43725_())) {
                            Player player5 = context.m_43723_();
                            if (player5 != null) {
                                player5.m_5661_((Component)Component.m_237115_((String)"parcool.message.zipline.obstacle_detected"), true);
                            }
                            return InteractionResult.FAIL;
                        }
                        if (!context.m_43725_().m_5776_()) {
                            if (!startZipEntity.connectTo(endZipEntity, new ZiplineInfo(ZiplineRopeItem.getZiplineType(stack), ZiplineRopeItem.getColor(stack)))) {
                                Player player6 = context.m_43723_();
                                if (player6 != null) {
                                    player6.m_5661_((Component)Component.m_237115_((String)"parcool.message.zipline.already_exist"), true);
                                }
                                return InteractionResult.FAIL;
                            }
                            stack.m_41774_(1);
                        }
                        if ((player4 = context.m_43723_()) != null) {
                            player4.m_5496_((SoundEvent)SoundEvents.ZIPLINE_SET.get(), 1.0f, 1.0f);
                        }
                        ZiplineRopeItem.removeBlockPosition(stack);
                        return InteractionResult.m_19078_((boolean)context.m_43725_().m_5776_());
                    }
                }
                ZiplineRopeItem.removeBlockPosition(stack);
                if (context.m_43725_().m_5776_() && (player = context.m_43723_()) != null) {
                    player.m_5661_((Component)Component.m_237115_((String)"parcool.message.zipline.point_not_found"), true);
                }
                return InteractionResult.FAIL;
            }
            if (context.m_7078_()) {
                Player player;
                if (context.m_43725_().m_5776_() && (player = context.m_43723_()) != null) {
                    player.m_5661_((Component)Component.m_237115_((String)"parcool.message.zipline.reset_point"), true);
                }
                ZiplineRopeItem.removeBlockPosition(stack);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        BlockPos pos = context.m_8083_();
        if (context.m_43725_().m_8055_(pos).m_60734_() instanceof ZiplineHookBlock) {
            Player player;
            ZiplineRopeItem.setBlockPosition(stack, pos);
            if (context.m_43725_().m_5776_() && (player = context.m_43723_()) != null) {
                player.m_5661_((Component)Component.m_237110_((String)"parcool.message.zipline.set_point", (Object[])new Object[]{pos.m_123344_()}), true);
            }
            return InteractionResult.SUCCESS;
        }
        if (context.m_7078_()) {
            Player player;
            ZiplineRopeItem.changeZiplineType(stack);
            if (context.m_43725_().m_5776_() && (player = context.m_43723_()) != null) {
                player.m_5661_((Component)Component.m_237110_((String)"parcool.message.zipline.change_tension", (Object[])new Object[]{ZiplineRopeItem.getZiplineType(stack).getTranslationName()}), true);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static void setBlockPosition(ItemStack stack, BlockPos pos) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            tag = new CompoundTag();
            stack.m_41751_(tag);
        }
        tag.m_128405_("Tile_X", pos.m_123341_());
        tag.m_128405_("Tile_Y", pos.m_123342_());
        tag.m_128405_("Tile_Z", pos.m_123343_());
    }

    public static void removeBlockPosition(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        tag.m_128473_("Tile_X");
        tag.m_128473_("Tile_Y");
        tag.m_128473_("Tile_Z");
    }

    public static boolean hasBlockPosition(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_("Tile_X") && tag.m_128441_("Tile_Y") && tag.m_128441_("Tile_Z");
    }

    @Nullable
    public static BlockPos getBlockPosition(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return null;
        }
        return new BlockPos(tag.m_128451_("Tile_X"), tag.m_128451_("Tile_Y"), tag.m_128451_("Tile_Z"));
    }

    public static void setColor(ItemStack stack, int color) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            tag = new CompoundTag();
            stack.m_41751_(tag);
        }
        if (color != 5013478) {
            tag.m_128405_("color", color);
        } else {
            tag.m_128473_("color");
        }
    }

    public static int getColor(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("color")) {
            return 5013478;
        }
        return tag.m_128451_("color");
    }

    public static boolean hasCustomColor(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return false;
        }
        return tag.m_128441_("color");
    }

    public static ZiplineType getZiplineType(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("zipline_type")) {
            return ZiplineType.STANDARD;
        }
        return ZiplineType.values()[tag.m_128445_("zipline_type") % ZiplineType.values().length];
    }

    public static void changeZiplineType(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            tag = new CompoundTag();
            stack.m_41751_(tag);
        }
        tag.m_128344_("zipline_type", (byte)((ZiplineRopeItem.getZiplineType(stack).ordinal() + 1) % ZiplineType.values().length));
    }

    public static void setZiplineType(ItemStack stack, ZiplineType type) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            tag = new CompoundTag();
            stack.m_41751_(tag);
        }
        tag.m_128344_("zipline_type", (byte)type.ordinal());
    }

    static {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setGroupingSeparator(' ');
        PERCENT_FORMATTER = new DecimalFormat("##0.0", decimalFormatSymbols);
    }

    public static class RopeColor
    implements ItemColor {
        public int m_92671_(@Nonnull ItemStack itemStack, int i) {
            return i > 0 ? -1 : ZiplineRopeItem.getColor(itemStack);
        }
    }
}

