/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.flow;

import java.util.Iterator;
import java.util.List;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.math.Maths;
import team.creative.creativecore.common.util.type.list.MarkList;

public class GuiStackY
extends GuiFlow {
    @Override
    public int minWidth(List<? extends GuiChildControl> controls, int spacing, int availableWidth) {
        int width = 0;
        for (GuiChildControl guiChildControl : controls) {
            width = Math.max(width, guiChildControl.getMinWidth(availableWidth));
        }
        return width;
    }

    @Override
    public int preferredWidth(List<? extends GuiChildControl> controls, int spacing, int availableWidth) {
        int width = 0;
        for (GuiChildControl guiChildControl : controls) {
            width = Math.max(width, guiChildControl.getPreferredWidth(availableWidth));
        }
        return width;
    }

    @Override
    public int minHeight(List<? extends GuiChildControl> controls, int spacing, int width, int availableHeight) {
        int height = -spacing;
        boolean has = false;
        for (GuiChildControl guiChildControl : controls) {
            int min = guiChildControl.getMinHeight(availableHeight);
            if (min != -1) {
                height += min;
                has = true;
            }
            height += spacing;
        }
        return has ? height : -1;
    }

    @Override
    public int preferredHeight(List<? extends GuiChildControl> controls, int spacing, int width, int availableHeight) {
        int height = -spacing;
        for (GuiChildControl guiChildControl : controls) {
            height += guiChildControl.getPreferredHeight(availableHeight) + spacing;
        }
        return height;
    }

    @Override
    public void flowX(List<? extends GuiChildControl> controls, int spacing, Align align, int width, int preferred, boolean endless) {
        int maxWidth = width;
        if (endless && preferred > width) {
            maxWidth = preferred;
        }
        boolean expandable = GuiStackY.areChildrenExpandableX(controls);
        if (align == Align.LEFT && !expandable) {
            for (GuiChildControl guiChildControl : controls) {
                guiChildControl.setX(0);
                guiChildControl.setWidth(Math.min(maxWidth, guiChildControl.getPreferredWidth(width)), width);
                guiChildControl.flowX();
            }
        } else if (align == Align.STRETCH || expandable) {
            for (GuiChildControl guiChildControl : controls) {
                if (guiChildControl.isExpandableX() || align == Align.STRETCH) {
                    guiChildControl.setWidth(maxWidth, width);
                } else {
                    guiChildControl.setWidth(Math.min(maxWidth, guiChildControl.getPreferredWidth(width)), width);
                }
                guiChildControl.setX(0);
                guiChildControl.flowX();
            }
        } else if (align == Align.RIGHT) {
            for (GuiChildControl guiChildControl : controls) {
                guiChildControl.setWidth(Math.min(maxWidth, guiChildControl.getPreferredWidth(width)), width);
                guiChildControl.setX(maxWidth - guiChildControl.getWidth());
                guiChildControl.flowX();
            }
        } else {
            for (GuiChildControl guiChildControl : controls) {
                guiChildControl.setWidth(Math.min(maxWidth, guiChildControl.getPreferredWidth(width)), width);
                guiChildControl.setX((int)Math.ceil((double)maxWidth / 2.0 - (double)guiChildControl.getWidth() / 2.0));
                guiChildControl.flowX();
            }
        }
    }

    @Override
    public void flowY(List<? extends GuiChildControl> controls, int spacing, VAlign valign, int width, int height, int preferred, boolean endless) {
        block30: {
            int available;
            block31: {
                block29: {
                    available = height - spacing * (controls.size() - 1);
                    MarkList<? extends GuiChildControl> list = new MarkList<GuiChildControl>(controls);
                    if (height >= preferred) {
                        if (valign == VAlign.STRETCH && !GuiStackY.areChildrenExpandableY(controls)) {
                            for (GuiChildControl guiChildControl : list) {
                                int n = guiChildControl.getMinHeight(height);
                                if (n != -1) {
                                    available -= n;
                                    guiChildControl.setHeight(n, height);
                                    continue;
                                }
                                guiChildControl.setHeight(0, height);
                            }
                            while (available > 0 && !list.isEmpty()) {
                                int average = (int)Math.ceil((double)available / (double)list.remaing());
                                Iterator iterator = list.iterator();
                                while (iterator.hasNext()) {
                                    GuiChildControl guiChildControl = (GuiChildControl)iterator.next();
                                    int toAdd = Maths.min(average, available, guiChildControl.getPreferredHeight(height) - guiChildControl.getHeight());
                                    if (toAdd <= 0) {
                                        iterator.mark();
                                        continue;
                                    }
                                    available -= guiChildControl.addHeight(toAdd, height);
                                    if (!guiChildControl.isMaxHeight(height)) continue;
                                    iterator.mark();
                                }
                            }
                            list.clear();
                            while (available > 0 && !list.isEmpty()) {
                                int average = (int)Math.ceil((double)available / (double)list.remaing());
                                Iterator iterator = list.iterator();
                                while (iterator.hasNext()) {
                                    GuiChildControl guiChildControl = (GuiChildControl)iterator.next();
                                    available -= guiChildControl.addHeight(Math.min(average, available), height);
                                    if (!guiChildControl.isMaxHeight(height)) continue;
                                    iterator.mark();
                                }
                            }
                        } else {
                            Iterator itr = list.iterator();
                            while (itr.hasNext()) {
                                GuiChildControl guiChildControl = (GuiChildControl)itr.next();
                                guiChildControl.setHeight(guiChildControl.getPreferredHeight(height), height);
                                if (!guiChildControl.isExpandableY()) {
                                    itr.mark();
                                }
                                available -= guiChildControl.getHeight();
                            }
                            if (valign == VAlign.STRETCH || GuiStackY.areChildrenExpandableY(controls)) {
                                while (available > 0 && !list.isEmpty()) {
                                    int average = (int)Math.ceil((double)available / (double)list.remaing());
                                    Iterator iterator = list.iterator();
                                    while (iterator.hasNext()) {
                                        GuiChildControl guiChildControl = (GuiChildControl)iterator.next();
                                        available -= guiChildControl.addHeight(Math.min(average, available), height);
                                        if (!guiChildControl.isMaxHeight(height)) continue;
                                        iterator.mark();
                                    }
                                }
                            }
                        }
                    } else if (endless) {
                        for (GuiChildControl guiChildControl : controls) {
                            guiChildControl.setHeight(guiChildControl.getPreferredHeight(height), height);
                        }
                        valign = VAlign.TOP;
                    } else {
                        for (GuiChildControl guiChildControl : list) {
                            int n = guiChildControl.getMinHeight(height);
                            if (n != -1) {
                                available -= n;
                                guiChildControl.setHeight(n, height);
                                continue;
                            }
                            guiChildControl.setHeight(0, height);
                        }
                        while (available > 0 && !list.isEmpty()) {
                            int average = (int)Math.ceil((double)available / (double)list.remaing());
                            Iterator iterator = list.iterator();
                            while (iterator.hasNext()) {
                                GuiChildControl guiChildControl = (GuiChildControl)iterator.next();
                                int prefer = guiChildControl.getPreferredHeight(height);
                                available -= guiChildControl.addHeight(Math.min(average, Math.min(prefer - guiChildControl.getHeight(), available)), height);
                                if (!guiChildControl.isMaxHeight(height) && prefer > guiChildControl.getHeight()) continue;
                                iterator.mark();
                            }
                        }
                        list.clear();
                        while (available > 0 && !list.isEmpty()) {
                            int average = (int)Math.ceil((double)available / (double)list.remaing());
                            Iterator iterator = list.iterator();
                            while (iterator.hasNext()) {
                                GuiChildControl guiChildControl = (GuiChildControl)iterator.next();
                                available -= guiChildControl.addHeight(Math.min(average, available), height);
                                if (!guiChildControl.isMaxHeight(height)) continue;
                                iterator.mark();
                            }
                        }
                    }
                    for (GuiChildControl guiChildControl : controls) {
                        guiChildControl.flowY();
                    }
                    if (available > 0 && valign != VAlign.TOP) break block29;
                    int y = 0;
                    for (GuiChildControl guiChildControl : controls) {
                        guiChildControl.setY(y);
                        y += guiChildControl.getHeight() + spacing;
                    }
                    break block30;
                }
                if (valign != VAlign.BOTTOM) break block31;
                int y = height;
                for (GuiChildControl guiChildControl : controls) {
                    guiChildControl.setY(y -= guiChildControl.getHeight());
                    y -= spacing;
                }
                break block30;
            }
            if (valign != VAlign.CENTER && valign != VAlign.STRETCH) break block30;
            int y = available / 2;
            for (GuiChildControl guiChildControl : controls) {
                guiChildControl.setY(y);
                y += guiChildControl.getHeight() + spacing;
            }
        }
    }
}

