/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import mod.chiselsandbits.utils.LinkedHashSetQueue;
import org.apache.commons.lang3.Validate;

public class SimpleMaxSizedCache<K, V> {
    private final Map<K, V> cache = new HashMap();
    private final Queue<K> keyQueue = new LinkedHashSetQueue<K>();
    private final LongSupplier maxSizeSupplier;

    public SimpleMaxSizedCache(long maxSize) {
        Validate.exclusiveBetween((long)0L, (long)10000000000L, (long)maxSize);
        this.maxSizeSupplier = () -> maxSize;
    }

    public SimpleMaxSizedCache(LongSupplier longSupplier) {
        this.maxSizeSupplier = longSupplier;
    }

    public SimpleMaxSizedCache(IntSupplier intSupplier) {
        this.maxSizeSupplier = intSupplier::getAsInt;
    }

    private void evictFromCacheIfNeeded() {
        while ((long)this.cache.size() >= this.maxSizeSupplier.getAsLong()) {
            this.cache.remove(this.keyQueue.poll());
        }
    }

    public synchronized V get(K key) {
        return this.cache.get(key);
    }

    public synchronized V get(K key, Supplier<V> valueSupplier) {
        if (!this.cache.containsKey(key)) {
            this.evictFromCacheIfNeeded();
        }
        if (!this.cache.containsKey(key)) {
            V value = valueSupplier.get();
            this.put(key, value);
            return value;
        }
        return this.cache.get(key);
    }

    public synchronized Optional<V> getIfPresent(K key) {
        return Optional.ofNullable(this.get(key));
    }

    public synchronized void put(K key, V value) {
        if (!this.cache.containsKey(key)) {
            this.evictFromCacheIfNeeded();
        }
        if (!this.keyQueue.contains(key)) {
            this.keyQueue.add(key);
        }
        this.cache.put(key, value);
    }

    public synchronized void clear() {
        this.cache.clear();
        this.keyQueue.clear();
    }
}

