/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling.modes.sphere;

import com.communi.suggestu.scena.core.registries.AbstractCustomRegistryEntry;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.ChiselingOperation;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.world.IInWorldStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.world.IWorldAreaAccessor;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.util.BlockPosForEach;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.IBatchMutation;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.api.util.VectorUtils;
import mod.chiselsandbits.registrars.ModChiselModeGroups;
import mod.chiselsandbits.registrars.ModMetadataKeys;
import mod.chiselsandbits.utils.BitInventoryUtils;
import mod.chiselsandbits.utils.BlockPosUtils;
import mod.chiselsandbits.utils.ItemStackUtils;
import mod.chiselsandbits.voxelshape.MultiStateBlockEntityDiscreteVoxelShape;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CubeVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class SphereChiselMode
extends AbstractCustomRegistryEntry
implements IChiselMode {
    private final int diameter;
    private final MutableComponent displayName;
    private final MutableComponent multiLineDisplayName;
    private final ResourceLocation iconName;
    private final Map<StateEntrySize, VoxelShape> baseSphereShapes = Maps.newHashMap();

    SphereChiselMode(int diameter, MutableComponent displayName, MutableComponent multiLineDisplayName, ResourceLocation iconName) {
        this.diameter = diameter;
        this.displayName = displayName;
        this.multiLineDisplayName = multiLineDisplayName;
        this.iconName = iconName;
        for (StateEntrySize size : StateEntrySize.values()) {
            this.baseSphereShapes.put(size, SphereChiselMode.buildSphereShape(size, diameter));
        }
    }

    private static VoxelShape buildSphereShape(StateEntrySize size, int diameter) {
        int blocks = StateEntrySize.ONE_SIXTEENTH.getBitsPerBlockSide() / size.getBitsPerBlockSide();
        int fullBitAccuracy = blocks * StateEntrySize.ONE_SIXTEENTH.getBitsPerBlockSide();
        int centerBitCoord = fullBitAccuracy / 2;
        int radius = diameter / 2;
        BlockPos centerPos = new BlockPos(centerBitCoord, centerBitCoord, centerBitCoord);
        BlockPos cornerPos = centerPos.m_121996_(new Vec3i(radius, 0, 0));
        double range = cornerPos.m_123331_((Vec3i)centerPos);
        BitSet bits = new BitSet(fullBitAccuracy * fullBitAccuracy * fullBitAccuracy);
        BlockPosForEach.forEachInRange(fullBitAccuracy, blockPos -> {
            int index = BlockPosUtils.getCollisionIndex(blockPos, fullBitAccuracy, fullBitAccuracy);
            double posRange = blockPos.m_123331_((Vec3i)centerPos);
            bits.set(index, posRange <= range);
        });
        return new CubeVoxelShape((DiscreteVoxelShape)new MultiStateBlockEntityDiscreteVoxelShape(bits, fullBitAccuracy));
    }

    @Override
    public ClickProcessingState onLeftClickBy(Player playerEntity, IChiselingContext context) {
        Either<ClickProcessingState, Vec3> rayTraceHandle = this.processRayTraceIntoContext(playerEntity, context, face -> Vec3.m_82528_((Vec3i)face.m_122424_().m_122436_()), facing -> facing.m_82542_(-1.0, -1.0, -1.0));
        if (rayTraceHandle.right().isPresent()) {
            context.setMetadata(ModMetadataKeys.ANCHOR.get(), (Vec3)rayTraceHandle.right().get());
        }
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        context.setComplete();
        if (rayTraceHandle.left().isPresent()) {
            return (ClickProcessingState)rayTraceHandle.left().get();
        }
        if (rayTraceHandle.right().isEmpty()) {
            throw new IllegalArgumentException("Missing both a click processing result as well as a center vector for sphere processing");
        }
        return context.getMutator().map(mutator -> {
            try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                HashMap resultingBitCount = Maps.newHashMap();
                Predicate<IStateEntryInfo> filter = context.getStateFilter().map(factory -> (Predicate)factory.apply(mutator)).orElse(s -> true);
                int totalModifiedStates = mutator.inWorldMutableStream().filter(filter).mapToInt(state -> {
                    IBlockInformation currentState = state.getBlockInformation();
                    return context.tryDamageItemAndDoOrSetBrokenError(() -> {
                        resultingBitCount.putIfAbsent(currentState, 0);
                        resultingBitCount.computeIfPresent(currentState, (s, currentCount) -> currentCount + 1);
                        state.clear();
                    });
                }).sum();
                if (totalModifiedStates == 0) {
                    context.setError(LocalStrings.ChiselAttemptFailedNoValidStateFound.getText());
                }
                resultingBitCount.forEach((blockState, count) -> BitInventoryUtils.insertIntoOrSpawn(playerEntity, blockState, count));
            }
            return ClickProcessingState.ALLOW;
        }).orElse(ClickProcessingState.DEFAULT);
    }

    @Override
    public void onStoppedLeftClicking(Player playerEntity, IChiselingContext context) {
    }

    @Override
    public ClickProcessingState onRightClickBy(Player playerEntity, IChiselingContext context) {
        Either<ClickProcessingState, Vec3> rayTraceHandle = this.processRayTraceIntoContext(playerEntity, context, face -> Vec3.m_82528_((Vec3i)face.m_122436_()), Function.identity());
        if (rayTraceHandle.right().isPresent()) {
            context.setMetadata(ModMetadataKeys.ANCHOR.get(), (Vec3)rayTraceHandle.right().get());
        }
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        if (rayTraceHandle.left().isPresent()) {
            return (ClickProcessingState)rayTraceHandle.left().get();
        }
        if (rayTraceHandle.right().isEmpty()) {
            throw new IllegalArgumentException("Missing both a click processing result as well as a center vector for sphere processing");
        }
        return context.getMutator().map(mutator -> {
            BlockPos heightPos;
            IBlockInformation heldBlockState = ItemStackUtils.getHeldBitBlockInformationFromPlayer(playerEntity);
            if (heldBlockState.isAir()) {
                return ClickProcessingState.DEFAULT;
            }
            Predicate<IStateEntryInfo> filter = context.getStateFilter().map(factory -> (Predicate)factory.apply(mutator)).orElse(s -> true);
            int missingBitCount = (int)mutator.stream().filter(state -> state.getBlockInformation().isAir() && filter.test((IStateEntryInfo)state)).count();
            IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(playerEntity);
            context.setComplete();
            if (playerBitInventory.canExtract(heldBlockState, missingBitCount) || playerEntity.m_7500_()) {
                if (!playerEntity.m_7500_()) {
                    playerBitInventory.extract(heldBlockState, missingBitCount);
                }
                try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                    mutator.inWorldMutableStream().filter(state -> state.getBlockInformation().isAir() && filter.test((IStateEntryInfo)state)).forEach(state -> state.overrideState(heldBlockState));
                }
            } else {
                context.setError(LocalStrings.ChiselAttemptFailedNotEnoughBits.getText(heldBlockState.getBlockState().m_60734_().m_49954_()));
            }
            if (missingBitCount == 0 && (heightPos = mutator.getInWorldEndBlockPoint()).m_123342_() >= context.getWorld().m_151558_()) {
                MutableComponent component = Component.m_237110_((String)"build.tooHigh", (Object[])new Object[]{context.getWorld().m_151558_() - 1}).m_130940_(ChatFormatting.RED);
                playerEntity.m_213846_((Component)component);
            }
            return ClickProcessingState.ALLOW;
        }).orElse(ClickProcessingState.DEFAULT);
    }

    @Override
    public void onStoppedRightClicking(Player playerEntity, IChiselingContext context) {
    }

    @Override
    public Optional<IAreaAccessor> getCurrentAccessor(IChiselingContext context) {
        return context.getMutator().map(mutator -> mutator);
    }

    @Override
    public boolean isStillValid(Player playerEntity, IChiselingContext context, ChiselingOperation modeOfOperation) {
        Optional<Vec3> rayTraceHandle = modeOfOperation.isChiseling() ? this.processRayTraceIntoCenter(playerEntity, face -> Vec3.m_82528_((Vec3i)face.m_122424_().m_122436_()), facing -> facing.m_82542_(-1.0, -1.0, -1.0)) : this.processRayTraceIntoCenter(playerEntity, face -> Vec3.m_82528_((Vec3i)face.m_122436_()), Function.identity());
        Optional<Vec3> contextAnchor = context.getMetadata(ModMetadataKeys.ANCHOR.get());
        return rayTraceHandle.map(d -> contextAnchor.filter(arg_0 -> ((Vec3)d).equals(arg_0)).isPresent()).orElseGet(contextAnchor::isPresent);
    }

    @Override
    public VoxelShape getShape(IChiselingContext context) {
        Optional<Vec3> centerCandidate = context.getMetadata(ModMetadataKeys.ANCHOR.get());
        if (centerCandidate.isEmpty()) {
            return Shapes.m_83040_();
        }
        Optional<IWorldAreaMutator> accessor = context.getMutator();
        if (accessor.isEmpty()) {
            return Shapes.m_83040_();
        }
        VoxelShape genericShape = this.baseSphereShapes.get((Object)StateEntrySize.current());
        Vec3 areaStart = accessor.get().getInWorldStartPoint();
        BlockPos areaStartPos = VectorUtils.toBlockPos(areaStart);
        Vec3 center = centerCandidate.get();
        Vec3 offset = center.m_82492_((double)areaStartPos.m_123341_(), (double)areaStartPos.m_123342_(), (double)areaStartPos.m_123343_());
        int blocks = StateEntrySize.ONE_SIXTEENTH.getBitsPerBlockSide() / StateEntrySize.current().getBitsPerBlockSide();
        int fullBitAccuracy = blocks * StateEntrySize.ONE_SIXTEENTH.getBitsPerBlockSide();
        int centerBitCoord = fullBitAccuracy / 2;
        float centerBitCoordExact = (float)centerBitCoord / 16.0f;
        Vec3 shapeOffset = offset.m_82492_((double)centerBitCoordExact, (double)centerBitCoordExact, (double)centerBitCoordExact);
        return genericShape.m_83216_(shapeOffset.m_7096_(), shapeOffset.m_7098_(), shapeOffset.m_7094_());
    }

    private Optional<Vec3> processRayTraceIntoCenter(Player playerEntity, Function<Direction, Vec3> placementFacingAdapter, Function<Vec3, Vec3> fullFacingVectorAdapter) {
        HitResult rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.m_6662_() != HitResult.Type.BLOCK || !(rayTraceResult instanceof BlockHitResult)) {
            return Optional.empty();
        }
        BlockHitResult blockRayTraceResult = (BlockHitResult)rayTraceResult;
        Vec3 hitVector = blockRayTraceResult.m_82450_().m_82549_(placementFacingAdapter.apply(blockRayTraceResult.m_82434_()).m_82542_((double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit()));
        Vec3 centeredHitVector = Vec3.m_82528_((Vec3i)VectorUtils.toBlockPos(hitVector.m_82542_((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()))).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
        Vec3 center = centeredHitVector.m_82549_(new Vec3((double)this.diameter / 2.0 / (double)StateEntrySize.current().getBitsPerBlockSide(), (double)this.diameter / 2.0 / (double)StateEntrySize.current().getBitsPerBlockSide(), (double)this.diameter / 2.0 / (double)StateEntrySize.current().getBitsPerBlockSide()).m_82559_(fullFacingVectorAdapter.apply(Vec3.m_82528_((Vec3i)blockRayTraceResult.m_82434_().m_122436_()))));
        return Optional.of(center);
    }

    private Either<ClickProcessingState, Vec3> processRayTraceIntoContext(Player playerEntity, IChiselingContext context, Function<Direction, Vec3> placementFacingAdapter, Function<Vec3, Vec3> fullFacingVectorAdapter) {
        HitResult rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.m_6662_() != HitResult.Type.BLOCK || !(rayTraceResult instanceof BlockHitResult)) {
            context.setError(LocalStrings.ChiselAttemptFailedNoBlock.getText());
            return Either.left((Object)ClickProcessingState.DEFAULT);
        }
        BlockHitResult blockRayTraceResult = (BlockHitResult)rayTraceResult;
        Vec3 hitVector = blockRayTraceResult.m_82450_().m_82549_(placementFacingAdapter.apply(blockRayTraceResult.m_82434_()).m_82542_((double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit()));
        Vec3 centeredHitVector = Vec3.m_82528_((Vec3i)VectorUtils.toBlockPos(hitVector.m_82542_((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()))).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
        Vec3 center = centeredHitVector.m_82549_(new Vec3((double)this.diameter / 2.0 / (double)StateEntrySize.current().getBitsPerBlockSide(), (double)this.diameter / 2.0 / (double)StateEntrySize.current().getBitsPerBlockSide(), (double)this.diameter / 2.0 / (double)StateEntrySize.current().getBitsPerBlockSide()).m_82559_(fullFacingVectorAdapter.apply(Vec3.m_82528_((Vec3i)blockRayTraceResult.m_82434_().m_122436_()))));
        context.setStateFilter(areaAccessor -> {
            if (areaAccessor instanceof IWorldAreaAccessor) {
                return new SphereAreaFilter(context.getModeOfOperandus(), ((IWorldAreaAccessor)areaAccessor).getInWorldStartPoint(), center);
            }
            return new SphereAreaFilter(context.getModeOfOperandus(), Vec3.f_82478_, center);
        });
        BlockPosStreamProvider.getForRange(this.diameter).forEach(bitPos -> {
            Vec3 target = center.m_82549_(Vec3.m_82528_((Vec3i)bitPos.m_121996_(new Vec3i(this.diameter / 2, this.diameter / 2, this.diameter / 2))).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()));
            context.include(target);
        });
        return Either.right((Object)center);
    }

    @Override
    @NotNull
    public ResourceLocation getIcon() {
        return this.iconName;
    }

    @Override
    public Component getDisplayName() {
        return this.displayName;
    }

    @Override
    public Component getMultiLineDisplayName() {
        return this.multiLineDisplayName;
    }

    @Override
    @NotNull
    public Optional<IToolModeGroup> getGroup() {
        return Optional.of(ModChiselModeGroups.SPHERE);
    }

    private final class SphereAreaFilter
    implements Predicate<IStateEntryInfo> {
        private final ChiselingOperation operation;
        private final Vec3 startPoint;
        private final Vec3 center;

        private SphereAreaFilter(ChiselingOperation operation, Vec3 startPoint, Vec3 center) {
            this.operation = operation;
            this.startPoint = startPoint;
            this.center = center;
        }

        @Override
        public boolean test(IStateEntryInfo stateEntryInfo) {
            if (!(stateEntryInfo instanceof IInWorldStateEntryInfo)) {
                return false;
            }
            IInWorldStateEntryInfo inWorldStateEntryInfo = (IInWorldStateEntryInfo)stateEntryInfo;
            return inWorldStateEntryInfo.getInWorldStartPoint().m_82554_(this.center) <= (double)((float)SphereChiselMode.this.diameter / 2.0f / (float)StateEntrySize.current().getBitsPerBlockSide()) && (!stateEntryInfo.getBlockInformation().isAir() || this.operation.processesAir());
        }

        public int hashCode() {
            int result = this.startPoint != null ? this.startPoint.hashCode() : 0;
            result = 31 * result + (this.center != null ? this.center.hashCode() : 0);
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SphereAreaFilter)) {
                return false;
            }
            SphereAreaFilter that = (SphereAreaFilter)o;
            if (!Objects.equals(this.startPoint, that.startPoint)) {
                return false;
            }
            return Objects.equals(this.center, that.center);
        }
    }
}

