/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.ai;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.incontrol.ErrorHandler;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;

public class AISystem {
    private static final Map<String, Cmd> ACTIONS = new HashMap<String, Cmd>();
    private static final Map<String, Goals> GOALS;

    public static Consumer<Mob> parse(String json) {
        Consumer<Mob> action = null;
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(json);
        if (!element.isJsonObject()) {
            ErrorHandler.error("Invalid ai action! Expected a JSON object.");
            return e -> {};
        }
        JsonObject object = element.getAsJsonObject();
        block6: for (String attr : object.keySet()) {
            Cmd cmd = ACTIONS.get(attr);
            if (cmd == null) {
                ErrorHandler.error("Invalid action '" + attr + "' for ai rule!");
                return e -> {};
            }
            JsonElement value = object.get(attr);
            switch (cmd) {
                case CLEARGOALS: {
                    action = AISystem.combineConsumer(action, (T e) -> e.f_21345_.m_262460_(g -> true));
                    break;
                }
                case CLEARTARGETS: {
                    action = AISystem.combineConsumer(action, (T e) -> e.f_21346_.m_262460_(g -> true));
                    break;
                }
                case GOALS: {
                    BiConsumer<GoalSelector, Mob> consumer;
                    if (value.isJsonArray()) {
                        for (JsonElement el : value.getAsJsonArray()) {
                            consumer = AISystem.parseGoal(el);
                            action = AISystem.combineConsumer(action, (T e) -> consumer.accept(e.f_21345_, (Mob)e));
                        }
                        continue block6;
                    }
                    ErrorHandler.error("Invalid value for 'goals' action! Expected a JSON array.");
                    return AISystem.combineConsumer(action, (T e) -> {});
                }
                case TARGETS: {
                    BiConsumer<GoalSelector, Mob> consumer;
                    if (value.isJsonArray()) {
                        for (JsonElement el : value.getAsJsonArray()) {
                            consumer = AISystem.parseGoal(el);
                            action = AISystem.combineConsumer(action, (T e) -> consumer.accept(e.f_21346_, (Mob)e));
                        }
                        continue block6;
                    }
                    ErrorHandler.error("Invalid value for 'targets' action! Expected a JSON array.");
                    return AISystem.combineConsumer(action, (T e) -> {});
                }
            }
        }
        return AISystem.combineConsumer(action, (T e) -> {});
    }

    private static int getDefaultInt(JsonObject object, String key, int defaultValue) {
        if (object.has(key)) {
            JsonElement element = object.get(key);
            return element.getAsInt();
        }
        return defaultValue;
    }

    private static float getDefaultFloat(JsonObject object, String key, float defaultValue) {
        if (object.has(key)) {
            JsonElement element = object.get(key);
            return element.getAsFloat();
        }
        return defaultValue;
    }

    private static double getDefaultDouble(JsonObject object, String key, double defaultValue) {
        if (object.has(key)) {
            JsonElement element = object.get(key);
            return element.getAsDouble();
        }
        return defaultValue;
    }

    private static boolean getDefaultBoolean(JsonObject object, String key, boolean defaultValue) {
        if (object.has(key)) {
            JsonElement element = object.get(key);
            return element.getAsBoolean();
        }
        return defaultValue;
    }

    private static Class getEntityClass(JsonObject object, String key, Class defaultClass) {
        if (!object.has(key)) {
            return defaultClass;
        }
        JsonElement element = object.get(key);
        if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
            ErrorHandler.error("Invalid entity class in '" + key + "' action! Expected a string.");
            return null;
        }
        String entityName = element.getAsString();
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(entityName));
        if (entityType == null) {
            ErrorHandler.error("Unknown entity '" + entityName + "'!");
            return null;
        }
        return entityType.m_142225_();
    }

    private static BiConsumer<GoalSelector, Mob> parseGoal(JsonElement el) {
        if (!el.isJsonObject()) {
            ErrorHandler.error("Invalid goal in 'goals' action! Expected a JSON object.");
            return (s, e) -> {};
        }
        JsonObject goal = el.getAsJsonObject();
        if (!goal.has("goal") || !goal.has("priority")) {
            ErrorHandler.error("Invalid goal in 'goals' action! Expected 'goal' and 'priority' attributes.");
            return (s, e) -> {};
        }
        BiConsumer goalSelector = null;
        String goalName = goal.get("goal").getAsString();
        int priority = goal.get("priority").getAsInt();
        Goals g = GOALS.get(goalName.toLowerCase());
        if (g == null) {
            ErrorHandler.error("Invalid goal '" + goalName + "' in 'goals' action!");
            return (s, e) -> {};
        }
        switch (g) {
            case LOOK_AT_PLAYER: {
                float lookdistance = AISystem.getDefaultFloat(goal, "lookdistance", 8.0f);
                float probability = AISystem.getDefaultFloat(goal, "probability", 0.02f);
                boolean onlyHorizontal = AISystem.getDefaultBoolean(goal, "onlyhorizontal", false);
                return AISystem.combineConsumer(goalSelector, (T s, S e) -> s.m_25352_(priority, (Goal)new LookAtPlayerGoal(e, Player.class, lookdistance, probability, onlyHorizontal)));
            }
            case HURT_BY_TARGET: {
                return AISystem.combineConsumer(goalSelector, (T s, S e) -> {
                    if (e instanceof PathfinderMob) {
                        PathfinderMob pf = (PathfinderMob)e;
                        s.m_25352_(priority, (Goal)new HurtByTargetGoal(pf, new Class[0]));
                    }
                });
            }
            case NEAREST_ATTACKABLE_TARGET: {
                boolean mustsee = AISystem.getDefaultBoolean(goal, "mustsee", true);
                boolean mustreach = AISystem.getDefaultBoolean(goal, "mustreach", false);
                int randomInterval = AISystem.getDefaultInt(goal, "randominterval", 10);
                return AISystem.combineConsumer(goalSelector, (T s, S e) -> s.m_25352_(priority, (Goal)new NearestAttackableTargetGoal(e, Player.class, randomInterval, mustsee, mustreach, null)));
            }
            case MELEE_ATTACK: {
                float speed = AISystem.getDefaultFloat(goal, "speed", 1.0f);
                boolean followingTargetEvenNotSeen = AISystem.getDefaultBoolean(goal, "followingtarget", false);
                return AISystem.combineConsumer(goalSelector, (T s, S e) -> {
                    if (e instanceof PathfinderMob) {
                        PathfinderMob pf = (PathfinderMob)e;
                        s.m_25352_(priority, (Goal)new MeleeAttackGoal(pf, (double)speed, followingTargetEvenNotSeen));
                    }
                });
            }
            case RANDOM_LOOK_AROUND: {
                return AISystem.combineConsumer(goalSelector, (T s, S e) -> s.m_25352_(priority, (Goal)new RandomLookAroundGoal(e)));
            }
            case AVOID_ENTITY_GOAL: {
                Class entityClass = AISystem.getEntityClass(goal, "entity", Player.class);
                if (entityClass == null) {
                    return (s, e) -> {};
                }
                float maxDistance = AISystem.getDefaultFloat(goal, "maxdistance", 10.0f);
                double walkSpeedModifier = AISystem.getDefaultDouble(goal, "walkspeedmodifier", 1.0);
                double sprintSpeedModifier = AISystem.getDefaultDouble(goal, "sprintspeedmodifier", 1.2f);
                boolean onlyWhenTargeting = AISystem.getDefaultBoolean(goal, "onlyWhenTargeting", false);
                return AISystem.combineConsumer(goalSelector, (T s, S e) -> {
                    if (e instanceof PathfinderMob) {
                        PathfinderMob pf = (PathfinderMob)e;
                        s.m_25352_(priority, (Goal)new AvoidEntityGoal(pf, entityClass, maxDistance, walkSpeedModifier, sprintSpeedModifier));
                    }
                });
            }
        }
        ErrorHandler.error("Unknown goal '" + String.valueOf((Object)g) + "' in 'goals' action!");
        return (s, e) -> {};
    }

    private static <T> Consumer<T> combineConsumer(@Nullable Consumer<T> first, @Nonnull Consumer<T> second) {
        if (first == null) {
            return second;
        }
        return first.andThen(second);
    }

    private static <T, S> BiConsumer<T, S> combineConsumer(@Nullable BiConsumer<T, S> first, @Nonnull BiConsumer<T, S> second) {
        if (first == null) {
            return second;
        }
        return first.andThen(second);
    }

    static {
        for (Cmd cmd : Cmd.values()) {
            ACTIONS.put(cmd.name().toLowerCase(), cmd);
        }
        GOALS = new HashMap<String, Goals>();
        for (Enum enum_ : Goals.values()) {
            GOALS.put(enum_.name().toLowerCase(), (Goals)enum_);
        }
    }

    static enum Cmd {
        CLEARGOALS,
        CLEARTARGETS,
        GOALS,
        TARGETS;

    }

    static enum Goals {
        LOOK_AT_PLAYER,
        HURT_BY_TARGET,
        NEAREST_ATTACKABLE_TARGET,
        MELEE_ATTACK,
        RANDOM_LOOK_AROUND,
        AVOID_ENTITY_GOAL;

    }
}

