/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.jujutsucraft.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.mcreator.jujutsucraft.item.renderer.MahitoHand1ItemRenderer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.network.GeckoLibNetwork;
import software.bernie.geckolib.util.ClientUtils;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MahitoHand1Item
extends Item
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE_ANIM = RawAnimation.begin().then("idle", Animation.LoopType.LOOP);
    private static final RawAnimation SPRINT_ANIM = RawAnimation.begin().then("sprint", Animation.LoopType.LOOP);
    private static final RawAnimation POPUP_ANIM = RawAnimation.begin().thenPlay("swing");
    private static final Random RANDOM = new Random();
    private boolean isSwinging = false;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    public String animationprocedure = "empty";
    String prevAnim = "empty";

    public MahitoHand1Item() {
        super(new Item.Properties().m_41503_(1200).m_41497_(Rarity.COMMON));
        GeckoLibNetwork.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            private final BlockEntityWithoutLevelRenderer renderer = new MahitoHand1ItemRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    private PlayState idlePredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("idle"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "popup_controller", 1, state -> PlayState.STOP).triggerableAnim("swing", POPUP_ANIM).triggerableAnim("idle", IDLE_ANIM).triggerableAnim("sprint", SPRINT_ANIM).setSoundKeyframeHandler(state -> {
            Player player = ClientUtils.getClientPlayer();
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        Level level;
        if (entity.m_21205_() == stack && (level = entity.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            String animName = "swing";
            this.triggerAnim((Entity)entity, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "popup_controller", animName);
            this.isSwinging = true;
            int swingDuration = 10;
            this.scheduler.schedule(() -> {
                this.isSwinging = false;
                return false;
            }, (long)swingDuration * 50L, TimeUnit.MILLISECONDS);
        }
        return super.onEntitySwing(stack, entity);
    }

    public void m_6883_(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        Level level;
        super.m_6883_(itemstack, world, entity, slot, selected);
        String animName = "";
        if (!this.isSwinging && entity instanceof LivingEntity && (level = entity.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            animName = selected ? (entity.m_20142_() ? "sprint" : "idle") : "idle";
            this.triggerAnim(entity, GeoItem.getOrAssignId((ItemStack)itemstack, (ServerLevel)serverLevel), "popup_controller", animName);
        }
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(super.m_7167_(equipmentSlot));
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Item modifier", 2.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Item modifier", -2.4, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.m_7167_(equipmentSlot);
    }
}

