/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.implementation.state;

import com.blamejared.jeitweaker.api.IngredientType;
import com.blamejared.jeitweaker.zen.category.JeiCategory;
import com.blamejared.jeitweaker.zen.component.JeiIngredient;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public final class ActionsState {
    private final Multimap<IngredientType<?, ?>, Object> hiddenIngredients = LinkedHashMultimap.create();
    private final Set<ResourceLocation> hiddenRecipeCategories = new LinkedHashSet<ResourceLocation>();
    private final Set<Pair<ResourceLocation, ResourceLocation>> hiddenRecipes = new LinkedHashSet<Pair<ResourceLocation, ResourceLocation>>();
    private final Map<IngredientType<?, ?>, Map<Object, Component[]>> descriptions = new HashMap();
    private final Multimap<IngredientType<?, ?>, Object> customIngredients = LinkedHashMultimap.create();
    private final List<JeiCategory> customCategories = new ArrayList<JeiCategory>();

    ActionsState() {
    }

    public <T, U> void hide(JeiIngredient<T, U> ingredient) {
        this.hiddenIngredients.put(ingredient.getType(), ingredient.getWrapped());
    }

    public void hideRecipeCategory(ResourceLocation category) {
        this.hiddenRecipeCategories.add(category);
    }

    public void hideRecipe(ResourceLocation category, ResourceLocation recipe) {
        this.hiddenRecipes.add((Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)category, (Object)recipe));
    }

    public <T, U> void addDescription(JeiIngredient<T, U> ingredient, Component ... description) {
        this.descriptions.computeIfAbsent(ingredient.getType(), it -> new HashMap()).put(ingredient.getWrapped(), description);
    }

    public <T, U> void addCustomIngredient(JeiIngredient<T, U> ingredient) {
        this.customIngredients.put(ingredient.getType(), ingredient.getWrapped());
    }

    public void addCustomCategory(JeiCategory category) {
        this.customCategories.add(category);
    }

    public <T, U> void show(JeiIngredient<T, U> ingredient) {
        this.hiddenIngredients.remove(ingredient.getType(), ingredient.getWrapped());
    }

    public void showRecipeCategory(ResourceLocation category) {
        this.hiddenRecipeCategories.remove(category);
    }

    public void showRecipe(ResourceLocation category, ResourceLocation recipe) {
        this.hiddenRecipes.remove(Pair.of((Object)category, (Object)recipe));
    }

    public <T, U> void removeDescription(JeiIngredient<T, U> ingredient) {
        this.descriptions.computeIfAbsent(ingredient.getType(), it -> new HashMap()).remove(ingredient.getWrapped());
    }

    public <T, U> void removeCustomIngredient(JeiIngredient<T, U> ingredient) {
        this.customIngredients.remove(ingredient.getType(), ingredient.getWrapped());
    }

    public void removeCustomCategory(JeiCategory category) {
        this.customCategories.remove(category);
    }

    public <T, U> Collection<T> getHiddenIngredientsForType(IngredientType<T, U> type) {
        return Collections.unmodifiableCollection(this.uncheckCollection(this.hiddenIngredients.get(type)));
    }

    public Set<ResourceLocation> getCategoriesToHide() {
        return Collections.unmodifiableSet(this.hiddenRecipeCategories);
    }

    public Stream<JeiCategory> getCustomCategories() {
        return this.customCategories.stream();
    }

    public void onHiddenRecipes(BiConsumer<ResourceLocation, ResourceLocation> consumer) {
        this.hiddenRecipes.forEach(it -> consumer.accept((ResourceLocation)it.getFirst(), (ResourceLocation)it.getSecond()));
    }

    public <T, U> void onDescriptionsFor(IngredientType<T, U> type, BiConsumer<T, Component[]> consumer) {
        this.descriptions.getOrDefault(type, Collections.emptyMap()).forEach((ingredient, description) -> consumer.accept((Object)ingredient, (Component[])description));
    }

    public <T, U> Collection<T> getCustomIngredientsForType(IngredientType<T, U> type) {
        return Collections.unmodifiableCollection(this.uncheckCollection(this.customIngredients.get(type)));
    }

    private <T> Collection<T> uncheckCollection(Collection<Object> collection) {
        return collection;
    }
}

