/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.bridge;

import com.blamejared.jeitweaker.api.CoordinateFixer;
import com.blamejared.jeitweaker.bridge.JeiCategoryPluginBridge;
import com.blamejared.jeitweaker.zen.category.CustomRecipeCategory;
import com.blamejared.jeitweaker.zen.recipe.RecipeGraphics;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.helpers.IGuiHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;

public final class CustomRecipeCategoryBridge
implements JeiCategoryPluginBridge {
    private final Collection<CustomRecipeCategory.SlotData> slots;
    private final Collection<CustomRecipeCategory.DrawableData> drawables;
    private final Collection<CustomRecipeCategory.TextData> tips;
    private final Collection<CustomRecipeCategory.TextData> text;
    private final boolean canBeShapeless;
    private final int inputSlots;

    public CustomRecipeCategoryBridge(Collection<CustomRecipeCategory.SlotData> slots, Collection<CustomRecipeCategory.DrawableData> drawables, Collection<CustomRecipeCategory.TextData> tips, Collection<CustomRecipeCategory.TextData> text, boolean canBeShapeless) {
        this.slots = slots;
        this.drawables = drawables;
        this.tips = tips;
        this.text = text;
        this.canBeShapeless = canBeShapeless;
        this.inputSlots = (int)slots.stream().filter(CustomRecipeCategory.SlotData::isInput).count();
    }

    @Override
    public <G> void initializeGui(IGuiIngredientGroup<G> group, CoordinateFixer coordinateFixer) {
        this.slots.forEach(slot -> {
            int x = coordinateFixer.fixX(slot.coordinates().x());
            int y = coordinateFixer.fixY(slot.coordinates().y());
            group.init(slot.index(), slot.isInput(), x, y);
        });
    }

    @Override
    public int getInputSlotsAmount() {
        return this.inputSlots;
    }

    @Override
    public int getOutputSlotsAmount() {
        return this.slots.size() - this.inputSlots;
    }

    @Override
    public boolean allowShapelessMarker() {
        return this.canBeShapeless;
    }

    @Override
    public boolean allowCustomTooltips() {
        return true;
    }

    @Override
    public void drawAdditionalComponent(PoseStack poseStack, double mouseX, double mouseY, IGuiHelper guiHelper, Consumer<RecipeGraphics> graphicsConsumer) {
        this.drawText(poseStack);
        this.drawDrawables(poseStack, guiHelper);
    }

    @Override
    public List<Component> getTooltips(double x, double y, IGuiHelper helper, Consumer<RecipeGraphics> graphicsConsumer) {
        return this.tips.stream().filter(it -> this.isInside((CustomRecipeCategory.TextData)it, x, y)).map(CustomRecipeCategory.TextData::text).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void drawText(PoseStack poseStack) {
        Font font = Minecraft.m_91087_().f_91062_;
        this.text.forEach(it -> font.m_92763_(poseStack, it.text().get(0), (float)it.topLeft().x(), (float)it.topLeft().y(), 0xFFFFFF));
    }

    private void drawDrawables(PoseStack poseStack, IGuiHelper guiHelper) {
        this.drawables.forEach(it -> it.drawable().getDrawable(guiHelper).draw(poseStack, it.coordinates().x(), it.coordinates().y()));
    }

    private boolean isInside(CustomRecipeCategory.TextData tipData, double x, double y) {
        return (double)tipData.topLeft().x() <= x && x <= (double)tipData.activeArea().x() && (double)tipData.topLeft().y() <= y && y <= (double)tipData.activeArea().y();
    }
}

