/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.wire;

import alternate.current.wire.WireNode;
import java.util.AbstractQueue;
import java.util.Iterator;

public class PowerQueue
extends AbstractQueue<WireNode> {
    private WireNode head;
    private WireNode tail;
    private WireNode[] tails;
    private int offset;
    private int size;

    public PowerQueue() {
        this.clear();
    }

    @Override
    public boolean offer(WireNode wire) {
        if (wire == null) {
            throw new NullPointerException();
        }
        int power = wire.nextPower();
        if (this.contains(wire)) {
            if (wire.power == power) {
                return false;
            }
            this.move(wire, power);
        } else {
            this.insert(wire, power);
        }
        return true;
    }

    @Override
    public WireNode poll() {
        if (this.head == null) {
            return null;
        }
        WireNode wire = this.head;
        WireNode next = wire.next;
        if (next == null) {
            this.clear();
        } else {
            if (wire.power != next.power) {
                this.tails[wire.power + this.offset] = null;
            }
            wire.next = null;
            next.prev = null;
            this.head = next;
            --this.size;
        }
        return wire;
    }

    @Override
    public WireNode peek() {
        return this.head;
    }

    @Override
    public void clear() {
        WireNode wire = this.head;
        while (wire != null) {
            WireNode w = wire;
            wire = wire.next;
            w.prev = null;
            w.next = null;
        }
        this.head = null;
        this.tail = null;
        this.tails = new WireNode[0];
        this.offset = 0;
        this.size = 0;
    }

    @Override
    public Iterator<WireNode> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.size;
    }

    public boolean contains(WireNode wire) {
        return wire == this.head || wire.prev != null;
    }

    private void move(WireNode wire, int power) {
        this.remove(wire);
        this.insert(wire, power);
    }

    private void remove(WireNode wire) {
        if (wire == this.tail || wire.power != wire.next.power) {
            this.tails[wire.power + this.offset] = wire == this.head || wire.power != wire.prev.power ? null : wire.prev;
        }
        if (wire == this.head) {
            this.head = wire.next;
        } else {
            wire.prev.next = wire.next;
        }
        if (wire == this.tail) {
            this.tail = wire.prev;
        } else {
            wire.next.prev = wire.prev;
        }
        wire.prev = null;
        wire.next = null;
        --this.size;
    }

    private void insert(WireNode wire, int power) {
        wire.power = power;
        this.index(wire);
        if (this.head == null) {
            this.head = this.tail = wire;
        } else if (wire.power > this.head.power) {
            this.linkHead(wire);
        } else if (wire.power <= this.tail.power) {
            this.linkTail(wire);
        } else {
            this.linkAfter(this.findPrev(wire), wire);
        }
        this.tails[power + this.offset] = wire;
        ++this.size;
    }

    private void index(WireNode wire) {
        int size = wire.power + this.offset + 1;
        int move = -wire.type.minPower - this.offset;
        if (size < this.tails.length) {
            size = this.tails.length;
        }
        if (move < 0) {
            move = 0;
        }
        if ((size += move) > this.tails.length) {
            this.resize(size, move);
        }
    }

    private void resize(int size, int move) {
        WireNode[] array = this.tails;
        this.tails = new WireNode[size];
        for (int i = 0; i < array.length; ++i) {
            this.tails[i + move] = array[i];
        }
        this.offset += move;
    }

    private void linkHead(WireNode wire) {
        wire.next = this.head;
        this.head.prev = wire;
        this.head = wire;
    }

    private void linkTail(WireNode wire) {
        this.tail.next = wire;
        wire.prev = this.tail;
        this.tail = wire;
    }

    private void linkAfter(WireNode prev, WireNode wire) {
        this.linkBetween(prev, wire, prev.next);
    }

    private void linkBetween(WireNode prev, WireNode wire, WireNode next) {
        prev.next = wire;
        wire.prev = prev;
        wire.next = next;
        next.prev = wire;
    }

    private WireNode findPrev(WireNode wire) {
        WireNode prev = null;
        for (int i = wire.power + this.offset; i < this.tails.length && (prev = this.tails[i]) == null; ++i) {
        }
        return prev;
    }
}

