/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.wire;

import alternate.current.interfaces.mixin.IBlock;
import alternate.current.wire.WireBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunkSection;

public class LevelAccess {
    private final ServerLevel level;

    LevelAccess(ServerLevel level) {
        this.level = level;
    }

    BlockState getBlockState(BlockPos pos) {
        int y = pos.m_123342_();
        if (y < this.level.m_141937_() || y >= this.level.m_151558_()) {
            return Blocks.f_50626_.m_49966_();
        }
        int x = pos.m_123341_();
        int z = pos.m_123343_();
        int index = this.level.m_151564_(y);
        ChunkAccess chunk = this.level.m_6522_(x >> 4, z >> 4, ChunkStatus.f_62326_, true);
        LevelChunkSection section = chunk.m_7103_()[index];
        if (section == null) {
            return Blocks.f_50016_.m_49966_();
        }
        return section.m_62982_(x & 0xF, y & 0xF, z & 0xF);
    }

    boolean setWireState(BlockPos pos, BlockState state, boolean updateNeighborShapes) {
        if (!(state.m_60734_() instanceof WireBlock)) {
            return false;
        }
        int y = pos.m_123342_();
        if (y < this.level.m_141937_() || y >= this.level.m_151558_()) {
            return false;
        }
        int x = pos.m_123341_();
        int z = pos.m_123343_();
        int index = this.level.m_151564_(y);
        ChunkAccess chunk = this.level.m_6522_(x >> 4, z >> 4, ChunkStatus.f_62326_, true);
        LevelChunkSection section = chunk.m_7103_()[index];
        if (section == null) {
            return false;
        }
        BlockState prevState = section.m_62986_(x & 0xF, y & 0xF, z & 0xF, state);
        if (state == prevState) {
            return false;
        }
        this.level.m_7726_().m_8450_(pos);
        chunk.m_8092_(true);
        if (updateNeighborShapes) {
            prevState.m_60758_((LevelAccessor)this.level, pos, 2);
            state.m_60701_((LevelAccessor)this.level, pos, 2);
            state.m_60758_((LevelAccessor)this.level, pos, 2);
        }
        return true;
    }

    boolean breakWire(BlockPos pos, BlockState state) {
        BlockEntity blockEntity = state.m_155947_() ? this.level.m_7702_(pos) : null;
        Block.m_49892_((BlockState)state, (LevelAccessor)this.level, (BlockPos)pos, (BlockEntity)blockEntity);
        return this.level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
    }

    void updateNeighborShape(BlockPos pos, BlockState state, Direction fromDir, BlockPos fromPos, BlockState fromState) {
        BlockState newState = state.m_60728_(fromDir, fromState, (LevelAccessor)this.level, pos, fromPos);
        Block.m_49902_((BlockState)state, (BlockState)newState, (LevelAccessor)this.level, (BlockPos)pos, (int)2);
    }

    void updateNeighborBlock(BlockPos pos, BlockPos fromPos, Block fromBlock) {
        this.getBlockState(pos).m_60690_((Level)this.level, pos, fromBlock, fromPos, false);
    }

    void updateNeighborBlock(BlockPos pos, BlockState state, BlockPos fromPos, Block fromBlock) {
        state.m_60690_((Level)this.level, pos, fromBlock, fromPos, false);
    }

    public boolean isConductor(BlockPos pos) {
        return this.getBlockState(pos).m_60796_((BlockGetter)this.level, pos);
    }

    public boolean isConductor(BlockPos pos, BlockState state) {
        return state.m_60796_((BlockGetter)this.level, pos);
    }

    public boolean isSignalSourceTo(BlockPos pos, BlockState state, Direction dir) {
        return ((IBlock)state.m_60734_()).isSignalSourceTo((Level)this.level, pos, state, dir);
    }

    public boolean isDirectSignalSourceTo(BlockPos pos, BlockState state, Direction dir) {
        return ((IBlock)state.m_60734_()).isDirectSignalSourceTo((Level)this.level, pos, state, dir);
    }

    public int getSignalFrom(BlockPos pos, BlockState state, Direction dir) {
        return state.m_60746_((BlockGetter)this.level, pos, dir);
    }

    public int getDirectSignalFrom(BlockPos pos, BlockState state, Direction dir) {
        return state.m_60775_((BlockGetter)this.level, pos, dir);
    }

    public boolean shouldBreak(BlockPos pos, BlockState state) {
        return !state.m_60710_((LevelReader)this.level, pos);
    }
}

