/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.cc.tileentity;

import com.lupicus.cc.block.ClaimBlock;
import com.lupicus.cc.manager.ClaimManager;
import com.lupicus.cc.tileentity.ModTileEntities;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ClaimTileEntity
extends BlockEntity {
    public UUID owner;
    private String accessList = "";
    private String modifyList = "";
    private boolean enabled = true;
    private boolean accessAll;
    private boolean modifyAll;
    private Set<String> accessSet = new HashSet<String>();
    private Set<String> modifySet = new HashSet<String>();

    public ClaimTileEntity(BlockPos pos, BlockState state) {
        super(ModTileEntities.CLAIM_BLOCK, pos, state);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128403_("Owner")) {
            this.owner = nbt.m_128342_("Owner");
        }
        this.setAccess(nbt.m_128461_("AccessList"));
        this.setModify(nbt.m_128461_("ModifyList"));
        this.enabled = (Boolean)this.m_58900_().m_61143_((Property)ClaimBlock.ENABLED);
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (this.owner != null) {
            compound.m_128362_("Owner", this.owner);
        }
        compound.m_128359_("AccessList", this.accessList);
        compound.m_128359_("ModifyList", this.modifyList);
    }

    public void onLoad() {
        super.onLoad();
        if (!this.f_58857_.f_46443_ && this.owner != null && this.enabled) {
            ClaimManager.check(this.f_58857_, this.f_58858_, this.owner);
        }
    }

    public String getAccess() {
        return this.accessList;
    }

    public String getModify() {
        return this.modifyList;
    }

    public void setAccess(String list) {
        this.accessList = list;
        this.accessAll = false;
        this.accessSet.clear();
        for (String n : list.split(",")) {
            if (n.equals("*")) {
                this.accessAll = true;
                continue;
            }
            this.accessSet.add(n);
        }
    }

    public void setModify(String list) {
        this.modifyList = list;
        this.modifyAll = false;
        this.modifySet.clear();
        for (String n : list.split(",")) {
            if (n.equals("*")) {
                this.modifyAll = true;
                continue;
            }
            this.modifySet.add(n);
        }
    }

    public boolean grantAccess(Player player) {
        if (this.accessAll) {
            return true;
        }
        String name = player.m_7755_().getString();
        return this.accessSet.contains(name) || this.grantModify(name);
    }

    public boolean grantModify(Player player) {
        if (this.modifyAll) {
            return true;
        }
        return this.modifySet.contains(player.m_7755_().getString());
    }

    public boolean grantModify(String name) {
        if (this.modifyAll) {
            return true;
        }
        return this.modifySet.contains(name);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (this.f_58857_ == null) {
            return;
        }
        this.m_142466_(pkt.m_131708_());
    }
}

