/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.cc.manager;

import com.lupicus.cc.config.MyConfig;
import com.mojang.authlib.GameProfile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClaimManager {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final HashMap<GlobalPos, ClaimInfo> mapInfo = new HashMap();
    public static final HashMap<UUID, Integer> mapCount = new HashMap();
    public static final int VERSION = 100;
    private static File claimFile;
    private static MinecraftServer server;
    private static List<ClaimInfo> delayList;
    public static final ClaimInfo EMPTY;

    public static boolean add(Level world, BlockPos pos, Player player) {
        return ClaimManager.add(world, pos, player.m_142081_());
    }

    public static boolean add(Level world, BlockPos pos, UUID owner) {
        GlobalPos key = GlobalPos.m_122643_((ResourceKey)world.m_46472_(), (BlockPos)new ChunkPos(pos).m_45615_());
        ClaimInfo info = mapInfo.get(key);
        if (info != null) {
            return false;
        }
        info = new ClaimInfo(owner, GlobalPos.m_122643_((ResourceKey)world.m_46472_(), (BlockPos)pos));
        mapInfo.put(key, info);
        ClaimManager.save();
        int count = mapCount.getOrDefault(info.owner, 0);
        mapCount.put(info.owner, count + 1);
        return true;
    }

    public static void remove(Level world, BlockPos pos) {
        ClaimManager.remove((ResourceKey<Level>)world.m_46472_(), pos);
    }

    public static void remove(ResourceKey<Level> dim, BlockPos pos) {
        GlobalPos key = GlobalPos.m_122643_(dim, (BlockPos)new ChunkPos(pos).m_45615_());
        ClaimInfo old = mapInfo.remove(key);
        if (old != null) {
            ClaimManager.save();
            int count = mapCount.getOrDefault(old.owner, 0) - 1;
            if (count < 0) {
                count = 0;
            }
            mapCount.put(old.owner, count);
        }
    }

    public static boolean remove(ResourceKey<Level> dim, BlockPos pos, UUID owner) {
        GlobalPos key = GlobalPos.m_122643_(dim, (BlockPos)new ChunkPos(pos).m_45615_());
        ClaimInfo info = mapInfo.get(key);
        if (info != null && info.owner.equals(owner)) {
            mapInfo.remove(key);
            ClaimManager.save();
            int count = mapCount.getOrDefault(info.owner, 0) - 1;
            if (count < 0) {
                count = 0;
            }
            mapCount.put(info.owner, count);
            return true;
        }
        return false;
    }

    public static boolean replace(Level world, BlockPos pos) {
        GlobalPos key = GlobalPos.m_122643_((ResourceKey)world.m_46472_(), (BlockPos)new ChunkPos(pos).m_45615_());
        ClaimInfo info = mapInfo.get(key);
        if (info == null) {
            return false;
        }
        info.pos = GlobalPos.m_122643_((ResourceKey)world.m_46472_(), (BlockPos)pos);
        mapInfo.put(key, info);
        ClaimManager.save();
        return true;
    }

    public static ClaimInfo get(Level world, BlockPos pos) {
        GlobalPos key = GlobalPos.m_122643_((ResourceKey)world.m_46472_(), (BlockPos)new ChunkPos(pos).m_45615_());
        return mapInfo.getOrDefault(key, EMPTY);
    }

    public static ClaimInfo get(Level world, ChunkPos pos) {
        GlobalPos key = GlobalPos.m_122643_((ResourceKey)world.m_46472_(), (BlockPos)pos.m_45615_());
        return mapInfo.getOrDefault(key, EMPTY);
    }

    public static void check(Level world, BlockPos pos, UUID owner) {
        GlobalPos bpos = GlobalPos.m_122643_((ResourceKey)world.m_46472_(), (BlockPos)pos);
        if (claimFile == null) {
            delayList.add(new ClaimInfo(owner, bpos));
            return;
        }
        ClaimManager.check(bpos, owner);
    }

    private static void check(GlobalPos bpos, UUID owner) {
        GlobalPos key = GlobalPos.m_122643_((ResourceKey)bpos.m_122640_(), (BlockPos)new ChunkPos(bpos.m_122646_()).m_45615_());
        ClaimInfo info = mapInfo.get(key);
        if (info == null) {
            info = new ClaimInfo(owner, bpos);
            mapInfo.put(key, info);
            ClaimManager.save();
            int count = mapCount.getOrDefault(info.owner, 0) + 1;
            mapCount.put(info.owner, count);
            if (count > MyConfig.claimLimit) {
                ClaimManager.warnLimit(info, count);
            }
        } else {
            boolean update = false;
            if (!info.owner.equals(owner)) {
                int count = mapCount.getOrDefault(info.owner, 0) - 1;
                if (count < 0) {
                    count = 0;
                }
                mapCount.put(info.owner, count);
                info.owner = owner;
                count = mapCount.getOrDefault(info.owner, 0) + 1;
                mapCount.put(info.owner, count);
                if (count > MyConfig.claimLimit) {
                    ClaimManager.warnLimit(info, count);
                }
                update = true;
            }
            if (!info.pos.equals((Object)bpos)) {
                info.pos = bpos;
                update = true;
            }
            if (update) {
                ClaimManager.save();
            }
        }
    }

    public static List<GlobalPos> getList(UUID uuid) {
        ArrayList<GlobalPos> ret = new ArrayList<GlobalPos>();
        for (ClaimInfo e : mapInfo.values()) {
            if (!e.owner.equals(uuid)) continue;
            ret.add(e.pos);
        }
        ret.sort(new GPComp());
        return ret;
    }

    public static List<GlobalPos> getNearList(UUID uuid, Player player, int limit) {
        ArrayList<GlobalPos> ret = new ArrayList<GlobalPos>();
        BlockPos loc = player.m_142538_();
        ResourceKey dim = player.f_19853_.m_46472_();
        PriorityQueue<GPDist> queue = new PriorityQueue<GPDist>();
        for (ClaimInfo e : mapInfo.values()) {
            if (!e.owner.equals(uuid) || e.pos.m_122640_() != dim) continue;
            BlockPos pos = e.pos.m_122646_();
            double dx = (double)pos.m_123341_() - (double)loc.m_123341_();
            double dz = (double)pos.m_123343_() - (double)loc.m_123343_();
            queue.add(new GPDist(e.pos, dx * dx + dz * dz));
        }
        int k = Math.min(queue.size(), limit);
        for (int i = 0; i < k; ++i) {
            ret.add(((GPDist)queue.poll()).pos);
        }
        return ret;
    }

    public static String[] getPlayers() {
        Object[] ret = new String[mapCount.size()];
        GameProfileCache cache = server.m_129927_();
        int i = 0;
        for (UUID e : mapCount.keySet()) {
            Optional profile = cache.m_11002_(e);
            ret[i] = profile.isPresent() ? ((GameProfile)profile.get()).getName() : e.toString();
            ++i;
        }
        Arrays.sort(ret);
        return ret;
    }

    public static UUID getUUID(String name) {
        GameProfileCache cache = server.m_129927_();
        for (UUID e : mapCount.keySet()) {
            Optional profile = cache.m_11002_(e);
            if (!profile.isPresent() || !name.equalsIgnoreCase(((GameProfile)profile.get()).getName())) continue;
            return e;
        }
        try {
            return UUID.fromString(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getName(ClaimInfo info) {
        Optional profile = server.m_129927_().m_11002_(info.owner);
        return profile.isPresent() ? ((GameProfile)profile.get()).getName() : "?";
    }

    private static void warnLimit(ClaimInfo info, int count) {
        Optional profile = server.m_129927_().m_11002_(info.owner);
        if (profile.isPresent()) {
            LOGGER.warn(((GameProfile)profile.get()).getName() + " exceeding limit: " + count);
        } else {
            LOGGER.warn(info.owner + " exceeding limit: " + count);
        }
    }

    private static void applyDelay() {
        ArrayList<ClaimInfo> copy = new ArrayList<ClaimInfo>(delayList);
        delayList.clear();
        for (ClaimInfo e : copy) {
            ClaimManager.check(e.pos, e.owner);
        }
    }

    public static void load(MinecraftServer server) {
        ClaimManager.server = server;
        File file1 = server.m_129843_(LevelResource.f_78182_).toFile();
        claimFile = new File(file1, "data/claimchunk.dat");
        if (claimFile.exists()) {
            try {
                FileInputStream f = new FileInputStream(claimFile);
                DataInputStream fd = new DataInputStream(new BufferedInputStream(f));
                ClaimManager.readData(fd);
                fd.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ClaimManager.applyDelay();
        ClaimManager.report();
    }

    private static void readData(DataInputStream fd) throws IOException {
        int version = fd.readInt();
        if (version != 100) {
            return;
        }
        int size = fd.readInt();
        if (size <= 0) {
            return;
        }
        UUID[] uuidList = new UUID[size];
        for (int i = 0; i < size; ++i) {
            long lm = fd.readLong();
            long ll = fd.readLong();
            uuidList[i] = new UUID(lm, ll);
        }
        size = fd.readInt();
        if (size <= 0) {
            return;
        }
        ResourceKey[] dimList = new ResourceKey[size];
        for (int i = 0; i < size; ++i) {
            int len = fd.readInt();
            if (len < 0) {
                len = 0;
            }
            StringBuffer buf = new StringBuffer(len);
            for (int j = 0; j < len; ++j) {
                buf.append(fd.readChar());
            }
            dimList[i] = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(buf.toString()));
        }
        size = fd.readInt();
        if (size <= 0) {
            return;
        }
        int[] data = new int[5];
        for (int i = 0; i < size; ++i) {
            for (int k = 0; k < 5; ++k) {
                data[k] = fd.readInt();
            }
            int j = data[1];
            if (j < 0 || j >= dimList.length) continue;
            BlockPos pos = new BlockPos(data[2], data[3], data[4]);
            GlobalPos key = GlobalPos.m_122643_((ResourceKey)dimList[j], (BlockPos)new ChunkPos(pos).m_45615_());
            j = data[0];
            if (j < 0 || j >= uuidList.length) continue;
            ClaimInfo info = new ClaimInfo(uuidList[j], GlobalPos.m_122643_((ResourceKey)key.m_122640_(), (BlockPos)pos));
            mapInfo.put(key, info);
            int count = mapCount.getOrDefault(info.owner, 0);
            mapCount.put(info.owner, count + 1);
        }
    }

    private static void report() {
        HashSet<ResourceKey> set = new HashSet<ResourceKey>();
        int max = 0;
        for (Integer n : mapCount.values()) {
            if (n <= max) continue;
            max = n;
        }
        for (ClaimInfo claimInfo : mapInfo.values()) {
            set.add(claimInfo.pos.m_122640_());
        }
        LOGGER.info("Claims: " + mapCount.size() + " players, " + set.size() + " dims, " + mapInfo.size() + " chunks, " + max + " max chunks");
        if (max > MyConfig.claimLimit) {
            for (Map.Entry entry : mapCount.entrySet()) {
                int count = (Integer)entry.getValue();
                if (count <= MyConfig.claimLimit) continue;
                ClaimManager.warnLimit(new ClaimInfo((UUID)entry.getKey(), null), count);
            }
        }
    }

    public static void save() {
        if (claimFile == null) {
            return;
        }
        try {
            FileOutputStream f = new FileOutputStream(claimFile);
            DataOutputStream fd = new DataOutputStream(new BufferedOutputStream(f));
            ClaimManager.writeData(fd);
            fd.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void writeData(DataOutputStream fd) throws IOException {
        void var10_21;
        void var10_19;
        void var9_12;
        HashMap<UUID, Integer> mapUUID = new HashMap<UUID, Integer>();
        HashMap<ResourceKey, Integer> mapDim = new HashMap<ResourceKey, Integer>();
        int indexUUID = 0;
        int indexDim = 0;
        int index = 0;
        int size = mapInfo.size();
        fd.writeInt(100);
        if (size == 0) {
            fd.writeInt(0);
            fd.writeInt(0);
            fd.writeInt(0);
            return;
        }
        int[] data = new int[size * 5];
        for (ClaimInfo claimInfo : mapInfo.values()) {
            int di;
            int n;
            Integer ppi = (Integer)mapUUID.get(claimInfo.owner);
            if (ppi == null) {
                n = indexUUID++;
                mapUUID.put(claimInfo.owner, n);
            } else {
                n = ppi;
            }
            Integer pdi = (Integer)mapDim.get(claimInfo.pos.m_122640_());
            if (pdi == null) {
                di = indexDim++;
                mapDim.put(claimInfo.pos.m_122640_(), di);
            } else {
                di = pdi;
            }
            BlockPos pos = claimInfo.pos.m_122646_();
            data[index] = n;
            data[index + 1] = di;
            data[index + 2] = pos.m_123341_();
            data[index + 3] = pos.m_123342_();
            data[index + 4] = pos.m_123343_();
            index += 5;
        }
        size = mapUUID.size();
        UUID[] uuidList = new UUID[size];
        for (Map.Entry entry : mapUUID.entrySet()) {
            uuidList[((Integer)entry.getValue()).intValue()] = (UUID)entry.getKey();
        }
        fd.writeInt(size);
        boolean bl = false;
        while (var9_12 < size) {
            fd.writeLong(uuidList[var9_12].getMostSignificantBits());
            fd.writeLong(uuidList[var9_12].getLeastSignificantBits());
            ++var9_12;
        }
        size = mapDim.size();
        ResourceLocation[] resourceLocationArray = new ResourceLocation[size];
        for (Map.Entry e : mapDim.entrySet()) {
            resourceLocationArray[((Integer)e.getValue()).intValue()] = ((ResourceKey)e.getKey()).m_135782_();
        }
        fd.writeInt(size);
        boolean bl2 = false;
        while (var10_19 < size) {
            String str = resourceLocationArray[var10_19].toString();
            fd.writeInt(str.length());
            fd.writeChars(str);
            ++var10_19;
        }
        size = data.length;
        fd.writeInt(size / 5);
        boolean bl3 = false;
        while (var10_21 < size) {
            fd.writeInt(data[var10_21]);
            ++var10_21;
        }
    }

    public static void clear() {
        server = null;
        claimFile = null;
        mapInfo.clear();
        mapCount.clear();
    }

    static {
        delayList = new ArrayList<ClaimInfo>();
        EMPTY = new ClaimInfo(null, null){

            @Override
            public boolean okPerm(Player player) {
                return true;
            }
        };
    }

    public static class ClaimInfo {
        public UUID owner;
        public GlobalPos pos;

        public ClaimInfo(UUID owner, GlobalPos pos) {
            this.owner = owner;
            this.pos = pos;
        }

        public boolean okPerm(Player player) {
            return player.m_142081_().equals(this.owner);
        }
    }

    public static class GPComp
    implements Comparator<GlobalPos> {
        @Override
        public int compare(GlobalPos o1, GlobalPos o2) {
            ResourceKey w2;
            ResourceKey w1 = o1.m_122640_();
            if (w1 != (w2 = o2.m_122640_())) {
                return w1.m_135782_().compareTo(w2.m_135782_());
            }
            BlockPos p1 = o1.m_122646_();
            BlockPos p2 = o2.m_122646_();
            int dx = p1.m_123341_() - p2.m_123341_();
            if (dx != 0) {
                return dx;
            }
            return p1.m_123343_() - p2.m_123343_();
        }
    }

    public static class GPDist
    implements Comparable<GPDist> {
        public GlobalPos pos;
        public double distSq;

        public GPDist(GlobalPos pos, double distSq) {
            this.pos = pos;
            this.distSq = distSq;
        }

        @Override
        public int compareTo(GPDist var1) {
            if (this.distSq < var1.distSq) {
                return -1;
            }
            if (this.distSq > var1.distSq) {
                return 1;
            }
            return 0;
        }
    }
}

