/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.cc.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="cc", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MyConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static boolean addOwner;
    public static boolean mobDestroy;
    public static boolean pvpMode;
    public static boolean reportBucket;
    public static int chunksFromSpawn;
    public static int claimLimit;
    public static Set<Block> bypassBlocks;
    public static Set<EntityType<?>> bypassEntities;
    public static Set<String> excludeDimSet;
    public static Set<String> includeDimSet;
    public static boolean allDims;

    public static boolean checkDim(Level world) {
        String key = world.m_46472_().m_135782_().toString();
        return !allDims && !includeDimSet.contains(key) || excludeDimSet.contains(key);
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            MyConfig.bakeConfig();
        }
    }

    public static void bakeConfig() {
        addOwner = (Boolean)MyConfig.COMMON.addOwner.get();
        mobDestroy = (Boolean)MyConfig.COMMON.mobDestroy.get();
        pvpMode = (Boolean)MyConfig.COMMON.pvpMode.get();
        reportBucket = (Boolean)MyConfig.COMMON.reportBucket.get();
        chunksFromSpawn = (Integer)MyConfig.COMMON.chunksFromSpawn.get();
        claimLimit = (Integer)MyConfig.COMMON.claimLimit.get();
        bypassBlocks = MyConfig.blockSet((List)MyConfig.COMMON.bypassBlocks.get());
        bypassEntities = MyConfig.entitySet((List)MyConfig.COMMON.bypassEntities.get());
        String[] temp = MyConfig.toArray((List)MyConfig.COMMON.includeDims.get());
        allDims = MyConfig.hasAll(temp);
        if (allDims) {
            temp = new String[]{};
        }
        includeDimSet = MyConfig.stringSet(temp);
        excludeDimSet = MyConfig.stringSet(MyConfig.toArray((List)MyConfig.COMMON.excludeDims.get()));
    }

    private static Set<String> stringSet(String[] values) {
        HashSet<String> ret = new HashSet<String>();
        for (String name : values) {
            ret.add(name);
        }
        return ret;
    }

    private static Set<Block> blockSet(List<? extends String> list) {
        HashSet<Block> ret = new HashSet<Block>();
        IForgeRegistry reg = ForgeRegistries.BLOCKS;
        for (String string : MyConfig.emptyFilter(list)) {
            int i = string.indexOf(":*");
            if (i > 0) {
                MyConfig.expandMod((IForgeRegistry<Block>)reg, ret, string.substring(0, i), string.substring(i + 2));
                continue;
            }
            try {
                ResourceLocation res = new ResourceLocation(string);
                if (reg.containsKey(res)) {
                    ret.add((Block)reg.getValue(res));
                    continue;
                }
                LOGGER.warn("Unknown block: " + string);
            }
            catch (Exception e) {
                LOGGER.warn("Bad entry: " + string);
            }
        }
        return ret;
    }

    private static Set<EntityType<?>> entitySet(List<? extends String> list) {
        HashSet ret = new HashSet();
        IForgeRegistry reg = ForgeRegistries.ENTITIES;
        for (String string : MyConfig.emptyFilter(list)) {
            try {
                ResourceLocation res = new ResourceLocation(string);
                if (reg.containsKey(res)) {
                    ret.add((EntityType)reg.getValue(res));
                    continue;
                }
                LOGGER.warn("Unknown entity: " + string);
            }
            catch (Exception e) {
                LOGGER.warn("Bad entry: " + string);
            }
        }
        return ret;
    }

    private static void expandMod(IForgeRegistry<Block> reg, Set<Block> set, String name, String minus) {
        if (!ModList.get().isLoaded(name)) {
            LOGGER.warn("Unknown mod entry in BypassBlocks: " + name);
            return;
        }
        HashSet<String> minusSet = new HashSet<String>();
        for (String n : minus.split("-")) {
            String nt = n.trim();
            if (nt.isEmpty()) continue;
            minusSet.add(nt);
        }
        for (Map.Entry entry : reg.getEntries()) {
            ResourceLocation key = ((ResourceKey)entry.getKey()).m_135782_();
            if (!name.equals(key.m_135827_()) || minusSet.contains(key.m_135815_())) continue;
            Block block = (Block)entry.getValue();
            set.add(block);
        }
    }

    private static boolean hasAll(String[] values) {
        for (String name : values) {
            if (!name.equals("*")) continue;
            return true;
        }
        return false;
    }

    private static String[] toArray(List<? extends String> value) {
        return MyConfig.isEmpty(value) ? new String[]{} : value.toArray(new String[value.size()]);
    }

    private static List<? extends String> emptyFilter(List<? extends String> value) {
        return MyConfig.isEmpty(value) ? new ArrayList() : value;
    }

    private static boolean isEmpty(List<? extends String> value) {
        return value.isEmpty() || value.size() == 1 && value.get(0).isEmpty();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue addOwner;
        public final ForgeConfigSpec.BooleanValue mobDestroy;
        public final ForgeConfigSpec.BooleanValue pvpMode;
        public final ForgeConfigSpec.BooleanValue reportBucket;
        public final ForgeConfigSpec.IntValue chunksFromSpawn;
        public final ForgeConfigSpec.IntValue claimLimit;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> bypassBlocks;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> bypassEntities;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> includeDims;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> excludeDims;

        public Common(ForgeConfigSpec.Builder builder) {
            List<String> bbDefList = Arrays.asList("minecraft:ender_chest");
            List<String> beDefList = Arrays.asList("");
            List<String> idDefList = Arrays.asList("*");
            List<String> edDefList = Arrays.asList("");
            String section_trans = "cc.config.";
            this.addOwner = builder.comment("Add owner name to some messages").translation(section_trans + "add_owner").define("AddOwner", true);
            this.mobDestroy = builder.comment("Mob explosions can destroy blocks based on mob target").translation(section_trans + "mob_destroy").define("MobDestroy", true);
            this.pvpMode = builder.comment("Explosions caused by any player can destroy blocks").translation(section_trans + "player_destroy").define("PvpMode", false);
            this.reportBucket = builder.comment("Report placing fluid from a bucket").translation(section_trans + "report_bucket").define("ReportBucket", false);
            this.chunksFromSpawn = builder.comment("Chunks from world spawn").translation(section_trans + "chunks_from_spawn").defineInRange("ChunksFromSpawn", () -> 10, -1, 5000);
            this.claimLimit = builder.comment("Maximum claims per player").translation(section_trans + "claim_limit").defineInRange("ClaimLimit", () -> 4, 0, 250);
            this.bypassBlocks = builder.comment("Blocks that bypass claims on right click").translation(section_trans + "bypass_blocks").defineList("BypassBlocks", bbDefList, Common::isString);
            this.bypassEntities = builder.comment("Entities that bypass claims on right click").translation(section_trans + "bypass_entities").defineList("BypassEntities", beDefList, Common::isString);
            this.includeDims = builder.comment("Include dimensions").translation(section_trans + "include_dims").defineList("IncludeDims", idDefList, Common::isString);
            this.excludeDims = builder.comment("Exclude dimensions").translation(section_trans + "exclude_dims").defineList("ExcludeDims", edDefList, Common::isString);
        }

        public static boolean isString(Object o) {
            return o instanceof String;
        }
    }
}

