/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.cc.command;

import com.lupicus.cc.block.ClaimBlock;
import com.lupicus.cc.block.ModBlocks;
import com.lupicus.cc.manager.ClaimManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ClaimsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"claims").executes(ctx -> ClaimsCommand.report((CommandSourceStack)ctx.getSource(), null, 0))).then(Commands.m_82129_((String)"limit", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> ClaimsCommand.report((CommandSourceStack)ctx.getSource(), null, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"limit"))))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)StringArgumentType.string()).requires(source -> source.m_6761_(3))).suggests((ctx, builder) -> {
            String[] list = ClaimsCommand.isCreative((CommandSourceStack)ctx.getSource()) ? ClaimManager.getPlayers() : new String[]{};
            return SharedSuggestionProvider.m_82967_((String[])list, (SuggestionsBuilder)builder);
        }).executes(ctx -> ClaimsCommand.report((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"target"), 0))).then(Commands.m_82129_((String)"limit", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> ClaimsCommand.report((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"target"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"limit"))))).then(Commands.m_82127_((String)"remove").executes(ctx -> ClaimsCommand.destroy((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"target"))))).then(Commands.m_82127_((String)"check").executes(ctx -> ClaimsCommand.check((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"target"))))));
    }

    private static boolean isCreative(CommandSourceStack source) {
        Entity e = source.m_81373_();
        boolean creative = e == null ? true : (e instanceof ServerPlayer ? ((ServerPlayer)e).m_7500_() : false);
        return creative;
    }

    private static boolean opCheck(CommandSourceStack source) {
        if (ClaimsCommand.isCreative(source)) {
            return false;
        }
        source.m_81352_((Component)new TextComponent("Must be in Creative Mode to perform this command."));
        return true;
    }

    private static int report(CommandSourceStack source, String string, int limit) throws CommandSyntaxException {
        if (string != null && ClaimsCommand.opCheck(source)) {
            return 0;
        }
        UUID uuid = null;
        uuid = string == null ? source.m_81375_().m_142081_() : ClaimManager.getUUID(string);
        List<GlobalPos> list = null;
        list = limit <= 0 ? ClaimManager.getList(uuid) : ClaimManager.getNearList(uuid, (Player)source.m_81375_(), limit);
        if (list.isEmpty()) {
            String msg = string == null ? "noclaims.you" : "noclaims";
            source.m_81354_((Component)new TranslatableComponent("cc.message." + msg), false);
            return 0;
        }
        StringBuilder msg = new StringBuilder();
        int count = 0;
        for (GlobalPos g : list) {
            String dim = g.m_122640_().m_135782_().toString();
            BlockPos pos = g.m_122646_();
            msg.append(String.valueOf(++count) + "= " + dim + " " + pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_() + "\n");
        }
        msg.setLength(msg.length() - 1);
        source.m_81354_((Component)new TextComponent(msg.toString()), false);
        return 1;
    }

    private static int destroy(CommandSourceStack source, String string) throws CommandSyntaxException {
        if (ClaimsCommand.opCheck(source)) {
            return 0;
        }
        UUID uuid = ClaimManager.getUUID(string);
        List<GlobalPos> list = ClaimManager.getList(uuid);
        if (list.isEmpty()) {
            source.m_81354_((Component)new TranslatableComponent("cc.message.noclaims"), false);
            return 0;
        }
        for (GlobalPos g : list) {
            BlockState state;
            ResourceKey dim = g.m_122640_();
            BlockPos pos = g.m_122646_();
            ServerLevel world = source.m_81377_().m_129880_(dim);
            if (world != null && (state = world.m_8055_(pos)).m_60734_() == ModBlocks.CLAIM_BLOCK) {
                world.m_46961_(pos, false);
            }
            ClaimManager.remove((ResourceKey<Level>)dim, pos);
        }
        return 1;
    }

    private static int check(CommandSourceStack source, String string) throws CommandSyntaxException {
        if (ClaimsCommand.opCheck(source)) {
            return 0;
        }
        UUID uuid = ClaimManager.getUUID(string);
        List<GlobalPos> list = ClaimManager.getList(uuid);
        if (list.isEmpty()) {
            source.m_81354_((Component)new TranslatableComponent("cc.message.noclaims"), false);
            return 0;
        }
        int count = 0;
        for (GlobalPos g : list) {
            ResourceKey dim = g.m_122640_();
            BlockPos pos = g.m_122646_();
            ServerLevel world = source.m_81377_().m_129880_(dim);
            boolean flag = false;
            if (world != null) {
                BlockState state = world.m_8055_(pos);
                if (state.m_60734_() != ModBlocks.CLAIM_BLOCK || !((Boolean)state.m_61143_((Property)ClaimBlock.ENABLED)).booleanValue()) {
                    flag = true;
                }
            } else {
                flag = true;
            }
            if (!flag || !ClaimManager.remove((ResourceKey<Level>)dim, pos, uuid)) continue;
            ++count;
        }
        source.m_81354_((Component)new TextComponent("Removed " + count + " bad claim chunks"), false);
        return 1;
    }
}

