/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.cc.block;

import com.lupicus.cc.block.ModBlocks;
import com.lupicus.cc.config.MyConfig;
import com.lupicus.cc.item.ModItems;
import com.lupicus.cc.manager.ClaimManager;
import com.lupicus.cc.network.ClaimScreenPacket;
import com.lupicus.cc.network.Network;
import com.lupicus.cc.tileentity.ClaimTileEntity;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.FakePlayer;

public class ClaimBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty ENABLED = BlockStateProperties.f_61431_;
    private static final String DATA_TAG = "ClaimData";
    private static final String ACCESS_LIST = "AccessList";
    private static final String MODIFY_LIST = "ModifyList";
    private static final VoxelShape SHAPE = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), Block.m_49796_((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0), Block.m_49796_((double)6.0, (double)3.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0), Block.m_49796_((double)3.0, (double)8.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public ClaimBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.BLOCK;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity te;
        if (!worldIn.f_46443_ && (te = worldIn.m_7702_(pos)) instanceof ClaimTileEntity) {
            ClaimTileEntity cte = (ClaimTileEntity)te;
            if (!(player.m_20310_(3) && player.m_7500_() || player.m_142081_().equals(cte.owner))) {
                player.m_5661_((Component)new TranslatableComponent("cc.message.block.not_owner"), true);
                return InteractionResult.FAIL;
            }
            ItemStack stack = player.m_21120_(handIn);
            Item item = stack.m_41720_();
            if (item == Items.f_42516_) {
                CompoundTag tag = stack.m_41737_(DATA_TAG);
                if (tag != null) {
                    cte.setAccess(tag.m_128461_(ACCESS_LIST));
                    cte.setModify(tag.m_128461_(MODIFY_LIST));
                    cte.m_6596_();
                } else if (!stack.m_41782_()) {
                    ItemStack newstack = stack.m_41613_() > 1 ? stack.m_41620_(1) : stack;
                    tag = newstack.m_41698_(DATA_TAG);
                    tag.m_128359_(ACCESS_LIST, cte.getAccess());
                    tag.m_128359_(MODIFY_LIST, cte.getModify());
                    ClaimBlock.setLore(newstack);
                    if (stack != newstack && !player.m_36356_(newstack)) {
                        player.m_36176_(newstack, false);
                    }
                }
            } else if (player instanceof ServerPlayer) {
                ServerPlayer splayer = (ServerPlayer)player;
                ClientboundBlockEntityDataPacket supdatetileentitypacket = cte.getUpdatePacket();
                if (supdatetileentitypacket != null) {
                    splayer.f_8906_.m_141995_((Packet)supdatetileentitypacket);
                }
                Network.sendToClient(new ClaimScreenPacket(pos), splayer);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        if (world.f_46443_) {
            return null;
        }
        Player player = context.m_43723_();
        if (player instanceof FakePlayer) {
            return null;
        }
        BlockPos pos = context.m_8083_();
        ClaimManager.ClaimInfo cinfo = ClaimManager.get(world, pos);
        if (!cinfo.okPerm(player)) {
            player.m_5661_((Component)ClaimBlock.makeMsg("cc.message.claimed.chunk", cinfo), true);
            return null;
        }
        if (!player.m_20310_(3) || !player.m_7500_()) {
            ChunkPos cpos;
            LevelData winfo;
            ChunkPos scpos;
            if (MyConfig.checkDim(world)) {
                return null;
            }
            if (world.m_46472_() == Level.f_46428_ && (scpos = new ChunkPos(new BlockPos((winfo = world.m_6106_()).m_6789_(), 0, winfo.m_6526_()))).m_45594_(cpos = new ChunkPos(pos)) <= MyConfig.chunksFromSpawn) {
                player.m_5661_((Component)new TranslatableComponent("cc.message.spawn"), true);
                return null;
            }
            if (cinfo.owner == null && ClaimManager.mapCount.getOrDefault(player.m_142081_(), 0) >= MyConfig.claimLimit) {
                player.m_5661_((Component)new TranslatableComponent("cc.message.claim_limit"), true);
                return null;
            }
        }
        return super.m_5573_(context);
    }

    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        boolean flag = (Boolean)state.m_61143_((Property)ENABLED);
        if (flag && MyConfig.pvpMode) {
            LivingEntity entity = explosion.m_46079_();
            if (entity instanceof Mob) {
                Mob mob;
                if (MyConfig.mobDestroy && (mob = (Mob)entity).m_5448_() instanceof Player) {
                    flag = false;
                }
            } else {
                flag = false;
            }
        }
        return flag ? Blocks.f_50752_.m_7325_() : this.m_7325_();
    }

    public void m_7592_(Level worldIn, BlockPos pos, Explosion explosionIn) {
        ClaimManager.ClaimInfo cinfo = ClaimManager.get(worldIn, pos);
        if (cinfo.owner != null && pos.equals((Object)cinfo.pos.m_122646_())) {
            ClaimManager.remove(worldIn, pos);
        }
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        return (Boolean)state.m_61143_((Property)ENABLED) == false;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (worldIn.f_46443_) {
            return;
        }
        if (!(placer instanceof Player)) {
            return;
        }
        Player player = (Player)placer;
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof ClaimTileEntity) {
            ClaimTileEntity cte = (ClaimTileEntity)te;
            ClaimManager.ClaimInfo cinfo = ClaimManager.get(worldIn, pos);
            cte.owner = player.m_142081_();
            CompoundTag tag = stack.m_41783_();
            if (tag != null) {
                cte.setAccess(tag.m_128461_(ACCESS_LIST));
                cte.setModify(tag.m_128461_(MODIFY_LIST));
            }
            cte.m_6596_();
            if (cinfo.owner != null) {
                BlockPos oldPos = cinfo.pos.m_122646_();
                BlockState oldState = worldIn.m_8055_(oldPos);
                if (oldState.m_60734_() == this) {
                    worldIn.m_46597_(oldPos, (BlockState)oldState.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(false)));
                }
                ClaimManager.replace(worldIn, pos);
            } else {
                player.m_5661_((Component)new TranslatableComponent("cc.message.claim"), true);
                ClaimManager.add(worldIn, pos, player);
            }
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        boolean flag;
        boolean claimed = (Boolean)state.m_61143_((Property)ENABLED);
        if (claimed) {
            if (world.f_46443_) {
                return false;
            }
            ClaimManager.ClaimInfo cinfo = ClaimManager.get(world, pos);
            if (cinfo.owner == null || !pos.equals((Object)cinfo.pos.m_122646_())) {
                claimed = false;
            } else if (!cinfo.okPerm(player)) {
                player.m_5661_((Component)new TranslatableComponent("cc.message.block.not_owner"), true);
                return false;
            }
        }
        if ((flag = super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid)) && claimed) {
            player.m_5661_((Component)new TranslatableComponent("cc.message.unclaim"), true);
            ClaimManager.remove(world, pos);
        }
        return flag;
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        ClaimTileEntity cte;
        List ret = super.m_7381_(state, builder);
        BlockEntity entity = (BlockEntity)builder.m_78970_(LootContextParams.f_81462_);
        if (!(!(entity instanceof ClaimTileEntity) || (cte = (ClaimTileEntity)entity).getAccess().isEmpty() && cte.getModify().isEmpty())) {
            for (ItemStack e : ret) {
                if (e.m_41720_() != ModItems.CLAIM_BLOCK) continue;
                CompoundTag tag = e.m_41784_();
                tag.m_128359_(ACCESS_LIST, cte.getAccess());
                tag.m_128359_(MODIFY_LIST, cte.getModify());
            }
        }
        return ret;
    }

    public static void enableBlock(Level world, BlockPos pos, Player player, UUID owner) {
        BlockState state = world.m_8055_(pos);
        if (!((Boolean)state.m_61143_((Property)ENABLED)).booleanValue()) {
            ClaimManager.ClaimInfo cinfo = ClaimManager.get(world, pos);
            if (cinfo.owner == null) {
                boolean opFlag;
                boolean bl = opFlag = player.m_20310_(3) && player.m_7500_();
                if (!opFlag && ClaimManager.mapCount.getOrDefault(owner, 0) >= MyConfig.claimLimit) {
                    player.m_5661_((Component)new TranslatableComponent("cc.message.claim_limit"), true);
                    return;
                }
                ClaimManager.add(world, pos, owner);
            } else if (cinfo.owner.equals(owner)) {
                BlockPos oldPos = cinfo.pos.m_122646_();
                BlockState oldState = world.m_8055_(oldPos);
                if (oldState.m_60734_() == ModBlocks.CLAIM_BLOCK) {
                    world.m_46597_(oldPos, (BlockState)oldState.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(false)));
                }
                ClaimManager.replace(world, pos);
            } else {
                player.m_5661_((Component)ClaimBlock.makeMsg("cc.message.claimed.chunk", cinfo), true);
                return;
            }
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(true)));
        }
    }

    public static void clearPaper(ItemStack stack, Player player) {
        CompoundTag tag = stack.m_41737_(DATA_TAG);
        if (tag != null) {
            ItemStack newstack = stack.m_41613_() > 1 ? stack.m_41620_(1) : stack;
            newstack.m_41751_(null);
            if (stack != newstack && !player.m_36356_(newstack)) {
                player.m_36176_(newstack, false);
            }
        }
    }

    private static void setLore(ItemStack stack) {
        CompoundTag tag = stack.m_41698_("display");
        ListTag list = new ListTag();
        list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)new TranslatableComponent("cc.lore.paper"))));
        tag.m_128365_("Lore", (Tag)list);
    }

    public static MutableComponent makeMsg(String trans, ClaimManager.ClaimInfo info) {
        TranslatableComponent msg = new TranslatableComponent(trans);
        if (MyConfig.addOwner) {
            msg.m_130946_(": " + ClaimManager.getName(info));
        }
        return msg;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ENABLED});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ClaimTileEntity(pos, state);
    }
}

