/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.darksouls.common.items.weapons.parent;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.platform.InputConstants;
import com.nitespring.darksouls.common.CustomDamageType;
import com.nitespring.darksouls.common.interfaces.IDarkSoulsUpgradable;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DarkSoulsCustomWeapon
extends Item
implements IDarkSoulsUpgradable {
    private final float attackDamage;
    private final float attackSpeed;
    private final boolean isTit;
    private final boolean isScale;
    private final boolean isTwink;
    private final boolean canBeInfused;
    private final float physicalDamage;
    private final float fireDamage;
    private final float lightningDamage;
    private final float magicDamage;
    private final float darkDamage;
    private float dmgVar = 0.4f;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public DarkSoulsCustomWeapon(float physicalDamageIn, float fireDamageIn, float magicDamageIn, float lightningDamageIn, float darkDamageIn, float attackSpeedIn, boolean isTit, boolean isScale, boolean isTwink, boolean canBeInfused, Item.Properties properties) {
        super(properties);
        this.physicalDamage = physicalDamageIn;
        this.fireDamage = fireDamageIn;
        this.magicDamage = magicDamageIn;
        this.lightningDamage = lightningDamageIn;
        this.darkDamage = darkDamageIn;
        this.attackDamage = physicalDamageIn + fireDamageIn + magicDamageIn + lightningDamageIn + darkDamageIn;
        this.attackSpeed = attackSpeedIn;
        this.isTit = isTit;
        this.isScale = isScale;
        this.isTwink = isTwink;
        this.canBeInfused = canBeInfused;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage - 1.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.attackSpeed - 4.0, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    public boolean m_6777_(BlockState p_195938_1_, Level p_195938_2_, BlockPos p_195938_3_, Player p_195938_4_) {
        return !p_195938_4_.m_7500_();
    }

    public float m_8102_(ItemStack p_150893_1_, BlockState p_150893_2_) {
        if (p_150893_2_.m_60713_(Blocks.f_50033_)) {
            return 15.0f;
        }
        Material material = p_150893_2_.m_60767_();
        return material != Material.f_76300_ && material != Material.f_76302_ && !p_150893_2_.m_204336_(BlockTags.f_13035_) && material != Material.f_76285_ ? 1.0f : 1.5f;
    }

    public boolean m_6813_(ItemStack p_179218_1_, Level p_179218_2_, BlockState p_179218_3_, BlockPos p_179218_4_, LivingEntity p_179218_5_) {
        if (p_179218_3_.m_60800_((BlockGetter)p_179218_2_, p_179218_4_) != 0.0f) {
            p_179218_1_.m_41622_(2, p_179218_5_, p_220044_0_ -> p_220044_0_.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean m_8096_(BlockState p_150897_1_) {
        return p_150897_1_.m_60713_(Blocks.f_50033_);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("DSLevel")) {
            int level = stack.m_41783_().m_128451_("DSLevel");
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)(this.attackDamage * (1.0f + this.dmgVar * (float)level)) - 1.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.attackSpeed - 4.0, AttributeModifier.Operation.ADDITION));
            ImmutableMultimap defaultModifiers = builder.build();
            return slot == EquipmentSlot.MAINHAND ? defaultModifiers : super.getAttributeModifiers(slot, stack);
        }
        return slot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.getAttributeModifiers(slot, stack);
    }

    @Override
    public boolean isTitanite() {
        return this.isTit;
    }

    @Override
    public boolean isScale() {
        return this.isScale;
    }

    @Override
    public boolean isTwinkling() {
        return this.isTwink;
    }

    public boolean canBeInfused() {
        return this.canBeInfused;
    }

    public int getDamage(ItemStack stack) {
        return 0;
    }

    public boolean m_5812_(ItemStack p_77636_1_) {
        return false;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player playerIn, Entity entityIn) {
        float strenghtModifier = playerIn.m_36403_(0.0f);
        if (stack.m_41782_() && stack.m_41783_().m_128441_("DSLevel")) {
            int level = stack.m_41783_().m_128451_("DSLevel");
            entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)playerIn), this.physicalDamage * (1.0f + this.dmgVar * (float)level) * strenghtModifier);
            entityIn.f_19802_ = 0;
            entityIn.m_6469_(CustomDamageType.dsDirectDarkDamage((Entity)playerIn), this.darkDamage * (1.0f + this.dmgVar * (float)level) * strenghtModifier);
            entityIn.f_19802_ = 0;
            entityIn.m_6469_(CustomDamageType.dsDirectLightningDamage((Entity)playerIn), this.lightningDamage * (1.0f + this.dmgVar * (float)level) * strenghtModifier);
            entityIn.f_19802_ = 0;
            entityIn.m_6469_(CustomDamageType.dsDirectFireDamage((Entity)playerIn), this.fireDamage * (1.0f + this.dmgVar * (float)level) * strenghtModifier);
            entityIn.f_19802_ = 0;
            entityIn.m_6469_(CustomDamageType.dsDirectMagicDamage((Entity)playerIn), this.magicDamage * (1.0f + this.dmgVar * (float)level) * strenghtModifier);
        } else {
            entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)playerIn), this.physicalDamage * strenghtModifier);
            entityIn.f_19802_ = 0;
            entityIn.m_6469_(CustomDamageType.dsDirectDarkDamage((Entity)playerIn), this.darkDamage * strenghtModifier);
            entityIn.f_19802_ = 0;
            entityIn.m_6469_(CustomDamageType.dsDirectLightningDamage((Entity)playerIn), this.lightningDamage * strenghtModifier);
            entityIn.f_19802_ = 0;
            entityIn.m_6469_(CustomDamageType.dsDirectFireDamage((Entity)playerIn), this.fireDamage * strenghtModifier);
            entityIn.f_19802_ = 0;
            entityIn.m_6469_(CustomDamageType.dsDirectMagicDamage((Entity)playerIn), this.magicDamage * strenghtModifier);
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level p_77624_2_, List<Component> tooltip, TooltipFlag p_77624_4_) {
        super.m_7373_(stack, p_77624_2_, tooltip, p_77624_4_);
        if (stack.m_41782_() && stack.m_41783_().m_128441_("DSLevel")) {
            int level = stack.m_41783_().m_128451_("DSLevel");
            String string = "\u00a77+" + level;
            tooltip.add((Component)new TextComponent(string));
            String info = "\u00a78\u00a7oPress shift for more information";
            tooltip.add((Component)new TextComponent(info));
            if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340)) {
                String dmgPhys = "\u00a77" + (double)Math.round((double)(this.physicalDamage * (1.0f + this.dmgVar * (float)level)) * 100.0) / 100.0 + " Physical Damage";
                tooltip.add((Component)new TextComponent(dmgPhys));
                String dmgFire = "\u00a74" + (double)Math.round((double)(this.fireDamage * (1.0f + this.dmgVar * (float)level)) * 100.0) / 100.0 + " Fire Damage";
                tooltip.add((Component)new TextComponent(dmgFire));
                String dmgMagic = "\u00a7b" + (double)Math.round((double)(this.magicDamage * (1.0f + this.dmgVar * (float)level)) * 100.0) / 100.0 + " Magic Damage";
                tooltip.add((Component)new TextComponent(dmgMagic));
                String dmgLightning = "\u00a7e" + (double)Math.round((double)(this.lightningDamage * (1.0f + this.dmgVar * (float)level)) * 100.0) / 100.0 + " Lightning Damage";
                tooltip.add((Component)new TextComponent(dmgLightning));
                String dmgDark = "\u00a75" + (double)Math.round((double)(this.darkDamage * (1.0f + this.dmgVar * (float)level)) * 100.0) / 100.0 + " Dark Damage";
                tooltip.add((Component)new TextComponent(dmgDark));
            }
        } else {
            String string = "\u00a77+0";
            tooltip.add((Component)new TextComponent(string));
            String info = "\u00a78\u00a7oPress shift for more information";
            tooltip.add((Component)new TextComponent(info));
            if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340)) {
                String dmgPhys = "\u00a77" + (double)Math.round((double)this.physicalDamage * 100.0) / 100.0 + " Physical Damage";
                tooltip.add((Component)new TextComponent(dmgPhys));
                String dmgFire = "\u00a74" + (double)Math.round((double)this.fireDamage * 100.0) / 100.0 + " Fire Damage";
                tooltip.add((Component)new TextComponent(dmgFire));
                String dmgMagic = "\u00a7b" + (double)Math.round((double)this.magicDamage * 100.0) / 100.0 + " Magic Damage";
                tooltip.add((Component)new TextComponent(dmgMagic));
                String dmgLightning = "\u00a7e" + (double)Math.round((double)this.lightningDamage * 100.0) / 100.0 + " Lightning Damage";
                tooltip.add((Component)new TextComponent(dmgLightning));
                String dmgDark = "\u00a75" + (double)Math.round((double)this.darkDamage * 100.0) / 100.0 + " Dark Damage";
                tooltip.add((Component)new TextComponent(dmgDark));
            }
        }
    }

    public Rarity m_41460_(ItemStack p_77613_1_) {
        return Rarity.EPIC;
    }
}

