/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.darksouls.common.items.miscellaneous;

import com.google.common.collect.ImmutableList;
import com.nitespring.darksouls.client.render.items.spawnEgg.SpawnEggRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraftforge.client.IItemRenderProperties;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;

public class EntityModelSpawnEggItem
extends SpawnEggItem {
    private static final List<EntityModelSpawnEggItem> EGGS = new ArrayList<EntityModelSpawnEggItem>();
    private final Supplier<EntityType<?>> typeSupplier;

    public EntityModelSpawnEggItem(Supplier<EntityType<?>> typeSupplier, int primaryColorIn, int secondaryColorIn, Item.Properties builder) {
        super(null, primaryColorIn, secondaryColorIn, builder);
        this.typeSupplier = typeSupplier;
        EGGS.add(this);
    }

    public EntityType<?> m_43228_(CompoundTag tag) {
        return this.typeSupplier.get();
    }

    public static List<EntityModelSpawnEggItem> getSupplierEggs() {
        return ImmutableList.copyOf(EGGS);
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IItemRenderProperties(){
            private final BlockEntityWithoutLevelRenderer renderer = new SpawnEggRenderer();

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return this.renderer;
            }
        });
    }

    @Mixin(value={SpawnEggItem.class})
    public static interface SpawnEggItemMixin {
        @Accessor(value="EGGS")
        public static Map<EntityType<?>, SpawnEggItem> getEggMap() {
            throw new AssertionError();
        }
    }
}

