/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.darksouls.common.items.magic;

import com.nitespring.darksouls.client.render.items.lightning.LightningGeoRenderer;
import com.nitespring.darksouls.common.entities.projectiles.LightningProjectileEntity;
import com.nitespring.darksouls.core.init.ProjectileInit;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.IItemRenderProperties;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class LightningItem
extends Item
implements IAnimatable {
    public static final String CONTROLLER = "controller";
    public AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public LightningItem(Item.Properties p_i48487_1_) {
        super(p_i48487_1_);
    }

    private <P extends Item> PlayState predicate(AnimationEvent<P> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.lightning.new", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    public int getDamage(ItemStack stack) {
        return 0;
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, CONTROLLER, 1.0f, this::predicate);
        data.addAnimationController(controller);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level p_77659_1_, Player playerIn, InteractionHand handIn) {
        playerIn.m_6672_(handIn);
        return super.m_7203_(p_77659_1_, playerIn, handIn);
    }

    public UseAnim m_6164_(ItemStack p_77661_1_) {
        return UseAnim.SPEAR;
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IItemRenderProperties(){
            private final BlockEntityWithoutLevelRenderer renderer = new LightningGeoRenderer();

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return this.renderer;
            }
        });
    }

    public void m_5551_(ItemStack stackIn, Level worldIn, LivingEntity playerIn, int p_77615_4_) {
        Vec3 pos = playerIn.m_20182_();
        Vec3 aim = playerIn.m_20154_();
        playerIn.m_5496_(SoundEvents.f_12089_, 0.5f, 3.0f);
        LightningProjectileEntity bullet = new LightningProjectileEntity((EntityType<? extends AbstractHurtingProjectile>)((EntityType)ProjectileInit.LIGHTNING.get()), worldIn, playerIn);
        bullet.m_5602_((Entity)playerIn);
        bullet.setBaseDamage(7.0f);
        bullet.setMaxLifeTime(70);
        bullet.m_6034_(pos.f_82479_ + aim.f_82479_, pos.f_82480_ + aim.f_82480_ + 2.0, pos.f_82481_ + aim.f_82481_);
        bullet.f_36813_ = aim.f_82479_ * 0.5;
        bullet.f_36814_ = aim.f_82480_ * 0.5;
        bullet.f_36815_ = aim.f_82481_ * 0.5;
        worldIn.m_7967_((Entity)bullet);
        if (playerIn instanceof Player) {
            ((Player)playerIn).m_36335_().m_41524_(stackIn.m_41720_(), 15);
        }
        super.m_5551_(stackIn, worldIn, playerIn, p_77615_4_);
    }

    public int m_8105_(ItemStack stack) {
        return 10000;
    }
}

