/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.darksouls.common.entityAI.goals.boss;

import com.mojang.math.Vector3f;
import com.nitespring.darksouls.common.entities.mobs.bosses.NamelessKingEntity;
import com.nitespring.darksouls.common.entities.projectiles.LightningProjectileEntity;
import com.nitespring.darksouls.common.entities.projectiles.SwordSpearProjectileEntity;
import com.nitespring.darksouls.common.entities.projectiles.WindNoCollisionsProjectileEntity;
import com.nitespring.darksouls.core.helpers.AttackHitboxHelpers;
import com.nitespring.darksouls.core.init.ProjectileInit;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class NamelessKingAttackGoalOld
extends Goal {
    private final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    protected final NamelessKingEntity mob;
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private final int attackInterval = 20;
    private long lastCanUseCheck;
    private int failedPathFindingPenalty = 0;
    private boolean canPenalize = false;
    private int animTime = 0;
    private double destX;
    private double destY;
    private double destZ;
    private double startX;
    private double startY;
    private double startZ;

    public NamelessKingAttackGoalOld(NamelessKingEntity entityIn, double speedIn, boolean followNotSeeing) {
        this.mob = entityIn;
        this.speedModifier = speedIn;
        this.followingTargetEvenIfNotSeen = followNotSeeing;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long i = this.mob.f_19853_.m_46467_();
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (this.canPenalize) {
            if (--this.ticksUntilNextPathRecalculation <= 0) {
                this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
                this.ticksUntilNextPathRecalculation = 4 + this.mob.m_21187_().nextInt(7);
                return this.path != null;
            }
            return true;
        }
        this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(livingentity) >= this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
    }

    public boolean m_8045_() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.mob.m_21573_().m_26571_();
        }
        if (!this.mob.m_21444_(livingentity.m_142538_())) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
        this.mob.m_21561_(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
        this.animTime = 0;
        this.mob.setAnimationState(0);
    }

    public void m_8041_() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (!EntitySelector.f_20406_.test(livingentity)) {
            this.mob.m_6710_(null);
        }
        this.mob.setAnimationState(0);
        this.mob.m_21561_(false);
        this.mob.m_21573_().m_26573_();
    }

    public void m_8037_() {
        LivingEntity target = this.mob.m_5448_();
        double distance = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
        double reach = this.getAttackReachSqr(target);
        int animState = this.mob.getAnimationState();
        Vec3 aim = this.mob.m_20154_();
        Vec2 aim2d = new Vec2((float)(aim.f_82479_ / (1.0 - Math.abs(aim.f_82480_))), (float)(aim.f_82481_ / (1.0 - Math.abs(aim.f_82480_))));
        double pi = Math.PI;
        if (animState == 71) {
            ++this.animTime;
            this.mob.m_21573_().m_26517_(0.0);
            if (this.animTime == 27) {
                this.doWrathOfTheGods();
            }
            if (this.animTime >= 27 && this.animTime <= 100) {
                this.tickLightningStorm(this.animTime, this.mob.m_20182_());
            }
            if (this.animTime >= 150) {
                this.mob.setAnimationState(0);
                this.animTime = 0;
                this.resetAttackCooldown();
            }
        } else if (animState == 70) {
            ++this.animTime;
            this.mob.m_21573_().m_26517_(0.0);
            if (this.animTime == 12) {
                this.mob.m_5496_(SoundEvents.f_12089_, 0.3f, 2.5f);
            }
            if (this.animTime == 27) {
                this.shootLightning((Mob)this.mob, this.mob.f_19853_);
            }
            if (this.animTime >= 31) {
                this.mob.setAnimationState(0);
                this.animTime = 0;
                this.resetAttackCooldown();
            }
        } else if (animState == 10) {
            ++this.animTime;
            if (this.animTime == 10) {
                this.startX = this.mob.m_20185_();
                this.startY = this.mob.m_20186_();
                this.startZ = this.mob.m_20189_();
                this.destX = this.startX + 10.0 * ((double)aim2d.f_82470_ * Math.cos(pi / 4.0) - (double)aim2d.f_82471_ * Math.sin(pi / 4.0));
                this.destY = this.startY;
                this.destZ = this.startZ + 10.0 * ((double)aim2d.f_82471_ * Math.cos(pi / 4.0) + (double)aim2d.f_82470_ * Math.sin(pi / 4.0));
                this.performLightAttack();
                this.summonWind();
                this.mob.m_5496_(SoundEvents.f_12591_, 2.0f, 0.6f);
                this.mob.m_5496_(SoundEvents.f_12090_, 0.8f, 1.2f);
            }
            if (this.animTime >= 10) {
                this.mob.m_20334_((this.destX - this.startX) * 0.12, 0.2, (this.destZ - this.startZ) * 0.12);
                this.summonWindParticles();
                this.mob.m_5496_(SoundEvents.f_12591_, 2.0f, 0.6f);
            }
            if (this.animTime >= 18) {
                this.mob.m_20334_(0.0, -1.0, 0.0);
                this.mob.setAnimationState(40);
                this.animTime = 0;
            }
        } else if (animState == 11) {
            ++this.animTime;
            if (this.animTime == 5) {
                this.startX = this.mob.m_20185_();
                this.startY = this.mob.m_20186_();
                this.startZ = this.mob.m_20189_();
                this.destZ = this.startZ + 20.0 * ((double)aim2d.f_82470_ * Math.cos(pi / 4.0) + (double)aim2d.f_82471_ * Math.sin(pi / 4.0));
                this.destY = this.startY;
                this.destX = this.startX + 20.0 * ((double)aim2d.f_82471_ * Math.cos(pi / 4.0) - (double)aim2d.f_82470_ * Math.sin(pi / 4.0));
                this.performLightAttack();
                this.summonWind();
                this.mob.m_5496_(SoundEvents.f_12591_, 2.0f, 0.6f);
                this.mob.m_5496_(SoundEvents.f_12090_, 0.8f, 1.2f);
            }
            if (this.animTime >= 5) {
                this.mob.m_20334_((this.destX - this.startX) * 0.08, 0.25, (this.destZ - this.startZ) * 0.08);
                this.mob.m_5496_(SoundEvents.f_12591_, 2.0f, 0.6f);
                this.summonWindParticles();
            }
            if (this.animTime >= 14) {
                this.mob.setAnimationState(0);
                this.animTime = 0;
                this.resetAttackCooldown();
            }
        } else if (animState == 12) {
            ++this.animTime;
            if (this.animTime == 5) {
                this.startX = this.mob.m_20185_();
                this.startY = this.mob.m_20186_();
                this.startZ = this.mob.m_20189_();
                this.destZ = this.startZ + (double)(10.0f * aim2d.f_82471_);
                this.destY = this.startY;
                this.destX = this.startX + (double)(10.0f * aim2d.f_82470_);
                this.mob.m_5496_(SoundEvents.f_12591_, 2.0f, 0.6f);
                this.mob.m_5496_(SoundEvents.f_12090_, 0.8f, 1.2f);
            }
            if (this.animTime >= 5 && this.animTime < 20) {
                this.mob.m_20334_((this.destX - this.startX) * 0.12, 0.1, (this.destZ - this.startZ) * 0.12);
                this.performLightAttack();
                this.mob.m_5496_(SoundEvents.f_12591_, 2.0f, 0.6f);
            }
            if (this.animTime == 22) {
                this.performLightAttack();
                this.mob.m_5496_(SoundEvents.f_12317_, 2.0f, 0.6f);
            }
            if (this.animTime >= 20) {
                this.mob.m_20334_((this.destX - this.startX) * 0.06, -0.05, (this.destZ - this.startZ) * 0.06);
                this.mob.m_5496_(SoundEvents.f_12591_, 2.0f, 0.6f);
            }
            if (this.animTime >= 25) {
                this.performLightAttack();
                this.summonWindParticles();
            } else {
                this.mob.m_5618_(this.mob.m_20155_().f_82471_);
            }
            if (this.animTime == 28) {
                this.mob.m_5496_(SoundEvents.f_12317_, 2.0f, 0.6f);
                this.summonLightiningParticlesAround();
            }
            if (this.animTime >= 31) {
                if (this.mob.m_20270_((Entity)target) >= 20.0f) {
                    this.mob.setAnimationState(0);
                    this.ticksUntilNextAttack = 4;
                } else {
                    this.mob.setAnimationState(40);
                }
                this.animTime = 0;
            }
        } else if (animState == 20) {
            ++this.animTime;
            this.mob.m_21573_().m_26517_(0.0);
            if (this.animTime == 8) {
                this.performLightAttack();
            }
            if (this.animTime >= 10) {
                this.mob.setAnimationState(30);
                this.animTime = 0;
            }
        } else if (animState == 21) {
            ++this.animTime;
            this.mob.m_21573_().m_26517_(0.0);
            if (this.animTime == 10) {
                this.performLightAttack();
            }
            if (this.animTime >= 13) {
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
                this.animTime = 0;
            }
        } else if (animState == 22) {
            ++this.animTime;
            if (this.animTime == 8) {
                this.performLightAttack();
            }
            if (this.animTime >= 13) {
                this.animTime = 0;
                this.resetAttackCooldown();
                this.mob.setAnimationState(0);
            }
        } else if (animState == 23) {
            ++this.animTime;
            this.mob.m_21573_().m_26517_(0.0);
            if (this.animTime == 12) {
                this.performSlamAttack();
            }
            if (this.animTime >= 20) {
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
                this.animTime = 0;
            }
        } else if (animState == 24) {
            LightningBolt bolt;
            ++this.animTime;
            this.mob.m_21573_().m_26517_(0.0);
            if (this.animTime == 45) {
                bolt = new LightningBolt(EntityType.f_20465_, this.mob.f_19853_);
                bolt.m_6034_(this.mob.m_20182_().f_82479_, this.mob.m_20182_().f_82480_ + 10.0, this.mob.m_20182_().f_82481_);
                this.mob.f_19853_.m_7967_((Entity)bolt);
            }
            if (this.animTime == 55) {
                bolt = new LightningBolt(EntityType.f_20465_, this.mob.f_19853_);
                bolt.m_6034_(target.m_20182_().f_82479_, target.m_20182_().f_82480_, target.m_20182_().f_82481_);
                this.mob.f_19853_.m_7967_((Entity)bolt);
            }
            if (this.animTime >= 56) {
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
                this.animTime = 0;
            }
        } else if (animState == 30) {
            ++this.animTime;
            if (this.animTime == 8) {
                this.performLightAttack();
            }
            if (this.animTime >= 12) {
                this.animTime = 0;
                this.resetAttackCooldown();
                this.mob.setAnimationState(0);
            }
        } else if (animState == 31) {
            ++this.animTime;
            this.mob.m_21573_().m_26517_(0.0);
            if (this.animTime == 6) {
                this.performLightAttack();
            }
            if (this.animTime >= 9) {
                this.mob.setAnimationState(22);
                this.animTime = 0;
            }
        } else if (animState == 35) {
            ++this.animTime;
            this.mob.m_21573_().m_26517_(0.0);
            if (this.animTime == 8) {
                this.performLightAttack();
                this.summonWind();
            }
            if (this.animTime >= 10) {
                this.mob.setAnimationState(36);
                this.animTime = 0;
            }
        } else if (animState == 36) {
            ++this.animTime;
            this.mob.m_21573_().m_26517_(0.0);
            if (this.animTime == 8) {
                this.performLightAttack();
                this.summonWind();
            }
            if (this.animTime >= 10) {
                this.mob.setAnimationState(0);
                this.animTime = 0;
                this.resetAttackCooldown();
            }
        } else if (animState == 40) {
            ++this.animTime;
            this.mob.m_20334_((double)aim2d.f_82470_ * 0.25, 0.001, (double)aim2d.f_82471_ * 0.25);
            this.doMovement(target, distance);
            if (this.animTime >= 15) {
                this.mob.setAnimationState(41);
                this.animTime = 0;
            }
        } else if (animState == 41) {
            ++this.animTime;
            if (this.animTime <= 4) {
                this.mob.m_20334_((double)aim2d.f_82470_ * 0.25, 0.001, (double)aim2d.f_82471_ * 0.25);
            }
            if (this.animTime == 5) {
                this.performLightAttack();
            }
            if (this.animTime >= 8) {
                if (this.mob.m_20270_((Entity)target) >= 20.0f) {
                    this.mob.setAnimationState(0);
                    this.resetAttackCooldown();
                } else {
                    this.mob.setAnimationState(31);
                }
                this.animTime = 0;
            }
        } else if (animState == 50) {
            ++this.animTime;
            if (this.animTime >= 2 && this.animTime < 6) {
                this.mob.m_20334_(0.0, 1.6, 0.0);
            }
            if (this.animTime == 6) {
                this.startX = this.mob.m_20185_();
                this.startY = this.mob.m_20186_();
                this.startZ = this.mob.m_20189_();
                this.destX = this.startX + (double)(aim2d.f_82470_ * 100.0f);
                this.destY = this.startY;
                this.destZ = this.startZ + (double)(aim2d.f_82471_ * 100.0f);
            }
            if (this.animTime > 6) {
                this.mob.m_20334_(0.0, 0.0, 0.0);
                this.mob.m_21563_().m_24946_(this.destX, this.destY, this.destZ);
                this.mob.m_5618_(this.mob.m_20155_().f_82471_);
            }
            if (this.animTime >= 15) {
                this.mob.setAnimationState(51);
                this.animTime = 0;
            }
        } else if (animState == 51) {
            ++this.animTime;
            this.mob.m_20334_((this.destX - this.startX) * 0.008, -0.5, (this.destZ - this.startZ) * 0.008);
            this.mob.m_5618_(this.mob.m_20155_().f_82471_);
            this.performLightAttack();
            this.summonWindParticles();
            this.mob.m_21563_().m_24946_(this.destX, this.destY, this.destZ);
            if (this.mob.m_20096_() || this.animTime >= 100) {
                this.mob.m_5496_(SoundEvents.f_12090_, 2.0f, 1.2f);
                this.mob.setAnimationState(52);
                this.animTime = 0;
            }
        } else if (animState == 52) {
            ++this.animTime;
            if (this.animTime == 2) {
                this.performLightAttack();
                this.mob.m_5496_(SoundEvents.f_12090_, 2.0f, 1.8f);
            }
            if (this.animTime >= 8) {
                this.mob.setAnimationState(30);
                this.animTime = 0;
                this.resetAttackCooldown();
            }
        } else if (animState == 60) {
            ++this.animTime;
            if (this.animTime == 10) {
                this.startX = this.mob.m_20185_();
                this.startY = this.mob.m_20186_();
                this.startZ = this.mob.m_20189_();
                this.destX = this.startX + (double)(aim2d.f_82470_ * 100.0f);
                this.destY = this.startY;
                this.destZ = this.startZ + (double)(aim2d.f_82471_ * 100.0f);
                this.mob.m_5496_(SoundEvents.f_12090_, 2.0f, 1.2f);
            }
            if (this.animTime >= 10) {
                this.mob.m_21563_().m_24946_(this.destX, this.destY, this.destZ);
                this.mob.m_20334_((this.destX - this.startX) * 0.01, 0.01, (this.destZ - this.startZ) * 0.01);
                this.summonWindParticles();
                this.performLightAttack();
            }
            if (this.animTime >= 18) {
                this.mob.setAnimationState(61);
                this.animTime = 0;
            }
        } else if (animState == 61) {
            ++this.animTime;
            this.mob.m_20334_((this.destX - this.startX) * 0.01, 0.0, (this.destZ - this.startZ) * 0.01);
            this.performLightAttack();
            this.mob.m_21563_().m_24946_(this.destX, this.destY, this.destZ);
            this.summonWindParticles();
            this.mob.m_5618_(this.mob.m_20155_().f_82471_);
            if (this.animTime >= 20) {
                this.mob.m_5496_(SoundEvents.f_12090_, 2.0f, 1.2f);
                this.mob.setAnimationState(31);
                this.animTime = 0;
            }
        } else {
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            this.doMovement(target, reach);
            this.checkForCloseRangeAttack(distance, reach);
            this.checkForLongRangeAttack();
        }
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
    }

    protected void doMovement(LivingEntity livingentity, Double d0) {
        if ((this.followingTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_21187_().nextFloat() < 0.05f)) {
            this.pathedTargetX = livingentity.m_20185_();
            this.pathedTargetY = livingentity.m_20186_();
            this.pathedTargetZ = livingentity.m_20189_();
            this.ticksUntilNextPathRecalculation = 4 + this.mob.m_21187_().nextInt(7);
            if (this.canPenalize) {
                Node finalPathPoint;
                this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                this.failedPathFindingPenalty = this.mob.m_21573_().m_26570_() != null ? ((finalPathPoint = this.mob.m_21573_().m_26570_().m_77395_()) != null && livingentity.m_20275_((double)finalPathPoint.f_77271_, (double)finalPathPoint.f_77272_, (double)finalPathPoint.f_77273_) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
            }
            if (d0 > 1024.0) {
                this.ticksUntilNextPathRecalculation += 10;
            } else if (d0 > 256.0) {
                this.ticksUntilNextPathRecalculation += 5;
            }
            if (!this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier)) {
                this.ticksUntilNextPathRecalculation += 15;
            }
        }
    }

    protected void checkForCloseRangeAttack(double distance, double reach) {
        if (distance <= reach && this.ticksUntilNextAttack <= 0) {
            int r = this.mob.m_21187_().nextInt(2048);
            if (r <= 100) {
                this.mob.setAnimationState(20);
            } else if (r <= 200) {
                this.mob.setAnimationState(21);
            } else if (r <= 260) {
                this.mob.setAnimationState(23);
            } else if (r <= 300) {
                this.mob.setAnimationState(31);
            }
        }
    }

    protected void checkForRangedAttack() {
        if (this.ticksUntilNextAttack <= 0) {
            this.mob.setAnimationState(70);
        }
    }

    protected void checkForLongRangeAttack() {
        if (this.ticksUntilNextAttack <= 0) {
            int r = this.mob.m_21187_().nextInt(2048);
            if (r <= 10) {
                this.mob.setAnimationState(24);
            } else if (r <= 30) {
                this.mob.setAnimationState(60);
            } else if (r <= 60) {
                this.mob.setAnimationState(10);
            } else if (r <= 90) {
                this.mob.setAnimationState(11);
            } else if (r <= 130) {
                this.mob.setAnimationState(35);
            } else if (r <= 160) {
                this.mob.setAnimationState(50);
            } else if (r <= 220) {
                this.mob.setAnimationState(12);
            } else if (r <= 300) {
                this.mob.setAnimationState(70);
            } else if (r <= 325) {
                this.mob.setAnimationState(71);
            }
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = 26;
    }

    protected double getAttackReachSqr(LivingEntity p_179512_1_) {
        return this.mob.m_20205_() * 3.0f * this.mob.m_20205_() * 2.0f + p_179512_1_.m_20205_();
    }

    protected void performLightAttack() {
        Level worldIn = this.mob.f_19853_;
        Vec3 pos = this.mob.m_20182_();
        Vec3 aim = this.mob.m_20154_();
        this.mob.m_5496_(SoundEvents.f_12317_, 2.0f, 0.2f);
        AttackHitboxHelpers.LargeAttack(this.mob, pos, 5.0, -0.7853981633974483, 0.7853981633974483, 1.0, 5.0);
    }

    protected void performSlamAttack() {
        Level worldIn = this.mob.f_19853_;
        Vec3 pos = this.mob.m_20182_();
        Vec3 aim = this.mob.m_20154_();
        double x = pos.f_82479_ + 2.2 * aim.f_82479_;
        double y = pos.f_82480_;
        double z = pos.f_82481_ + 2.2 * aim.f_82481_;
        LightningBolt bolt = new LightningBolt(EntityType.f_20465_, worldIn);
        bolt.m_6034_(x + 2.4 * aim.f_82479_, y, z + 2.4 * aim.f_82479_);
        worldIn.m_7967_((Entity)bolt);
        this.mob.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 20, 40));
        AABB scanAbove = new AABB(x - 2.6, y - 1.6, z - 2.6, x + 2.6, y + 3.2, z + 2.6);
        ArrayList entities = new ArrayList(worldIn.m_45976_(LivingEntity.class, scanAbove));
        if (!entities.isEmpty()) {
            for (int i = 0; i < entities.size(); ++i) {
                LivingEntity target = (LivingEntity)entities.get(i);
                if (target == this.mob) continue;
                this.mob.m_7327_((Entity)target);
            }
        }
    }

    protected void summonWind() {
        Level worldIn = this.mob.f_19853_;
        Vec3 pos = this.mob.m_20182_();
        Vec3 aim = this.mob.m_20154_();
        Vec2 aim2d = new Vec2((float)(aim.f_82479_ / (1.0 - Math.abs(aim.f_82480_))), (float)(aim.f_82481_ / (1.0 - Math.abs(aim.f_82480_))));
        for (int i = -8; i <= 8; ++i) {
            WindNoCollisionsProjectileEntity bullet = new WindNoCollisionsProjectileEntity((EntityType<? extends AbstractHurtingProjectile>)((EntityType)ProjectileInit.WIND_NO_COLLISION.get()), worldIn, (LivingEntity)this.mob);
            double x = pos.f_82479_ + 0.8 * ((double)aim2d.f_82470_ * Math.cos((double)i * Math.PI / 8.0) - (double)aim2d.f_82471_ * Math.sin((double)i * Math.PI / 8.0));
            double z = pos.f_82481_ + 0.8 * ((double)aim2d.f_82471_ * Math.cos((double)i * Math.PI / 8.0) + (double)aim2d.f_82470_ * Math.sin((double)i * Math.PI / 8.0));
            double y = pos.f_82480_ + 0.15 * (double)i;
            this.mob.m_5496_(SoundEvents.f_12317_, 2.0f, 0.2f);
            this.mob.m_5496_(SoundEvents.f_12639_, 2.0f, 0.4f);
            bullet.m_6034_(x, y, z);
            bullet.f_36813_ = aim.f_82479_ * 0.15;
            bullet.f_36814_ = 0.0;
            bullet.f_36815_ = aim.f_82481_ * 0.15;
            bullet.setBaseDamage(14.0f);
            bullet.setMaxLifeTime(100);
            bullet.setSize(1.0f);
            worldIn.m_7967_((Entity)bullet);
        }
    }

    protected void summonWindParticles() {
        Level worldIn = this.mob.f_19853_;
        SimpleParticleType moonlight = ParticleTypes.f_123813_;
        Vec3 pos = this.mob.m_20182_();
        double x0 = pos.f_82479_ + 0.0;
        double y0 = pos.f_82480_;
        double z0 = pos.f_82481_ + 0.0;
        for (int i = 0; i <= 16; ++i) {
            for (int k = -4; k <= 4; ++k) {
                boolean j = true;
                while (k <= 3) {
                    double x = x0 + 0.8 * (double)j * Math.cos((double)i * Math.PI / 8.0) * Math.cos((double)k * Math.PI / 8.0);
                    double y = y0 - 0.0;
                    double z = z0 + 0.8 * (double)j * Math.cos((double)i * Math.PI / 8.0) * Math.sin((double)k * Math.PI / 8.0);
                    if (worldIn instanceof ServerLevel) {
                        ((ServerLevel)worldIn).m_8767_((ParticleOptions)moonlight, x, y, z, 1, 0.0, 0.0, 0.0, 0.4);
                    }
                    ++k;
                }
            }
        }
    }

    protected void summonLightiningParticlesAround() {
        Level worldIn = this.mob.f_19853_;
        DustParticleOptions lightning = new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.0f), 1.0f);
        Vec3 pos = this.mob.m_20182_();
        double x0 = pos.f_82479_ + 0.0;
        double y0 = pos.f_82480_;
        double z0 = pos.f_82481_ + 0.0;
        for (int k = 0; k <= 64; ++k) {
            double x = x0 + 2.5 * Math.cos((double)k * Math.PI / 8.0);
            double y = y0 + 2.0;
            double z = z0 + 2.5 * Math.sin((double)k * Math.PI / 8.0);
            if (!(worldIn instanceof ServerLevel)) continue;
            ((ServerLevel)worldIn).m_8767_((ParticleOptions)lightning, x, y, z, 1, 0.0, 0.0, 0.0, 0.4);
        }
    }

    protected void shootLightning(Mob playerIn, Level worldIn) {
        Vec3 pos = playerIn.m_20182_();
        Vec3 pos1 = playerIn.m_5448_().m_20182_();
        Vec3 aim = playerIn.m_20154_();
        double x = pos.f_82479_ + aim.f_82479_ * 3.0;
        double y = pos.f_82480_ + aim.f_82480_ * 3.0 + 6.0;
        double z = pos.f_82481_ + aim.f_82481_ * 3.0;
        double d = playerIn.m_20270_((Entity)playerIn.m_5448_());
        playerIn.m_5496_(SoundEvents.f_12089_, 0.5f, 3.0f);
        for (int i = 0; i <= 5; ++i) {
            LightningProjectileEntity bullet = new LightningProjectileEntity((EntityType<? extends AbstractHurtingProjectile>)((EntityType)ProjectileInit.LIGHTNING.get()), worldIn, (LivingEntity)playerIn);
            bullet.m_5602_((Entity)playerIn);
            bullet.setTarget((Entity)this.mob.m_5448_());
            bullet.setBaseDamage(10.0f);
            bullet.setMaxLifeTime(100);
            bullet.m_6034_(x + aim.f_82479_ * (1.5 + 0.25 * (double)i), y + aim.f_82480_ * (1.0 + 0.25 * (double)i), z + aim.f_82481_ * (1.5 + 0.25 * (double)i));
            bullet.f_36813_ = aim.f_82479_ * 0.2;
            bullet.f_36814_ = aim.f_82480_ * 0.2;
            bullet.f_36815_ = aim.f_82481_ * 0.2;
            worldIn.m_7967_((Entity)bullet);
        }
    }

    protected void tickLightningStorm(int time, Vec3 pos) {
        double ww = 0.5235987755982988;
        float f1 = this.mob.m_21187_().nextFloat();
        float f2 = this.mob.f_19853_.m_5822_().nextFloat();
        SwordSpearProjectileEntity bullet = new SwordSpearProjectileEntity((EntityType<? extends AbstractHurtingProjectile>)((EntityType)ProjectileInit.SWORDSPEAR.get()), this.mob.f_19853_, (LivingEntity)this.mob);
        double x = pos.f_82479_ + (double)(5.0f + f1 * 25.0f) * Math.cos((double)(f2 * 12.0f) * ww);
        double z = pos.f_82481_ + (double)(5.0f + f1 * 25.0f) * Math.sin((double)(f2 * 12.0f) * ww);
        double y = pos.f_82480_ + 18.0;
        bullet.m_5602_((Entity)this.mob);
        bullet.m_6034_(x, y, z);
        bullet.f_36813_ = 0.0;
        bullet.f_36815_ = 0.0;
        bullet.f_36814_ = -0.4;
        this.mob.f_19853_.m_7967_((Entity)bullet);
    }

    protected void doWrathOfTheGods() {
        Level worldIn = this.mob.f_19853_;
        this.mob.m_5496_(SoundEvents.f_11913_, 2.0f, 1.4f);
        SimpleParticleType force = ParticleTypes.f_123759_;
        Vec3 pos = this.mob.m_20182_();
        double x0 = pos.f_82479_;
        double y0 = pos.f_82480_ + 10.0;
        double z0 = pos.f_82481_;
        for (int i = 0; i <= 64; ++i) {
            for (int k = 0; k <= 64; ++k) {
                double x = x0 + 9.0 * Math.cos((double)i * Math.PI / 32.0) * Math.cos((double)k * Math.PI / 32.0);
                double y = y0 + 9.0 * Math.sin((double)i * Math.PI / 32.0);
                double z = z0 + 9.0 * Math.cos((double)i * Math.PI / 32.0) * Math.sin((double)k * Math.PI / 32.0);
                if (!(worldIn instanceof ServerLevel)) continue;
                ((ServerLevel)worldIn).m_8767_((ParticleOptions)force, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        AABB scanAbove = new AABB(pos.f_82479_ - 10.0, y0 - 14.0, pos.f_82481_ - 10.0, pos.f_82479_ + 10.0, y0 + 10.0, pos.f_82481_ + 10.0);
        ArrayList entities = new ArrayList(worldIn.m_45976_(LivingEntity.class, scanAbove));
        if (!entities.isEmpty()) {
            for (int n = 0; n < entities.size(); ++n) {
                LivingEntity target = (LivingEntity)entities.get(n);
                if (target == this.mob) continue;
                Vec3 targetPos = target.m_20182_();
                target.m_6469_(DamageSource.m_19370_((LivingEntity)this.mob), 8.0f);
                double d = Math.sqrt((targetPos.f_82479_ - pos.f_82479_) * (targetPos.f_82479_ - pos.f_82479_) + (targetPos.f_82481_ - pos.f_82481_) * (targetPos.f_82481_ - pos.f_82481_) + (targetPos.f_82480_ - y0) * (targetPos.f_82480_ - y0));
                target.m_147240_((double)((float)((y0 - target.m_20186_()) / (d * d))), (this.mob.m_20185_() - target.m_20185_()) / (d * d), this.mob.m_20189_() - target.m_20189_() / (d * d));
            }
        }
    }
}

