/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.darksouls.common.entities.projectiles;

import com.nitespring.darksouls.core.init.ItemInit;
import com.nitespring.darksouls.core.init.ProjectileInit;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.network.NetworkHooks;

public class WindNoCollisionsProjectileEntity
extends AbstractHurtingProjectile
implements ItemSupplier {
    private int lifeTime = 0;
    private int maxLifeTime;
    private float baseDamage;
    private float size;

    public WindNoCollisionsProjectileEntity(EntityType<? extends AbstractHurtingProjectile> p_i50174_1_, double p_i50174_2_, double p_i50174_4_, double p_i50174_6_, double p_i50174_8_, double p_i50174_10_, double p_i50174_12_, Level p_i50174_14_) {
        super((EntityType)ProjectileInit.WIND_NO_COLLISION.get(), p_i50174_2_, p_i50174_4_, p_i50174_6_, p_i50174_8_, p_i50174_10_, p_i50174_12_, p_i50174_14_);
    }

    public WindNoCollisionsProjectileEntity(EntityType<? extends AbstractHurtingProjectile> p_i50166_1_, Level p_i50166_2_, LivingEntity owner) {
        super((EntityType)ProjectileInit.WIND_NO_COLLISION.get(), p_i50166_2_);
        this.m_5602_((Entity)owner);
    }

    public WindNoCollisionsProjectileEntity(EntityType<? extends AbstractHurtingProjectile> p_i50166_1_, Level p_i50166_2_) {
        super((EntityType)ProjectileInit.WIND_NO_COLLISION.get(), p_i50166_2_);
    }

    public WindNoCollisionsProjectileEntity(EntityType<? extends AbstractHurtingProjectile> p_i50168_1_, LivingEntity p_i50168_2_, double p_i50168_3_, double p_i50168_5_, double p_i50168_7_, Level p_i50168_9_) {
        super((EntityType)ProjectileInit.WIND_NO_COLLISION.get(), p_i50168_2_, p_i50168_3_, p_i50168_5_, p_i50168_7_, p_i50168_9_);
    }

    protected ParticleOptions m_5967_() {
        SimpleParticleType particle = ParticleTypes.f_123813_;
        return particle;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6060_() {
        return false;
    }

    public void onAddedToWorld() {
        this.lifeTime = 0;
        super.onAddedToWorld();
    }

    protected void m_5790_(EntityHitResult p_213868_1_) {
        super.m_5790_(p_213868_1_);
        if (p_213868_1_.m_82443_() != this.m_37282_()) {
            p_213868_1_.m_82443_().m_6469_(DamageSource.m_19340_((Entity)this, (LivingEntity)((LivingEntity)this.m_37282_())), this.getBaseDamage());
            if (p_213868_1_.m_82443_() instanceof LivingEntity) {
                ((LivingEntity)p_213868_1_.m_82443_()).m_21335_(this.m_37282_());
            }
        }
    }

    public void m_8119_() {
        this.m_5496_(SoundEvents.f_12591_, 0.5f, 0.3f);
        this.m_5496_(SoundEvents.f_12317_, 2.0f, 0.1f);
        ++this.lifeTime;
        if (this.f_19853_ instanceof ServerLevel && this.lifeTime >= this.getMaxLifeTime()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        super.m_8119_();
    }

    public int getMaxLifeTime() {
        return this.maxLifeTime;
    }

    public void setMaxLifeTime(int maxLifeTime) {
        this.maxLifeTime = maxLifeTime;
    }

    public float getBaseDamage() {
        return this.baseDamage;
    }

    public void setBaseDamage(float physicalDamage) {
        this.baseDamage = physicalDamage;
    }

    public float getSize() {
        return this.size;
    }

    public void setSize(float size) {
        this.size = size;
    }

    public ItemStack m_7846_() {
        return ((Item)ItemInit.WIND.get()).m_7968_();
    }
}

