/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.darksouls.common.entities.projectiles;

import com.mojang.math.Vector3f;
import com.nitespring.darksouls.common.entities.projectiles.LightningProjectileEntity;
import com.nitespring.darksouls.core.init.ProjectileInit;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class LightningTurretEntity
extends Entity {
    @Nullable
    private LivingEntity owner;
    @Nullable
    private LivingEntity target;
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private UUID targetUUID;
    protected int livingTick;
    protected int shootDelayTick;

    public LightningTurretEntity(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag tag) {
        this.livingTick = tag.m_128451_("LivingTick");
        if (tag.m_128403_("Owner")) {
            this.ownerUUID = tag.m_128342_("Owner");
        }
        if (tag.m_128403_("Target")) {
            this.ownerUUID = tag.m_128342_("Target");
        }
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128405_("LivingTick", this.livingTick);
        if (this.ownerUUID != null) {
            tag.m_128362_("Owner", this.ownerUUID);
        }
        if (this.targetUUID != null) {
            tag.m_128362_("Target", this.targetUUID);
        }
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public boolean m_5825_() {
        return true;
    }

    public void setOwner(@Nullable LivingEntity p_36939_) {
        this.owner = p_36939_;
        this.ownerUUID = p_36939_ == null ? null : p_36939_.m_142081_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.f_19853_ instanceof ServerLevel && (entity = ((ServerLevel)this.f_19853_).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public void setTarget(@Nullable LivingEntity p_36939_) {
        this.target = p_36939_;
    }

    @Nullable
    public LivingEntity getTarget() {
        Entity entity;
        if (this.target == null && this.targetUUID != null && this.f_19853_ instanceof ServerLevel && (entity = ((ServerLevel)this.f_19853_).m_8791_(this.targetUUID)) instanceof LivingEntity) {
            this.target = (LivingEntity)entity;
        }
        return this.target;
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.livingTick;
        this.doLightningParticles();
        if (this.livingTick >= 15) {
            ++this.shootDelayTick;
            if (this.shootDelayTick >= 5) {
                this.shootLightningInRandomDirection();
                this.shootDelayTick = 0;
            }
        }
        if (this.livingTick >= 50) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void doLightningParticles() {
        Vec3 pos = this.m_20182_();
        Level worldIn = this.m_183503_();
        DustParticleOptions lightning = new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.0f), 1.0f);
        double x0 = pos.f_82479_;
        double y0 = pos.f_82480_;
        double z0 = pos.f_82481_;
        for (int i = 0; i <= 16; ++i) {
            for (int k = 0; k <= 16; ++k) {
                double x = x0 + 1.0 * Math.cos((double)i * Math.PI / 8.0) * Math.cos((double)k * Math.PI / 8.0);
                double y = y0 + 1.0 * Math.sin((double)i * Math.PI / 8.0);
                double z = z0 + 1.0 * Math.cos((double)i * Math.PI / 8.0) * Math.sin((double)k * Math.PI / 8.0);
                if (!(worldIn instanceof ServerLevel)) continue;
                ((ServerLevel)worldIn).m_8767_((ParticleOptions)lightning, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void shootLightningInRandomDirection() {
        Level worldIn = this.m_183503_();
        Vec3 pos = this.m_20182_();
        Vec3 aim = new Vec3((double)(new Random().nextFloat() * 2.0f - 1.0f), (double)(new Random().nextFloat() * 2.0f - 1.0f), (double)(new Random().nextFloat() * 2.0f - 1.0f));
        double x = pos.f_82479_ + aim.f_82479_ * 1.5;
        double y = pos.f_82480_ + aim.f_82480_ * 1.5;
        double z = pos.f_82481_ + aim.f_82481_ * 1.5;
        this.m_5496_(SoundEvents.f_12089_, 0.5f, 3.0f);
        for (int i = 0; i <= 5; ++i) {
            LightningProjectileEntity bullet = new LightningProjectileEntity((EntityType<? extends AbstractHurtingProjectile>)((EntityType)ProjectileInit.LIGHTNING.get()), worldIn, this.owner);
            bullet.m_5602_((Entity)this.getOwner());
            if (this.getTarget() != null) {
                bullet.setTarget((Entity)this.getTarget());
            }
            bullet.setBaseDamage(5.0f);
            bullet.setMaxLifeTime(200);
            bullet.m_6034_(x + aim.f_82479_ * (1.5 + 0.25 * (double)i), y + aim.f_82480_ * (1.0 + 0.25 * (double)i), z + aim.f_82481_ * (1.5 + 0.25 * (double)i));
            bullet.f_36813_ = aim.f_82479_ * 0.2;
            bullet.f_36814_ = aim.f_82480_ * 0.2;
            bullet.f_36815_ = aim.f_82481_ * 0.2;
            worldIn.m_7967_((Entity)bullet);
        }
    }
}

