/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.darksouls.common.entities.projectiles;

import com.mojang.math.Vector3f;
import com.nitespring.darksouls.common.CustomDamageType;
import com.nitespring.darksouls.core.helpers.MathHelpers;
import com.nitespring.darksouls.core.init.ProjectileInit;
import java.util.Random;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class LightningProjectileEntity
extends AbstractHurtingProjectile
implements IAnimatable {
    private Entity target;
    private int lifeTime;
    private int maxLifeTime;
    private float baseDamage;
    private float size;
    protected AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public LightningProjectileEntity(EntityType<? extends AbstractHurtingProjectile> p_i50174_1_, double p_i50174_2_, double p_i50174_4_, double p_i50174_6_, double p_i50174_8_, double p_i50174_10_, double p_i50174_12_, Level p_i50174_14_) {
        super((EntityType)ProjectileInit.LIGHTNING.get(), p_i50174_2_, p_i50174_4_, p_i50174_6_, p_i50174_8_, p_i50174_10_, p_i50174_12_, p_i50174_14_);
    }

    public LightningProjectileEntity(EntityType<? extends AbstractHurtingProjectile> p_i50166_1_, Level p_i50166_2_, LivingEntity owner) {
        super((EntityType)ProjectileInit.LIGHTNING.get(), p_i50166_2_);
        this.m_5602_((Entity)owner);
    }

    public LightningProjectileEntity(EntityType<? extends AbstractHurtingProjectile> p_i50166_1_, Level p_i50166_2_) {
        super((EntityType)ProjectileInit.LIGHTNING.get(), p_i50166_2_);
    }

    public LightningProjectileEntity(EntityType<? extends AbstractHurtingProjectile> p_i50168_1_, LivingEntity p_i50168_2_, double p_i50168_3_, double p_i50168_5_, double p_i50168_7_, Level p_i50168_9_) {
        super((EntityType)ProjectileInit.LIGHTNING.get(), p_i50168_2_, p_i50168_3_, p_i50168_5_, p_i50168_7_, p_i50168_9_);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.lightning.projectile", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "main_controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void m_8097_() {
        super.m_8097_();
    }

    protected ParticleOptions m_5967_() {
        DustParticleOptions particle = new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.0f), 1.0f);
        return particle;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6060_() {
        return false;
    }

    public void onAddedToWorld() {
        this.lifeTime = 0;
        super.onAddedToWorld();
    }

    protected void m_5790_(EntityHitResult p_213868_1_) {
        super.m_5790_(p_213868_1_);
        if (p_213868_1_.m_82443_() != this.m_37282_() && p_213868_1_.m_82443_() != this) {
            p_213868_1_.m_82443_().m_6469_(CustomDamageType.dsIndirectLightningDamage((Entity)this, (LivingEntity)this.m_37282_()), this.getBaseDamage());
            if (p_213868_1_.m_82443_() instanceof LivingEntity) {
                ((LivingEntity)p_213868_1_.m_82443_()).m_21335_(this.m_37282_());
            }
            this.removalInstance();
        }
    }

    protected void m_8060_(BlockHitResult p_230299_1_) {
        this.removalInstance();
        super.m_8060_(p_230299_1_);
    }

    protected void removalInstance() {
        this.m_5496_(SoundEvents.f_12089_, 0.5f, 3.0f);
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public void m_8119_() {
        Level worldIn = this.f_19853_;
        Vec3 pos = this.m_20182_();
        ParticleOptions lightning = this.m_5967_();
        Vec3 vec3 = this.m_20184_();
        double x0 = pos.f_82479_ + 0.1;
        double y0 = pos.f_82480_ + 0.1;
        double z0 = pos.f_82481_ + 0.1;
        for (int i = 0; i <= 3; ++i) {
            double x = x0 + (double)new Random().nextFloat();
            double y = y0 + (double)new Random().nextFloat();
            double z = z0 + (double)new Random().nextFloat();
            if (worldIn.f_46443_) continue;
            ((ServerLevel)worldIn).m_8767_(lightning, x, y, z, 1, 0.0, 0.0, 0.0, 0.2);
            ++this.lifeTime;
            if (this.lifeTime < this.getMaxLifeTime()) continue;
            this.removalInstance();
        }
        if (this.target != null && this.lifeTime >= 10 && this.lifeTime <= this.getMaxLifeTime() - 20 && this.m_20280_(this.target) >= 3.0) {
            Vec3 pos1 = this.getTarget().m_20182_();
            Vec3 aim = MathHelpers.AimVector(pos, new Vec3(pos1.f_82479_, pos1.f_82480_ + (double)(this.getTarget().m_20206_() / 2.0f), pos1.f_82481_));
            Vec3 mov = this.m_20184_();
            Vec3 vec = new Vec3(1.0, 2.0, 3.0);
            this.m_20256_(mov.m_82520_((aim.f_82479_ - mov.f_82479_) * 0.5, (aim.f_82480_ - mov.f_82480_) * 0.5, (aim.f_82481_ - mov.f_82481_) * 0.5));
        }
        if (worldIn.m_5776_()) {
            double d0 = vec3.m_165924_();
            this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
            this.m_146926_((float)((Mth.m_14136_((double)vec3.f_82480_, (double)d0) - 90.0) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        super.m_8119_();
    }

    public int getMaxLifeTime() {
        return this.maxLifeTime;
    }

    public void setMaxLifeTime(int maxLifeTime) {
        this.maxLifeTime = maxLifeTime;
    }

    public float getBaseDamage() {
        return this.baseDamage;
    }

    public void setBaseDamage(float physicalDamage) {
        this.baseDamage = physicalDamage;
    }

    public float getSize() {
        return this.size;
    }

    public void setSize(float size) {
        this.size = size;
    }

    public Entity getTarget() {
        return this.target;
    }

    public void setTarget(Entity e) {
        this.target = e;
    }
}

